/*
 * Decompiled with CFR 0.152.
 */
package com.chain.util;

import com.chain.api.Account;
import com.chain.api.Asset;
import com.chain.api.Transaction;
import com.chain.exception.APIException;
import com.chain.exception.ChainException;
import com.chain.http.BatchResponse;
import com.chain.http.Client;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TxBuilderWithRules
extends Transaction.Builder {
    protected static final String whitelistTag = "account_whitelist";

    public static BatchResponse<Transaction.Template> buildBatch(Client client, List<Transaction.Builder> builders) throws ChainException {
        ArrayList<Transaction.Builder> validBuilders = new ArrayList<Transaction.Builder>();
        HashMap<Integer, WhitelistViolationException> txbuilderErrs = new HashMap<Integer, WhitelistViolationException>();
        HashMap<Integer, Integer> newToOldIndex = new HashMap<Integer, Integer>();
        for (int i = 0; i < builders.size(); ++i) {
            Transaction.Builder b = builders.get(i);
            if (!(b instanceof TxBuilderWithRules)) continue;
            try {
                ((TxBuilderWithRules)b).validate(client);
                newToOldIndex.put(validBuilders.size(), i);
                validBuilders.add(b);
                continue;
            }
            catch (WhitelistViolationException e) {
                txbuilderErrs.put(i, e);
            }
        }
        BatchResponse orig = Transaction.buildBatch((Client)client, validBuilders);
        HashMap successes = new HashMap();
        HashMap errors = new HashMap();
        for (Map.Entry entry : orig.successesByIndex().entrySet()) {
            successes.put(newToOldIndex.get(entry.getKey()), entry.getValue());
        }
        for (Map.Entry entry : orig.errorsByIndex().entrySet()) {
            errors.put(newToOldIndex.get(entry.getKey()), entry.getValue());
        }
        for (Map.Entry entry : txbuilderErrs.entrySet()) {
            errors.put(entry.getKey(), entry.getValue());
        }
        return new BatchResponse(successes, errors);
    }

    public Transaction.Template build(Client client) throws ChainException {
        this.validate(client);
        return super.build(client);
    }

    protected void validate(Client client) throws ChainException {
        ArrayList<Transaction.Action.ControlWithAccount> controlActions = new ArrayList<Transaction.Action.ControlWithAccount>();
        for (Transaction.Action action : this.actions) {
            if (!(action instanceof Transaction.Action.ControlWithAccount)) continue;
            controlActions.add((Transaction.Action.ControlWithAccount)action);
        }
        if (controlActions.isEmpty()) {
            return;
        }
        HashSet<String> assetIds = new HashSet<String>();
        HashSet<String> assetAliases = new HashSet<String>();
        HashSet<String> accountIds = new HashSet<String>();
        HashSet<String> accountAliases = new HashSet<String>();
        for (Transaction.Action.ControlWithAccount action : controlActions) {
            if (action.containsKey((Object)"asset_id")) {
                assetIds.add((String)action.get((Object)"asset_id"));
            } else if (action.containsKey((Object)"asset_alias")) {
                assetAliases.add((String)action.get((Object)"asset_alias"));
            }
            if (action.containsKey((Object)"account_id")) {
                accountIds.add((String)action.get((Object)"account_id"));
                continue;
            }
            if (!action.containsKey((Object)"account_alias")) continue;
            accountAliases.add((String)action.get((Object)"account_alias"));
        }
        List<Asset> assets = Helper.getAssetsByIdOrAlias(client, new ArrayList<String>(assetIds), new ArrayList<String>(assetAliases));
        List<Account> accounts = Helper.getAccountsByIdOrAlias(client, new ArrayList<String>(accountIds), new ArrayList<String>(accountAliases));
        HashMap<String, Asset> assetsById = new HashMap<String, Asset>();
        HashMap<String, Asset> assetsByAlias = new HashMap<String, Asset>();
        HashMap<String, Account> accountsById = new HashMap<String, Account>();
        HashMap<String, Account> accountsByAlias = new HashMap<String, Account>();
        for (Asset asset : assets) {
            assetsById.put(asset.id, asset);
            if (asset.alias.length() <= 0) continue;
            assetsByAlias.put(asset.alias, asset);
        }
        for (Account account : accounts) {
            accountsById.put(account.id, account);
            if (account.alias.length() <= 0) continue;
            accountsByAlias.put(account.alias, account);
        }
        for (Transaction.Action.ControlWithAccount controlWithAccount : controlActions) {
            Asset asset = null;
            if (controlWithAccount.containsKey((Object)"asset_id")) {
                asset = (Asset)assetsById.get((String)controlWithAccount.get((Object)"asset_id"));
            } else if (controlWithAccount.containsKey((Object)"asset_alias")) {
                asset = (Asset)assetsByAlias.get((String)controlWithAccount.get((Object)"asset_alias"));
            }
            Account account = null;
            if (controlWithAccount.containsKey((Object)"account_id")) {
                account = (Account)accountsById.get((String)controlWithAccount.get((Object)"account_id"));
            } else if (controlWithAccount.containsKey((Object)"account_alias")) {
                account = (Account)accountsByAlias.get((String)controlWithAccount.get((Object)"account_alias"));
            }
            if (asset == null || account == null || asset.tags == null || asset.tags.isEmpty()) continue;
            Object tagVal = asset.tags.get(whitelistTag);
            try {
                boolean accountFound = false;
                List whitelist = (List)tagVal;
                for (Map entry : whitelist) {
                    if (!account.id.equals(entry.get("account_id")) && (account.alias == null || !account.alias.equals(entry.get("account_alias")))) continue;
                    accountFound = true;
                    break;
                }
                if (accountFound) continue;
                throw new WhitelistViolationException(asset, account);
            }
            catch (ClassCastException e) {
            }
        }
    }

    public static class Helper {
        public static List<Asset> getAssetsByIdOrAlias(Client client, List<String> assetIds, List<String> assetAliases) throws ChainException {
            int n = 1;
            ArrayList<String> toks = new ArrayList<String>();
            ArrayList<String> params = new ArrayList<String>();
            for (String id : assetIds) {
                toks.add("id=$" + n++);
                params.add(id);
            }
            for (String alias : assetAliases) {
                toks.add("alias=$" + n++);
                params.add(alias);
            }
            String filter = "";
            for (int i = 0; i < toks.size(); ++i) {
                if (i > 0) {
                    filter = filter + " OR ";
                }
                filter = filter + (String)toks.get(i);
            }
            Asset.Items assets = ((Asset.QueryBuilder)((Asset.QueryBuilder)new Asset.QueryBuilder().setFilter(filter)).setFilterParameters(params)).execute(client);
            HashSet<String> ids = new HashSet<String>();
            ArrayList<Asset> res = new ArrayList<Asset>();
            while (assets.hasNext()) {
                Asset a = (Asset)assets.next();
                if (ids.contains(a.id)) continue;
                ids.add(a.id);
                res.add(a);
            }
            return res;
        }

        public static List<Account> getAccountsByIdOrAlias(Client client, List<String> accountIds, List<String> accountAliases) throws ChainException {
            int n = 1;
            ArrayList<String> toks = new ArrayList<String>();
            ArrayList<String> params = new ArrayList<String>();
            for (String id : accountIds) {
                toks.add("id=$" + n++);
                params.add(id);
            }
            for (String alias : accountAliases) {
                toks.add("alias=$" + n++);
                params.add(alias);
            }
            String filter = "";
            for (int i = 0; i < toks.size(); ++i) {
                if (i > 0) {
                    filter = filter + " OR ";
                }
                filter = filter + (String)toks.get(i);
            }
            Account.Items accounts = ((Account.QueryBuilder)((Account.QueryBuilder)new Account.QueryBuilder().setFilter(filter)).setFilterParameters(params)).execute(client);
            HashSet<String> ids = new HashSet<String>();
            ArrayList<Account> res = new ArrayList<Account>();
            while (accounts.hasNext()) {
                Account a = (Account)accounts.next();
                if (ids.contains(a.id)) continue;
                ids.add(a.id);
                res.add(a);
            }
            return res;
        }
    }

    public static class WhitelistViolationException
    extends APIException {
        WhitelistViolationException(Asset asset, Account account) {
            super("Account \"" + account.alias + "\" (" + account.id + ")  is not a whitelisted recipient for asset \"" + asset.alias + "\" (" + asset.id + ")", "");
        }
    }
}

