/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.internal.ResultBase;
import com.chargebee.models.enums.ApiVersion;
import com.chargebee.models.enums.EventType;
import com.chargebee.models.enums.Source;
import com.chargebee.org.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.List;

public class Event
extends Resource<Event> {
    public Event(InputStream is) throws IOException {
        super(is);
        Event.apiVersionCheck(this.jsonObj);
    }

    public Event(BufferedReader rd) throws IOException {
        super(rd);
        Event.apiVersionCheck(this.jsonObj);
    }

    public Event(String jsonStr) {
        super(jsonStr);
        Event.apiVersionCheck(this.jsonObj);
    }

    public Event(JSONObject jsonObj) {
        super(jsonObj);
        Event.apiVersionCheck(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public Timestamp occurredAt() {
        return this.reqTimestamp("occurred_at");
    }

    public Source source() {
        return this.reqEnum("source", Source.class);
    }

    public String user() {
        return this.optString("user");
    }

    @Deprecated
    public WebhookStatus webhookStatus() {
        return this.reqEnum("webhook_status", WebhookStatus.class);
    }

    @Deprecated
    public String webhookFailureReason() {
        return this.optString("webhook_failure_reason");
    }

    public List<Webhook> webhooks() {
        return this.optList("webhooks", Webhook.class);
    }

    public EventType eventType() {
        return this.optEnum("event_type", EventType.class);
    }

    public ApiVersion apiVersion() {
        return this.optEnum("api_version", ApiVersion.class);
    }

    public static EventListRequest list() {
        String uri = Event.uri("events");
        return new EventListRequest(uri);
    }

    public static Request retrieve(String id) {
        String uri = Event.uri("events", Event.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public Content content() {
        return new Content(this.optJSONObject("content"));
    }

    public static class EventListRequest
    extends ListRequest<EventListRequest> {
        private EventListRequest(String uri) {
            super(uri);
        }

        @Deprecated
        public EventListRequest startTime(Timestamp startTime) {
            this.params.addOpt("start_time", startTime);
            return this;
        }

        @Deprecated
        public EventListRequest endTime(Timestamp endTime) {
            this.params.addOpt("end_time", endTime);
            return this;
        }

        public StringFilter<EventListRequest> id() {
            return new StringFilter<EventListRequest>("id", this).supportsMultiOperators(true);
        }

        public EnumFilter<WebhookStatus, EventListRequest> webhookStatus() {
            return new EnumFilter<WebhookStatus, EventListRequest>("webhook_status", this);
        }

        @Deprecated
        public EventListRequest webhookStatus(WebhookStatus webhookStatus) {
            this.params.addOpt("webhook_status", (Object)webhookStatus);
            return this;
        }

        public EnumFilter<EventType, EventListRequest> eventType() {
            return new EnumFilter<EventType, EventListRequest>("event_type", this);
        }

        @Deprecated
        public EventListRequest eventType(EventType eventType) {
            this.params.addOpt("event_type", (Object)eventType);
            return this;
        }

        public EnumFilter<Source, EventListRequest> source() {
            return new EnumFilter<Source, EventListRequest>("source", this);
        }

        public TimestampFilter<EventListRequest> occurredAt() {
            return new TimestampFilter<EventListRequest>("occurred_at", this);
        }

        public EventListRequest sortByOccurredAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "occurred_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Content
    extends ResultBase {
        public Content(JSONObject jsonObj) {
            super(jsonObj);
        }
    }

    public static class Webhook
    extends Resource<Webhook> {
        public Webhook(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public WebhookStatus webhookStatus() {
            return this.reqEnum("webhook_status", WebhookStatus.class);
        }

        public static enum WebhookStatus {
            NOT_CONFIGURED,
            SCHEDULED,
            SUCCEEDED,
            RE_SCHEDULED,
            FAILED,
            SKIPPED,
            NOT_APPLICABLE,
            _UNKNOWN;

        }
    }

    @Deprecated
    public static enum WebhookStatus {
        NOT_CONFIGURED,
        SCHEDULED,
        SUCCEEDED,
        RE_SCHEDULED,
        FAILED,
        SKIPPED,
        NOT_APPLICABLE,
        _UNKNOWN;

    }
}

