/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.CreditNote;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.TaxJurisType;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class Order
extends Resource<Order> {
    public Order(String jsonStr) {
        super(jsonStr);
    }

    public Order(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String documentNumber() {
        return this.optString("document_number");
    }

    public String invoiceId() {
        return this.optString("invoice_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public CancellationReason cancellationReason() {
        return this.optEnum("cancellation_reason", CancellationReason.class);
    }

    public PaymentStatus paymentStatus() {
        return this.optEnum("payment_status", PaymentStatus.class);
    }

    public OrderType orderType() {
        return this.optEnum("order_type", OrderType.class);
    }

    public PriceType priceType() {
        return this.reqEnum("price_type", PriceType.class);
    }

    public String referenceId() {
        return this.optString("reference_id");
    }

    public String fulfillmentStatus() {
        return this.optString("fulfillment_status");
    }

    public Timestamp orderDate() {
        return this.optTimestamp("order_date");
    }

    public Timestamp shippingDate() {
        return this.optTimestamp("shipping_date");
    }

    public String note() {
        return this.optString("note");
    }

    public String trackingId() {
        return this.optString("tracking_id");
    }

    public String trackingUrl() {
        return this.optString("tracking_url");
    }

    public String batchId() {
        return this.optString("batch_id");
    }

    public String createdBy() {
        return this.optString("created_by");
    }

    public String shipmentCarrier() {
        return this.optString("shipment_carrier");
    }

    public Integer invoiceRoundOffAmount() {
        return this.optInteger("invoice_round_off_amount");
    }

    public Integer tax() {
        return this.optInteger("tax");
    }

    public Integer amountPaid() {
        return this.optInteger("amount_paid");
    }

    public Integer amountAdjusted() {
        return this.optInteger("amount_adjusted");
    }

    public Integer refundableCreditsIssued() {
        return this.optInteger("refundable_credits_issued");
    }

    public Integer refundableCredits() {
        return this.optInteger("refundable_credits");
    }

    public Integer roundingAdjustement() {
        return this.optInteger("rounding_adjustement");
    }

    public Timestamp paidOn() {
        return this.optTimestamp("paid_on");
    }

    public Timestamp shippingCutOffDate() {
        return this.optTimestamp("shipping_cut_off_date");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp statusUpdateAt() {
        return this.optTimestamp("status_update_at");
    }

    public Timestamp deliveredAt() {
        return this.optTimestamp("delivered_at");
    }

    public Timestamp shippedAt() {
        return this.optTimestamp("shipped_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Timestamp cancelledAt() {
        return this.optTimestamp("cancelled_at");
    }

    public ResentStatus resentStatus() {
        return this.optEnum("resent_status", ResentStatus.class);
    }

    public Boolean isResent() {
        return this.reqBoolean("is_resent");
    }

    public String originalOrderId() {
        return this.optString("original_order_id");
    }

    public List<OrderLineItem> orderLineItems() {
        return this.optList("order_line_items", OrderLineItem.class);
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public BillingAddress billingAddress() {
        return this.optSubResource("billing_address", BillingAddress.class);
    }

    public Integer discount() {
        return this.optInteger("discount");
    }

    public Integer subTotal() {
        return this.optInteger("sub_total");
    }

    public Integer total() {
        return this.optInteger("total");
    }

    public List<LineItemTax> lineItemTaxes() {
        return this.optList("line_item_taxes", LineItemTax.class);
    }

    public List<LineItemDiscount> lineItemDiscounts() {
        return this.optList("line_item_discounts", LineItemDiscount.class);
    }

    public List<LinkedCreditNote> linkedCreditNotes() {
        return this.optList("linked_credit_notes", LinkedCreditNote.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public String currencyCode() {
        return this.optString("currency_code");
    }

    public Boolean isGifted() {
        return this.optBoolean("is_gifted");
    }

    public String giftNote() {
        return this.optString("gift_note");
    }

    public String giftId() {
        return this.optString("gift_id");
    }

    public String resendReason() {
        return this.optString("resend_reason");
    }

    public List<ResentOrder> resentOrders() {
        return this.optList("resent_orders", ResentOrder.class);
    }

    public String businessEntityId() {
        return this.optString("business_entity_id");
    }

    public static CreateRequest create() {
        String uri = Order.uri("orders");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = Order.uri("orders", Order.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static ImportOrderRequest importOrder() {
        String uri = Order.uri("orders", "import_order");
        return new ImportOrderRequest(HttpUtil.Method.POST, uri);
    }

    public static Request assignOrderNumber(String id) {
        String uri = Order.uri("orders", Order.nullCheck(id), "assign_order_number");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static CancelRequest cancel(String id) {
        String uri = Order.uri("orders", Order.nullCheck(id), "cancel");
        return new CancelRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateRefundableCreditNoteRequest createRefundableCreditNote(String id) {
        String uri = Order.uri("orders", Order.nullCheck(id), "create_refundable_credit_note");
        return new CreateRefundableCreditNoteRequest(HttpUtil.Method.POST, uri);
    }

    public static ReopenRequest reopen(String id) {
        String uri = Order.uri("orders", Order.nullCheck(id), "reopen");
        return new ReopenRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = Order.uri("orders", Order.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request delete(String id) {
        String uri = Order.uri("orders", Order.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static OrderListRequest list() {
        String uri = Order.uri("orders");
        return new OrderListRequest(uri);
    }

    @Deprecated
    public static ListRequest ordersForInvoice(String id) {
        String uri = Order.uri("invoices", Order.nullCheck(id), "orders");
        return new ListRequest(uri);
    }

    public static ResendRequest resend(String id) {
        String uri = Order.uri("orders", Order.nullCheck(id), "resend");
        return new ResendRequest(HttpUtil.Method.POST, uri);
    }

    public static class ResendRequest
    extends Request<ResendRequest> {
        private ResendRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ResendRequest shippingDate(Timestamp shippingDate) {
            this.params.addOpt("shipping_date", shippingDate);
            return this;
        }

        public ResendRequest resendReason(String resendReason) {
            this.params.addOpt("resend_reason", resendReason);
            return this;
        }

        public ResendRequest orderLineItemId(int index, String orderLineItemId) {
            this.params.addOpt("order_line_items[id][" + index + "]", orderLineItemId);
            return this;
        }

        public ResendRequest orderLineItemFulfillmentQuantity(int index, Integer orderLineItemFulfillmentQuantity) {
            this.params.addOpt("order_line_items[fulfillment_quantity][" + index + "]", orderLineItemFulfillmentQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class OrderListRequest
    extends ListRequest<OrderListRequest> {
        private OrderListRequest(String uri) {
            super(uri);
        }

        public OrderListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public OrderListRequest excludeDeletedCreditNotes(Boolean excludeDeletedCreditNotes) {
            this.params.addOpt("exclude_deleted_credit_notes", excludeDeletedCreditNotes);
            return this;
        }

        public StringFilter<OrderListRequest> id() {
            return new StringFilter<OrderListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<OrderListRequest> invoiceId() {
            return new StringFilter<OrderListRequest>("invoice_id", this).supportsMultiOperators(true);
        }

        public StringFilter<OrderListRequest> subscriptionId() {
            return new StringFilter<OrderListRequest>("subscription_id", this);
        }

        public EnumFilter<Status, OrderListRequest> status() {
            return new EnumFilter<Status, OrderListRequest>("status", this);
        }

        public TimestampFilter<OrderListRequest> shippingDate() {
            return new TimestampFilter<OrderListRequest>("shipping_date", this);
        }

        public TimestampFilter<OrderListRequest> shippedAt() {
            return new TimestampFilter<OrderListRequest>("shipped_at", this);
        }

        public EnumFilter<OrderType, OrderListRequest> orderType() {
            return new EnumFilter<OrderType, OrderListRequest>("order_type", this);
        }

        public TimestampFilter<OrderListRequest> orderDate() {
            return new TimestampFilter<OrderListRequest>("order_date", this);
        }

        public TimestampFilter<OrderListRequest> paidOn() {
            return new TimestampFilter<OrderListRequest>("paid_on", this);
        }

        public TimestampFilter<OrderListRequest> updatedAt() {
            return new TimestampFilter<OrderListRequest>("updated_at", this);
        }

        public TimestampFilter<OrderListRequest> createdAt() {
            return new TimestampFilter<OrderListRequest>("created_at", this);
        }

        public EnumFilter<ResentStatus, OrderListRequest> resentStatus() {
            return new EnumFilter<ResentStatus, OrderListRequest>("resent_status", this);
        }

        public BooleanFilter<OrderListRequest> isResent() {
            return new BooleanFilter<OrderListRequest>("is_resent", this);
        }

        public StringFilter<OrderListRequest> originalOrderId() {
            return new StringFilter<OrderListRequest>("original_order_id", this);
        }

        public OrderListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        public OrderListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ReopenRequest
    extends Request<ReopenRequest> {
        private ReopenRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ReopenRequest voidCancellationCreditNotes(Boolean voidCancellationCreditNotes) {
            this.params.addOpt("void_cancellation_credit_notes", voidCancellationCreditNotes);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRefundableCreditNoteRequest
    extends Request<CreateRefundableCreditNoteRequest> {
        private CreateRefundableCreditNoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRefundableCreditNoteRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public CreateRefundableCreditNoteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public CreateRefundableCreditNoteRequest creditNoteReasonCode(CreditNote.ReasonCode creditNoteReasonCode) {
            this.params.add("credit_note[reason_code]", (Object)creditNoteReasonCode);
            return this;
        }

        public CreateRefundableCreditNoteRequest creditNoteTotal(Integer creditNoteTotal) {
            this.params.add("credit_note[total]", creditNoteTotal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CancelRequest
    extends Request<CancelRequest> {
        private CancelRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CancelRequest cancellationReason(CancellationReason cancellationReason) {
            this.params.add("cancellation_reason", (Object)cancellationReason);
            return this;
        }

        public CancelRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public CancelRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public CancelRequest cancelledAt(Timestamp cancelledAt) {
            this.params.addOpt("cancelled_at", cancelledAt);
            return this;
        }

        public CancelRequest creditNoteTotal(Integer creditNoteTotal) {
            this.params.addOpt("credit_note[total]", creditNoteTotal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ImportOrderRequest
    extends Request<ImportOrderRequest> {
        private ImportOrderRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportOrderRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public ImportOrderRequest documentNumber(String documentNumber) {
            this.params.addOpt("document_number", documentNumber);
            return this;
        }

        public ImportOrderRequest invoiceId(String invoiceId) {
            this.params.add("invoice_id", invoiceId);
            return this;
        }

        public ImportOrderRequest status(Status status) {
            this.params.add("status", (Object)status);
            return this;
        }

        public ImportOrderRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ImportOrderRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ImportOrderRequest createdAt(Timestamp createdAt) {
            this.params.add("created_at", createdAt);
            return this;
        }

        public ImportOrderRequest orderDate(Timestamp orderDate) {
            this.params.add("order_date", orderDate);
            return this;
        }

        public ImportOrderRequest shippingDate(Timestamp shippingDate) {
            this.params.add("shipping_date", shippingDate);
            return this;
        }

        public ImportOrderRequest referenceId(String referenceId) {
            this.params.addOpt("reference_id", referenceId);
            return this;
        }

        public ImportOrderRequest fulfillmentStatus(String fulfillmentStatus) {
            this.params.addOpt("fulfillment_status", fulfillmentStatus);
            return this;
        }

        public ImportOrderRequest note(String note) {
            this.params.addOpt("note", note);
            return this;
        }

        public ImportOrderRequest trackingId(String trackingId) {
            this.params.addOpt("tracking_id", trackingId);
            return this;
        }

        public ImportOrderRequest trackingUrl(String trackingUrl) {
            this.params.addOpt("tracking_url", trackingUrl);
            return this;
        }

        public ImportOrderRequest batchId(String batchId) {
            this.params.addOpt("batch_id", batchId);
            return this;
        }

        public ImportOrderRequest shipmentCarrier(String shipmentCarrier) {
            this.params.addOpt("shipment_carrier", shipmentCarrier);
            return this;
        }

        public ImportOrderRequest shippingCutOffDate(Timestamp shippingCutOffDate) {
            this.params.addOpt("shipping_cut_off_date", shippingCutOffDate);
            return this;
        }

        public ImportOrderRequest deliveredAt(Timestamp deliveredAt) {
            this.params.addOpt("delivered_at", deliveredAt);
            return this;
        }

        public ImportOrderRequest shippedAt(Timestamp shippedAt) {
            this.params.addOpt("shipped_at", shippedAt);
            return this;
        }

        public ImportOrderRequest cancelledAt(Timestamp cancelledAt) {
            this.params.addOpt("cancelled_at", cancelledAt);
            return this;
        }

        public ImportOrderRequest cancellationReason(CancellationReason cancellationReason) {
            this.params.addOpt("cancellation_reason", (Object)cancellationReason);
            return this;
        }

        public ImportOrderRequest refundableCreditsIssued(Integer refundableCreditsIssued) {
            this.params.addOpt("refundable_credits_issued", refundableCreditsIssued);
            return this;
        }

        public ImportOrderRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public ImportOrderRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public ImportOrderRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public ImportOrderRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public ImportOrderRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public ImportOrderRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public ImportOrderRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public ImportOrderRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public ImportOrderRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public ImportOrderRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public ImportOrderRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public ImportOrderRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public ImportOrderRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public ImportOrderRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public ImportOrderRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public ImportOrderRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public ImportOrderRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public ImportOrderRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public ImportOrderRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public ImportOrderRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public ImportOrderRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public ImportOrderRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public ImportOrderRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public ImportOrderRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public ImportOrderRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public ImportOrderRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public ImportOrderRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public ImportOrderRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest referenceId(String referenceId) {
            this.params.addOpt("reference_id", referenceId);
            return this;
        }

        public UpdateRequest batchId(String batchId) {
            this.params.addOpt("batch_id", batchId);
            return this;
        }

        public UpdateRequest note(String note) {
            this.params.addOpt("note", note);
            return this;
        }

        public UpdateRequest shippingDate(Timestamp shippingDate) {
            this.params.addOpt("shipping_date", shippingDate);
            return this;
        }

        public UpdateRequest orderDate(Timestamp orderDate) {
            this.params.addOpt("order_date", orderDate);
            return this;
        }

        public UpdateRequest cancelledAt(Timestamp cancelledAt) {
            this.params.addOpt("cancelled_at", cancelledAt);
            return this;
        }

        public UpdateRequest cancellationReason(CancellationReason cancellationReason) {
            this.params.addOpt("cancellation_reason", (Object)cancellationReason);
            return this;
        }

        public UpdateRequest shippedAt(Timestamp shippedAt) {
            this.params.addOpt("shipped_at", shippedAt);
            return this;
        }

        public UpdateRequest deliveredAt(Timestamp deliveredAt) {
            this.params.addOpt("delivered_at", deliveredAt);
            return this;
        }

        public UpdateRequest trackingUrl(String trackingUrl) {
            this.params.addOpt("tracking_url", trackingUrl);
            return this;
        }

        public UpdateRequest trackingId(String trackingId) {
            this.params.addOpt("tracking_id", trackingId);
            return this;
        }

        public UpdateRequest shipmentCarrier(String shipmentCarrier) {
            this.params.addOpt("shipment_carrier", shipmentCarrier);
            return this;
        }

        public UpdateRequest fulfillmentStatus(String fulfillmentStatus) {
            this.params.addOpt("fulfillment_status", fulfillmentStatus);
            return this;
        }

        public UpdateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public UpdateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public UpdateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public UpdateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public UpdateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public UpdateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public UpdateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public UpdateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public UpdateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public UpdateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public UpdateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public UpdateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public UpdateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public UpdateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public UpdateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public UpdateRequest orderLineItemId(int index, String orderLineItemId) {
            this.params.addOpt("order_line_items[id][" + index + "]", orderLineItemId);
            return this;
        }

        public UpdateRequest orderLineItemStatus(int index, OrderLineItem.Status orderLineItemStatus) {
            this.params.addOpt("order_line_items[status][" + index + "]", (Object)orderLineItemStatus);
            return this;
        }

        public UpdateRequest orderLineItemSku(int index, String orderLineItemSku) {
            this.params.addOpt("order_line_items[sku][" + index + "]", orderLineItemSku);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateRequest invoiceId(String invoiceId) {
            this.params.add("invoice_id", invoiceId);
            return this;
        }

        public CreateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public CreateRequest referenceId(String referenceId) {
            this.params.addOpt("reference_id", referenceId);
            return this;
        }

        public CreateRequest fulfillmentStatus(String fulfillmentStatus) {
            this.params.addOpt("fulfillment_status", fulfillmentStatus);
            return this;
        }

        public CreateRequest note(String note) {
            this.params.addOpt("note", note);
            return this;
        }

        public CreateRequest trackingId(String trackingId) {
            this.params.addOpt("tracking_id", trackingId);
            return this;
        }

        public CreateRequest trackingUrl(String trackingUrl) {
            this.params.addOpt("tracking_url", trackingUrl);
            return this;
        }

        public CreateRequest batchId(String batchId) {
            this.params.addOpt("batch_id", batchId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ResentOrder
    extends Resource<ResentOrder> {
        public ResentOrder(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String orderId() {
            return this.reqString("order_id");
        }

        public String reason() {
            return this.optString("reason");
        }

        public Integer amount() {
            return this.optInteger("amount");
        }
    }

    public static class LinkedCreditNote
    extends Resource<LinkedCreditNote> {
        public LinkedCreditNote(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.optInteger("amount");
        }

        public Type type() {
            return this.reqEnum("type", Type.class);
        }

        public String id() {
            return this.reqString("id");
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public Integer amountAdjusted() {
            return this.optInteger("amount_adjusted");
        }

        public Integer amountRefunded() {
            return this.optInteger("amount_refunded");
        }

        public static enum Status {
            ADJUSTED,
            REFUNDED,
            REFUND_DUE,
            VOIDED,
            _UNKNOWN;

        }

        public static enum Type {
            ADJUSTMENT,
            REFUNDABLE,
            _UNKNOWN;

        }
    }

    public static class LineItemDiscount
    extends Resource<LineItemDiscount> {
        public LineItemDiscount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.reqString("line_item_id");
        }

        public DiscountType discountType() {
            return this.reqEnum("discount_type", DiscountType.class);
        }

        @Deprecated
        public String couponId() {
            return this.optString("coupon_id");
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public Integer discountAmount() {
            return this.reqInteger("discount_amount");
        }

        public static enum DiscountType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            CUSTOM_DISCOUNT,
            ITEM_LEVEL_DISCOUNT,
            DOCUMENT_LEVEL_DISCOUNT,
            _UNKNOWN;

        }
    }

    public static class LineItemTax
    extends Resource<LineItemTax> {
        public LineItemTax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public String taxName() {
            return this.reqString("tax_name");
        }

        public Double taxRate() {
            return this.reqDouble("tax_rate");
        }

        public Boolean isPartialTaxApplied() {
            return this.optBoolean("is_partial_tax_applied");
        }

        public Boolean isNonComplianceTax() {
            return this.optBoolean("is_non_compliance_tax");
        }

        public Integer taxableAmount() {
            return this.reqInteger("taxable_amount");
        }

        public Integer taxAmount() {
            return this.reqInteger("tax_amount");
        }

        public TaxJurisType taxJurisType() {
            return this.optEnum("tax_juris_type", TaxJurisType.class);
        }

        public String taxJurisName() {
            return this.optString("tax_juris_name");
        }

        public String taxJurisCode() {
            return this.optString("tax_juris_code");
        }

        public Integer taxAmountInLocalCurrency() {
            return this.optInteger("tax_amount_in_local_currency");
        }

        public String localCurrencyCode() {
            return this.optString("local_currency_code");
        }
    }

    public static class BillingAddress
    extends Resource<BillingAddress> {
        public BillingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }

        public Integer index() {
            return this.reqInteger("index");
        }
    }

    public static class OrderLineItem
    extends Resource<OrderLineItem> {
        public OrderLineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public String invoiceId() {
            return this.reqString("invoice_id");
        }

        public String invoiceLineItemId() {
            return this.reqString("invoice_line_item_id");
        }

        public Integer unitPrice() {
            return this.optInteger("unit_price");
        }

        public String description() {
            return this.optString("description");
        }

        public Integer amount() {
            return this.optInteger("amount");
        }

        public Integer fulfillmentQuantity() {
            return this.optInteger("fulfillment_quantity");
        }

        public Integer fulfillmentAmount() {
            return this.optInteger("fulfillment_amount");
        }

        public Integer taxAmount() {
            return this.optInteger("tax_amount");
        }

        public Integer amountPaid() {
            return this.optInteger("amount_paid");
        }

        public Integer amountAdjusted() {
            return this.optInteger("amount_adjusted");
        }

        public Integer refundableCreditsIssued() {
            return this.optInteger("refundable_credits_issued");
        }

        public Integer refundableCredits() {
            return this.optInteger("refundable_credits");
        }

        public Boolean isShippable() {
            return this.reqBoolean("is_shippable");
        }

        public String sku() {
            return this.optString("sku");
        }

        public Status status() {
            return this.optEnum("status", Status.class);
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public Integer itemLevelDiscountAmount() {
            return this.optInteger("item_level_discount_amount");
        }

        public Integer discountAmount() {
            return this.optInteger("discount_amount");
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public static enum EntityType {
            PLAN_SETUP,
            PLAN,
            ADDON,
            ADHOC,
            PLAN_ITEM_PRICE,
            ADDON_ITEM_PRICE,
            CHARGE_ITEM_PRICE,
            _UNKNOWN;

        }

        public static enum Status {
            QUEUED,
            AWAITING_SHIPMENT,
            ON_HOLD,
            DELIVERED,
            SHIPPED,
            PARTIALLY_DELIVERED,
            RETURNED,
            CANCELLED,
            _UNKNOWN;

        }
    }

    public static enum ResentStatus {
        FULLY_RESENT,
        PARTIALLY_RESENT,
        _UNKNOWN;

    }

    public static enum OrderType {
        MANUAL,
        SYSTEM_GENERATED,
        _UNKNOWN;

    }

    public static enum PaymentStatus {
        NOT_PAID,
        PAID,
        _UNKNOWN;

    }

    public static enum CancellationReason {
        SHIPPING_CUT_OFF_PASSED,
        PRODUCT_UNSATISFACTORY,
        THIRD_PARTY_CANCELLATION,
        PRODUCT_NOT_REQUIRED,
        DELIVERY_DATE_MISSED,
        ALTERNATIVE_FOUND,
        INVOICE_WRITTEN_OFF,
        INVOICE_VOIDED,
        FRAUDULENT_TRANSACTION,
        PAYMENT_DECLINED,
        SUBSCRIPTION_CANCELLED,
        PRODUCT_NOT_AVAILABLE,
        OTHERS,
        ORDER_RESENT,
        _UNKNOWN;

    }

    public static enum Status {
        NEW,
        PROCESSING,
        COMPLETE,
        CANCELLED,
        VOIDED,
        QUEUED,
        AWAITING_SHIPMENT,
        ON_HOLD,
        DELIVERED,
        SHIPPED,
        PARTIALLY_DELIVERED,
        RETURNED,
        _UNKNOWN;

    }
}

