/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.Resource;
import com.chargebee.models.enums.TrialEndAction;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class SubscriptionEstimate
extends Resource<SubscriptionEstimate> {
    public SubscriptionEstimate(String jsonStr) {
        super(jsonStr);
    }

    public SubscriptionEstimate(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.optString("id");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public TrialEndAction trialEndAction() {
        return this.optEnum("trial_end_action", TrialEndAction.class);
    }

    public Timestamp nextBillingAt() {
        return this.optTimestamp("next_billing_at");
    }

    public Timestamp pauseDate() {
        return this.optTimestamp("pause_date");
    }

    public Timestamp resumeDate() {
        return this.optTimestamp("resume_date");
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public ContractTerm contractTerm() {
        return this.optSubResource("contract_term", ContractTerm.class);
    }

    public static class ContractTerm
    extends Resource<ContractTerm> {
        public ContractTerm(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public Timestamp contractStart() {
            return this.reqTimestamp("contract_start");
        }

        public Timestamp contractEnd() {
            return this.reqTimestamp("contract_end");
        }

        public Integer billingCycle() {
            return this.reqInteger("billing_cycle");
        }

        public ActionAtTermEnd actionAtTermEnd() {
            return this.reqEnum("action_at_term_end", ActionAtTermEnd.class);
        }

        public Long totalContractValue() {
            return this.reqLong("total_contract_value");
        }

        public Long totalContractValueBeforeTax() {
            return this.reqLong("total_contract_value_before_tax");
        }

        public Integer cancellationCutoffPeriod() {
            return this.optInteger("cancellation_cutoff_period");
        }

        public Timestamp createdAt() {
            return this.reqTimestamp("created_at");
        }

        public String subscriptionId() {
            return this.reqString("subscription_id");
        }

        public Integer remainingBillingCycles() {
            return this.optInteger("remaining_billing_cycles");
        }

        public static enum ActionAtTermEnd {
            RENEW,
            EVERGREEN,
            CANCEL,
            RENEW_ONCE,
            _UNKNOWN;

        }

        public static enum Status {
            ACTIVE,
            COMPLETED,
            CANCELLED,
            TERMINATED,
            _UNKNOWN;

        }
    }

    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }

        public Integer index() {
            return this.reqInteger("index");
        }
    }

    public static enum Status {
        FUTURE,
        IN_TRIAL,
        ACTIVE,
        NON_RENEWING,
        PAUSED,
        CANCELLED,
        _UNKNOWN;

    }
}

