/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee;

import com.chargebee.ApiResponse;
import com.chargebee.internal.ResultBase;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONException;
import com.chargebee.org.json.JSONObject;
import java.util.ArrayList;

public class ListResult
extends ArrayList<Entry>
implements ApiResponse {
    public final int httpCode;
    private JSONObject respJson;

    public ListResult(int httpCode, JSONObject respJson) {
        this.httpCode = httpCode;
        this.respJson = respJson;
        this.initEntries();
    }

    @Override
    public int httpCode() {
        return this.httpCode;
    }

    @Override
    public JSONObject jsonResponse() {
        return this.respJson;
    }

    private void initEntries() {
        try {
            JSONArray arr = this.respJson.getJSONArray("list");
            for (int i = 0; i < arr.length(); ++i) {
                this.add(new Entry(arr.getJSONObject(i)));
            }
        }
        catch (JSONException exp) {
            throw new RuntimeException(exp.getMessage());
        }
    }

    public String nextOffset() {
        String cursor = this.respJson.optString("next_offset");
        return cursor == null || cursor.isEmpty() ? null : cursor;
    }

    @Override
    public String toString() {
        try {
            return this.respJson.toString(2);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class Entry
    extends ResultBase {
        public Entry(JSONObject entryJson) {
            super(entryJson);
        }
    }
}

