/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Channel;
import com.chargebee.models.enums.ChargeOnEvent;
import com.chargebee.models.enums.ItemType;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class AttachedItem
extends Resource<AttachedItem> {
    public AttachedItem(String jsonStr) {
        super(jsonStr);
    }

    public AttachedItem(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String parentItemId() {
        return this.reqString("parent_item_id");
    }

    public String itemId() {
        return this.reqString("item_id");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public Integer quantity() {
        return this.optInteger("quantity");
    }

    public String quantityInDecimal() {
        return this.optString("quantity_in_decimal");
    }

    public Integer billingCycles() {
        return this.optInteger("billing_cycles");
    }

    public ChargeOnEvent chargeOnEvent() {
        return this.reqEnum("charge_on_event", ChargeOnEvent.class);
    }

    public Boolean chargeOnce() {
        return this.reqBoolean("charge_once");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Channel channel() {
        return this.optEnum("channel", Channel.class);
    }

    public static CreateRequest create(String id) {
        String uri = AttachedItem.uri("items", AttachedItem.nullCheck(id), "attached_items");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = AttachedItem.uri("attached_items", AttachedItem.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static RetrieveRequest retrieve(String id) {
        String uri = AttachedItem.uri("attached_items", AttachedItem.nullCheck(id));
        return new RetrieveRequest(HttpUtil.Method.GET, uri);
    }

    public static DeleteRequest delete(String id) {
        String uri = AttachedItem.uri("attached_items", AttachedItem.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    public static AttachedItemListRequest list(String id) {
        String uri = AttachedItem.uri("items", AttachedItem.nullCheck(id), "attached_items");
        return new AttachedItemListRequest(uri);
    }

    public static class AttachedItemListRequest
    extends ListRequest<AttachedItemListRequest> {
        private AttachedItemListRequest(String uri) {
            super(uri);
        }

        public StringFilter<AttachedItemListRequest> id() {
            return new StringFilter<AttachedItemListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<AttachedItemListRequest> itemId() {
            return new StringFilter<AttachedItemListRequest>("item_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, AttachedItemListRequest> type() {
            return new EnumFilter<Type, AttachedItemListRequest>("type", this);
        }

        public EnumFilter<ItemType, AttachedItemListRequest> itemType() {
            return new EnumFilter<ItemType, AttachedItemListRequest>("item_type", this);
        }

        public EnumFilter<ChargeOnEvent, AttachedItemListRequest> chargeOnEvent() {
            return new EnumFilter<ChargeOnEvent, AttachedItemListRequest>("charge_on_event", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest parentItemId(String parentItemId) {
            this.params.add("parent_item_id", parentItemId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RetrieveRequest
    extends Request<RetrieveRequest> {
        private RetrieveRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RetrieveRequest parentItemId(String parentItemId) {
            this.params.add("parent_item_id", parentItemId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest parentItemId(String parentItemId) {
            this.params.add("parent_item_id", parentItemId);
            return this;
        }

        public UpdateRequest type(Type type) {
            this.params.addOpt("type", (Object)type);
            return this;
        }

        public UpdateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public UpdateRequest quantity(Integer quantity) {
            this.params.addOpt("quantity", quantity);
            return this;
        }

        public UpdateRequest quantityInDecimal(String quantityInDecimal) {
            this.params.addOpt("quantity_in_decimal", quantityInDecimal);
            return this;
        }

        public UpdateRequest chargeOnEvent(ChargeOnEvent chargeOnEvent) {
            this.params.addOpt("charge_on_event", (Object)chargeOnEvent);
            return this;
        }

        public UpdateRequest chargeOnce(Boolean chargeOnce) {
            this.params.addOpt("charge_once", chargeOnce);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest itemId(String itemId) {
            this.params.add("item_id", itemId);
            return this;
        }

        public CreateRequest type(Type type) {
            this.params.addOpt("type", (Object)type);
            return this;
        }

        public CreateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateRequest quantity(Integer quantity) {
            this.params.addOpt("quantity", quantity);
            return this;
        }

        public CreateRequest quantityInDecimal(String quantityInDecimal) {
            this.params.addOpt("quantity_in_decimal", quantityInDecimal);
            return this;
        }

        public CreateRequest chargeOnEvent(ChargeOnEvent chargeOnEvent) {
            this.params.addOpt("charge_on_event", (Object)chargeOnEvent);
            return this;
        }

        public CreateRequest chargeOnce(Boolean chargeOnce) {
            this.params.addOpt("charge_once", chargeOnce);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum Status {
        ACTIVE,
        ARCHIVED,
        DELETED,
        _UNKNOWN;

    }

    public static enum Type {
        RECOMMENDED,
        MANDATORY,
        OPTIONAL,
        _UNKNOWN;

    }
}

