/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;

public class InAppSubscription
extends Resource<InAppSubscription> {
    public InAppSubscription(String jsonStr) {
        super(jsonStr);
    }

    public InAppSubscription(JSONObject jsonObj) {
        super(jsonObj);
    }

    @Deprecated
    public String appId() {
        return this.reqString("app_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public String planId() {
        return this.optString("plan_id");
    }

    public static ProcessReceiptRequest processReceipt(String id) {
        String uri = InAppSubscription.uri("in_app_subscriptions", InAppSubscription.nullCheck(id), "process_purchase_command");
        return new ProcessReceiptRequest(HttpUtil.Method.POST, uri);
    }

    public static ImportReceiptRequest importReceipt(String id) {
        String uri = InAppSubscription.uri("in_app_subscriptions", InAppSubscription.nullCheck(id), "import_receipt");
        return new ImportReceiptRequest(HttpUtil.Method.POST, uri);
    }

    public static class ImportReceiptRequest
    extends Request<ImportReceiptRequest> {
        private ImportReceiptRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportReceiptRequest receipt(String receipt) {
            this.params.add("receipt", receipt);
            return this;
        }

        public ImportReceiptRequest productCurrencyCode(String productCurrencyCode) {
            this.params.add("product[currency_code]", productCurrencyCode);
            return this;
        }

        public ImportReceiptRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public ImportReceiptRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ProcessReceiptRequest
    extends Request<ProcessReceiptRequest> {
        private ProcessReceiptRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ProcessReceiptRequest receipt(String receipt) {
            this.params.add("receipt", receipt);
            return this;
        }

        public ProcessReceiptRequest productId(String productId) {
            this.params.add("product[id]", productId);
            return this;
        }

        public ProcessReceiptRequest productName(String productName) {
            this.params.addOpt("product[name]", productName);
            return this;
        }

        public ProcessReceiptRequest productCurrencyCode(String productCurrencyCode) {
            this.params.add("product[currency_code]", productCurrencyCode);
            return this;
        }

        public ProcessReceiptRequest productPrice(Long productPrice) {
            this.params.add("product[price]", productPrice);
            return this;
        }

        public ProcessReceiptRequest productPriceInDecimal(String productPriceInDecimal) {
            this.params.addOpt("product[price_in_decimal]", productPriceInDecimal);
            return this;
        }

        public ProcessReceiptRequest productPeriod(String productPeriod) {
            this.params.addOpt("product[period]", productPeriod);
            return this;
        }

        public ProcessReceiptRequest productPeriodUnit(String productPeriodUnit) {
            this.params.addOpt("product[period_unit]", productPeriodUnit);
            return this;
        }

        public ProcessReceiptRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }
}

