/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.CreditNote;
import com.chargebee.models.PaymentIntent;
import com.chargebee.models.Transaction;
import com.chargebee.models.enums.AccountHolderType;
import com.chargebee.models.enums.AccountType;
import com.chargebee.models.enums.ApplyOn;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.AvalaraSaleType;
import com.chargebee.models.enums.Channel;
import com.chargebee.models.enums.DispositionType;
import com.chargebee.models.enums.DunningType;
import com.chargebee.models.enums.EcheckType;
import com.chargebee.models.enums.EntityType;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.models.enums.TaxExemptReason;
import com.chargebee.models.enums.TaxJurisType;
import com.chargebee.models.enums.TaxOverrideReason;
import com.chargebee.models.enums.Type;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;

public class Invoice
extends Resource<Invoice> {
    public Invoice(String jsonStr) {
        super(jsonStr);
    }

    public Invoice(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String poNumber() {
        return this.optString("po_number");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public Boolean recurring() {
        return this.reqBoolean("recurring");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String vatNumber() {
        return this.optString("vat_number");
    }

    public PriceType priceType() {
        return this.reqEnum("price_type", PriceType.class);
    }

    public Timestamp date() {
        return this.optTimestamp("date");
    }

    public Timestamp dueDate() {
        return this.optTimestamp("due_date");
    }

    public Integer netTermDays() {
        return this.optInteger("net_term_days");
    }

    public BigDecimal exchangeRate() {
        return this.optBigDecimal("exchange_rate");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Long total() {
        return this.optLong("total");
    }

    public Long amountPaid() {
        return this.optLong("amount_paid");
    }

    public Long amountAdjusted() {
        return this.optLong("amount_adjusted");
    }

    public Long writeOffAmount() {
        return this.optLong("write_off_amount");
    }

    public Long creditsApplied() {
        return this.optLong("credits_applied");
    }

    public Long amountDue() {
        return this.optLong("amount_due");
    }

    public Timestamp paidAt() {
        return this.optTimestamp("paid_at");
    }

    public DunningStatus dunningStatus() {
        return this.optEnum("dunning_status", DunningStatus.class);
    }

    public Timestamp nextRetryAt() {
        return this.optTimestamp("next_retry_at");
    }

    public Timestamp voidedAt() {
        return this.optTimestamp("voided_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Long subTotal() {
        return this.reqLong("sub_total");
    }

    public Long subTotalInLocalCurrency() {
        return this.optLong("sub_total_in_local_currency");
    }

    public Long totalInLocalCurrency() {
        return this.optLong("total_in_local_currency");
    }

    public String localCurrencyCode() {
        return this.optString("local_currency_code");
    }

    public Long tax() {
        return this.reqLong("tax");
    }

    public Boolean firstInvoice() {
        return this.optBoolean("first_invoice");
    }

    public Long newSalesAmount() {
        return this.optLong("new_sales_amount");
    }

    public Boolean hasAdvanceCharges() {
        return this.optBoolean("has_advance_charges");
    }

    public Boolean termFinalized() {
        return this.reqBoolean("term_finalized");
    }

    public Boolean isGifted() {
        return this.reqBoolean("is_gifted");
    }

    public Timestamp generatedAt() {
        return this.optTimestamp("generated_at");
    }

    public Timestamp expectedPaymentDate() {
        return this.optTimestamp("expected_payment_date");
    }

    public Long amountToCollect() {
        return this.optLong("amount_to_collect");
    }

    public Long roundOffAmount() {
        return this.optLong("round_off_amount");
    }

    public List<LineItem> lineItems() {
        return this.optList("line_items", LineItem.class);
    }

    public List<Discount> discounts() {
        return this.optList("discounts", Discount.class);
    }

    public List<LineItemDiscount> lineItemDiscounts() {
        return this.optList("line_item_discounts", LineItemDiscount.class);
    }

    public List<Tax> taxes() {
        return this.optList("taxes", Tax.class);
    }

    public List<LineItemTax> lineItemTaxes() {
        return this.optList("line_item_taxes", LineItemTax.class);
    }

    public List<LineItemTier> lineItemTiers() {
        return this.optList("line_item_tiers", LineItemTier.class);
    }

    public List<LinkedPayment> linkedPayments() {
        return this.optList("linked_payments", LinkedPayment.class);
    }

    public List<DunningAttempt> dunningAttempts() {
        return this.optList("dunning_attempts", DunningAttempt.class);
    }

    public List<AppliedCredit> appliedCredits() {
        return this.optList("applied_credits", AppliedCredit.class);
    }

    public List<AdjustmentCreditNote> adjustmentCreditNotes() {
        return this.optList("adjustment_credit_notes", AdjustmentCreditNote.class);
    }

    public List<IssuedCreditNote> issuedCreditNotes() {
        return this.optList("issued_credit_notes", IssuedCreditNote.class);
    }

    public List<LinkedOrder> linkedOrders() {
        return this.optList("linked_orders", LinkedOrder.class);
    }

    public List<Note> notes() {
        return this.optList("notes", Note.class);
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public BillingAddress billingAddress() {
        return this.optSubResource("billing_address", BillingAddress.class);
    }

    public Einvoice einvoice() {
        return this.optSubResource("einvoice", Einvoice.class);
    }

    public String paymentOwner() {
        return this.optString("payment_owner");
    }

    public String voidReasonCode() {
        return this.optString("void_reason_code");
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public String vatNumberPrefix() {
        return this.optString("vat_number_prefix");
    }

    public Channel channel() {
        return this.optEnum("channel", Channel.class);
    }

    public String businessEntityId() {
        return this.reqString("business_entity_id");
    }

    public static CreateRequest create() {
        String uri = Invoice.uri("invoices");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateForChargeItemsAndChargesRequest createForChargeItemsAndCharges() {
        String uri = Invoice.uri("invoices", "create_for_charge_items_and_charges");
        return new CreateForChargeItemsAndChargesRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeRequest charge() {
        String uri = Invoice.uri("invoices", "charge");
        return new ChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeAddonRequest chargeAddon() {
        String uri = Invoice.uri("invoices", "charge_addon");
        return new ChargeAddonRequest(HttpUtil.Method.POST, uri);
    }

    @Deprecated
    public static CreateForChargeItemRequest createForChargeItem() {
        String uri = Invoice.uri("invoices", "create_for_charge_item");
        return new CreateForChargeItemRequest(HttpUtil.Method.POST, uri);
    }

    public static StopDunningRequest stopDunning(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "stop_dunning");
        return new StopDunningRequest(HttpUtil.Method.POST, uri);
    }

    public static ImportInvoiceRequest importInvoice() {
        String uri = Invoice.uri("invoices", "import_invoice");
        return new ImportInvoiceRequest(HttpUtil.Method.POST, uri);
    }

    public static ApplyPaymentsRequest applyPayments(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "apply_payments");
        return new ApplyPaymentsRequest(HttpUtil.Method.POST, uri);
    }

    public static Request syncUsages(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "sync_usages");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static ApplyCreditsRequest applyCredits(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "apply_credits");
        return new ApplyCreditsRequest(HttpUtil.Method.POST, uri);
    }

    public static InvoiceListRequest list() {
        String uri = Invoice.uri("invoices");
        return new InvoiceListRequest(uri);
    }

    @Deprecated
    public static ListRequest invoicesForCustomer(String id) {
        String uri = Invoice.uri("customers", Invoice.nullCheck(id), "invoices");
        return new ListRequest(uri);
    }

    @Deprecated
    public static ListRequest invoicesForSubscription(String id) {
        String uri = Invoice.uri("subscriptions", Invoice.nullCheck(id), "invoices");
        return new ListRequest(uri);
    }

    public static Request retrieve(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static PdfRequest pdf(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "pdf");
        return new PdfRequest(HttpUtil.Method.POST, uri);
    }

    public static Request downloadEinvoice(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "download_einvoice");
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static AddChargeRequest addCharge(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "add_charge");
        return new AddChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static AddAddonChargeRequest addAddonCharge(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "add_addon_charge");
        return new AddAddonChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static AddChargeItemRequest addChargeItem(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "add_charge_item");
        return new AddChargeItemRequest(HttpUtil.Method.POST, uri);
    }

    public static CloseRequest close(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "close");
        return new CloseRequest(HttpUtil.Method.POST, uri);
    }

    public static CollectPaymentRequest collectPayment(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "collect_payment");
        return new CollectPaymentRequest(HttpUtil.Method.POST, uri);
    }

    public static RecordPaymentRequest recordPayment(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "record_payment");
        return new RecordPaymentRequest(HttpUtil.Method.POST, uri);
    }

    public static RefundRequest refund(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "refund");
        return new RefundRequest(HttpUtil.Method.POST, uri);
    }

    public static RecordRefundRequest recordRefund(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "record_refund");
        return new RecordRefundRequest(HttpUtil.Method.POST, uri);
    }

    public static RemovePaymentRequest removePayment(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "remove_payment");
        return new RemovePaymentRequest(HttpUtil.Method.POST, uri);
    }

    public static RemoveCreditNoteRequest removeCreditNote(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "remove_credit_note");
        return new RemoveCreditNoteRequest(HttpUtil.Method.POST, uri);
    }

    public static VoidInvoiceRequest voidInvoice(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "void");
        return new VoidInvoiceRequest(HttpUtil.Method.POST, uri);
    }

    public static WriteOffRequest writeOff(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "write_off");
        return new WriteOffRequest(HttpUtil.Method.POST, uri);
    }

    public static DeleteRequest delete(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateDetailsRequest updateDetails(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "update_details");
        return new UpdateDetailsRequest(HttpUtil.Method.POST, uri);
    }

    public static Request resendEinvoice(String id) {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "resend_einvoice");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class UpdateDetailsRequest
    extends Request<UpdateDetailsRequest> {
        private UpdateDetailsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateDetailsRequest vatNumber(String vatNumber) {
            this.params.addOpt("vat_number", vatNumber);
            return this;
        }

        public UpdateDetailsRequest vatNumberPrefix(String vatNumberPrefix) {
            this.params.addOpt("vat_number_prefix", vatNumberPrefix);
            return this;
        }

        public UpdateDetailsRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public UpdateDetailsRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public UpdateDetailsRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public UpdateDetailsRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public UpdateDetailsRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public UpdateDetailsRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public UpdateDetailsRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public UpdateDetailsRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public UpdateDetailsRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public UpdateDetailsRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public UpdateDetailsRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public UpdateDetailsRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public UpdateDetailsRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public UpdateDetailsRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public UpdateDetailsRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public UpdateDetailsRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public UpdateDetailsRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public UpdateDetailsRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public UpdateDetailsRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public UpdateDetailsRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public UpdateDetailsRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public UpdateDetailsRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public UpdateDetailsRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public UpdateDetailsRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public UpdateDetailsRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public UpdateDetailsRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public UpdateDetailsRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public UpdateDetailsRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public UpdateDetailsRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public UpdateDetailsRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public DeleteRequest claimCredits(Boolean claimCredits) {
            this.params.addOpt("claim_credits", claimCredits);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class WriteOffRequest
    extends Request<WriteOffRequest> {
        private WriteOffRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public WriteOffRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class VoidInvoiceRequest
    extends Request<VoidInvoiceRequest> {
        private VoidInvoiceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public VoidInvoiceRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public VoidInvoiceRequest voidReasonCode(String voidReasonCode) {
            this.params.addOpt("void_reason_code", voidReasonCode);
            return this;
        }

        @Deprecated
        public VoidInvoiceRequest createCreditNote(Boolean createCreditNote) {
            this.params.addOpt("create_credit_note", createCreditNote);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RemoveCreditNoteRequest
    extends Request<RemoveCreditNoteRequest> {
        private RemoveCreditNoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemoveCreditNoteRequest creditNoteId(String creditNoteId) {
            this.params.add("credit_note[id]", creditNoteId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RemovePaymentRequest
    extends Request<RemovePaymentRequest> {
        private RemovePaymentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemovePaymentRequest transactionId(String transactionId) {
            this.params.add("transaction[id]", transactionId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RecordRefundRequest
    extends Request<RecordRefundRequest> {
        private RecordRefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordRefundRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RecordRefundRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public RecordRefundRequest transactionAmount(Long transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public RecordRefundRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.add("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public RecordRefundRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public RecordRefundRequest transactionDate(Timestamp transactionDate) {
            this.params.add("transaction[date]", transactionDate);
            return this;
        }

        public RecordRefundRequest creditNoteReasonCode(CreditNote.ReasonCode creditNoteReasonCode) {
            this.params.addOpt("credit_note[reason_code]", (Object)creditNoteReasonCode);
            return this;
        }

        public RecordRefundRequest creditNoteCreateReasonCode(String creditNoteCreateReasonCode) {
            this.params.addOpt("credit_note[create_reason_code]", creditNoteCreateReasonCode);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RefundRequest
    extends Request<RefundRequest> {
        private RefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RefundRequest refundAmount(Long refundAmount) {
            this.params.addOpt("refund_amount", refundAmount);
            return this;
        }

        public RefundRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RefundRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public RefundRequest creditNoteReasonCode(CreditNote.ReasonCode creditNoteReasonCode) {
            this.params.addOpt("credit_note[reason_code]", (Object)creditNoteReasonCode);
            return this;
        }

        public RefundRequest creditNoteCreateReasonCode(String creditNoteCreateReasonCode) {
            this.params.addOpt("credit_note[create_reason_code]", creditNoteCreateReasonCode);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RecordPaymentRequest
    extends Request<RecordPaymentRequest> {
        private RecordPaymentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordPaymentRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RecordPaymentRequest transactionAmount(Long transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public RecordPaymentRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.add("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public RecordPaymentRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public RecordPaymentRequest transactionIdAtGateway(String transactionIdAtGateway) {
            this.params.addOpt("transaction[id_at_gateway]", transactionIdAtGateway);
            return this;
        }

        public RecordPaymentRequest transactionStatus(Transaction.Status transactionStatus) {
            this.params.addOpt("transaction[status]", (Object)transactionStatus);
            return this;
        }

        public RecordPaymentRequest transactionDate(Timestamp transactionDate) {
            this.params.addOpt("transaction[date]", transactionDate);
            return this;
        }

        public RecordPaymentRequest transactionErrorCode(String transactionErrorCode) {
            this.params.addOpt("transaction[error_code]", transactionErrorCode);
            return this;
        }

        public RecordPaymentRequest transactionErrorText(String transactionErrorText) {
            this.params.addOpt("transaction[error_text]", transactionErrorText);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CollectPaymentRequest
    extends Request<CollectPaymentRequest> {
        private CollectPaymentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CollectPaymentRequest amount(Long amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public CollectPaymentRequest authorizationTransactionId(String authorizationTransactionId) {
            this.params.addOpt("authorization_transaction_id", authorizationTransactionId);
            return this;
        }

        public CollectPaymentRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CollectPaymentRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CloseRequest
    extends Request<CloseRequest> {
        private CloseRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CloseRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public CloseRequest invoiceNote(String invoiceNote) {
            this.params.addOpt("invoice_note", invoiceNote);
            return this;
        }

        public CloseRequest removeGeneralNote(Boolean removeGeneralNote) {
            this.params.addOpt("remove_general_note", removeGeneralNote);
            return this;
        }

        public CloseRequest invoiceDate(Timestamp invoiceDate) {
            this.params.addOpt("invoice_date", invoiceDate);
            return this;
        }

        public CloseRequest notesToRemoveEntityType(int index, EntityType notesToRemoveEntityType) {
            this.params.addOpt("notes_to_remove[entity_type][" + index + "]", (Object)notesToRemoveEntityType);
            return this;
        }

        public CloseRequest notesToRemoveEntityId(int index, String notesToRemoveEntityId) {
            this.params.addOpt("notes_to_remove[entity_id][" + index + "]", notesToRemoveEntityId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AddChargeItemRequest
    extends Request<AddChargeItemRequest> {
        private AddChargeItemRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddChargeItemRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public AddChargeItemRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public AddChargeItemRequest itemPriceItemPriceId(String itemPriceItemPriceId) {
            this.params.add("item_price[item_price_id]", itemPriceItemPriceId);
            return this;
        }

        public AddChargeItemRequest itemPriceQuantity(Integer itemPriceQuantity) {
            this.params.addOpt("item_price[quantity]", itemPriceQuantity);
            return this;
        }

        public AddChargeItemRequest itemPriceQuantityInDecimal(String itemPriceQuantityInDecimal) {
            this.params.addOpt("item_price[quantity_in_decimal]", itemPriceQuantityInDecimal);
            return this;
        }

        public AddChargeItemRequest itemPriceUnitPrice(Long itemPriceUnitPrice) {
            this.params.addOpt("item_price[unit_price]", itemPriceUnitPrice);
            return this;
        }

        public AddChargeItemRequest itemPriceUnitPriceInDecimal(String itemPriceUnitPriceInDecimal) {
            this.params.addOpt("item_price[unit_price_in_decimal]", itemPriceUnitPriceInDecimal);
            return this;
        }

        public AddChargeItemRequest itemPriceDateFrom(Timestamp itemPriceDateFrom) {
            this.params.addOpt("item_price[date_from]", itemPriceDateFrom);
            return this;
        }

        public AddChargeItemRequest itemPriceDateTo(Timestamp itemPriceDateTo) {
            this.params.addOpt("item_price[date_to]", itemPriceDateTo);
            return this;
        }

        public AddChargeItemRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public AddChargeItemRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public AddChargeItemRequest itemTierPrice(int index, Long itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public AddChargeItemRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public AddChargeItemRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public AddChargeItemRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AddAddonChargeRequest
    extends Request<AddAddonChargeRequest> {
        private AddAddonChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddAddonChargeRequest addonId(String addonId) {
            this.params.add("addon_id", addonId);
            return this;
        }

        public AddAddonChargeRequest addonQuantity(Integer addonQuantity) {
            this.params.addOpt("addon_quantity", addonQuantity);
            return this;
        }

        public AddAddonChargeRequest addonUnitPrice(Long addonUnitPrice) {
            this.params.addOpt("addon_unit_price", addonUnitPrice);
            return this;
        }

        public AddAddonChargeRequest addonQuantityInDecimal(String addonQuantityInDecimal) {
            this.params.addOpt("addon_quantity_in_decimal", addonQuantityInDecimal);
            return this;
        }

        public AddAddonChargeRequest addonUnitPriceInDecimal(String addonUnitPriceInDecimal) {
            this.params.addOpt("addon_unit_price_in_decimal", addonUnitPriceInDecimal);
            return this;
        }

        public AddAddonChargeRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public AddAddonChargeRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public AddAddonChargeRequest lineItemDateFrom(Timestamp lineItemDateFrom) {
            this.params.addOpt("line_item[date_from]", lineItemDateFrom);
            return this;
        }

        public AddAddonChargeRequest lineItemDateTo(Timestamp lineItemDateTo) {
            this.params.addOpt("line_item[date_to]", lineItemDateTo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AddChargeRequest
    extends Request<AddChargeRequest> {
        private AddChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddChargeRequest amount(Long amount) {
            this.params.add("amount", amount);
            return this;
        }

        public AddChargeRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public AddChargeRequest avalaraSaleType(AvalaraSaleType avalaraSaleType) {
            this.params.addOpt("avalara_sale_type", (Object)avalaraSaleType);
            return this;
        }

        public AddChargeRequest avalaraTransactionType(Integer avalaraTransactionType) {
            this.params.addOpt("avalara_transaction_type", avalaraTransactionType);
            return this;
        }

        public AddChargeRequest avalaraServiceType(Integer avalaraServiceType) {
            this.params.addOpt("avalara_service_type", avalaraServiceType);
            return this;
        }

        public AddChargeRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public AddChargeRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public AddChargeRequest lineItemDateFrom(Timestamp lineItemDateFrom) {
            this.params.addOpt("line_item[date_from]", lineItemDateFrom);
            return this;
        }

        public AddChargeRequest lineItemDateTo(Timestamp lineItemDateTo) {
            this.params.addOpt("line_item[date_to]", lineItemDateTo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class PdfRequest
    extends Request<PdfRequest> {
        private PdfRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public PdfRequest dispositionType(DispositionType dispositionType) {
            this.params.addOpt("disposition_type", (Object)dispositionType);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class InvoiceListRequest
    extends ListRequest<InvoiceListRequest> {
        private InvoiceListRequest(String uri) {
            super(uri);
        }

        @Deprecated
        public InvoiceListRequest paidOnAfter(Timestamp paidOnAfter) {
            this.params.addOpt("paid_on_after", paidOnAfter);
            return this;
        }

        public InvoiceListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<InvoiceListRequest> id() {
            return new StringFilter<InvoiceListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<InvoiceListRequest> subscriptionId() {
            return new StringFilter<InvoiceListRequest>("subscription_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<InvoiceListRequest> customerId() {
            return new StringFilter<InvoiceListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public BooleanFilter<InvoiceListRequest> recurring() {
            return new BooleanFilter<InvoiceListRequest>("recurring", this);
        }

        public EnumFilter<Status, InvoiceListRequest> status() {
            return new EnumFilter<Status, InvoiceListRequest>("status", this);
        }

        public EnumFilter<PriceType, InvoiceListRequest> priceType() {
            return new EnumFilter<PriceType, InvoiceListRequest>("price_type", this);
        }

        public TimestampFilter<InvoiceListRequest> date() {
            return new TimestampFilter<InvoiceListRequest>("date", this);
        }

        public TimestampFilter<InvoiceListRequest> paidAt() {
            return new TimestampFilter<InvoiceListRequest>("paid_at", this);
        }

        public NumberFilter<Long, InvoiceListRequest> total() {
            return new NumberFilter<Long, InvoiceListRequest>("total", this);
        }

        public NumberFilter<Long, InvoiceListRequest> amountPaid() {
            return new NumberFilter<Long, InvoiceListRequest>("amount_paid", this);
        }

        public NumberFilter<Long, InvoiceListRequest> amountAdjusted() {
            return new NumberFilter<Long, InvoiceListRequest>("amount_adjusted", this);
        }

        public NumberFilter<Long, InvoiceListRequest> creditsApplied() {
            return new NumberFilter<Long, InvoiceListRequest>("credits_applied", this);
        }

        public NumberFilter<Long, InvoiceListRequest> amountDue() {
            return new NumberFilter<Long, InvoiceListRequest>("amount_due", this);
        }

        public EnumFilter<DunningStatus, InvoiceListRequest> dunningStatus() {
            return new EnumFilter("dunning_status", this).supportsPresenceOperator(true);
        }

        public StringFilter<InvoiceListRequest> paymentOwner() {
            return new StringFilter<InvoiceListRequest>("payment_owner", this).supportsMultiOperators(true);
        }

        public TimestampFilter<InvoiceListRequest> updatedAt() {
            return new TimestampFilter<InvoiceListRequest>("updated_at", this);
        }

        public EnumFilter<Channel, InvoiceListRequest> channel() {
            return new EnumFilter<Channel, InvoiceListRequest>("channel", this);
        }

        public TimestampFilter<InvoiceListRequest> voidedAt() {
            return new TimestampFilter<InvoiceListRequest>("voided_at", this);
        }

        public StringFilter<InvoiceListRequest> voidReasonCode() {
            return new StringFilter<InvoiceListRequest>("void_reason_code", this).supportsMultiOperators(true);
        }

        public InvoiceListRequest sortByDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "date");
            return this;
        }

        public InvoiceListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        public EnumFilter<Einvoice.Status, InvoiceListRequest> einvoiceStatus() {
            return new EnumFilter<Einvoice.Status, InvoiceListRequest>("einvoice[status]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ApplyCreditsRequest
    extends Request<ApplyCreditsRequest> {
        private ApplyCreditsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ApplyCreditsRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public ApplyCreditsRequest creditNoteId(int index, String creditNoteId) {
            this.params.addOpt("credit_notes[id][" + index + "]", creditNoteId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ApplyPaymentsRequest
    extends Request<ApplyPaymentsRequest> {
        private ApplyPaymentsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ApplyPaymentsRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public ApplyPaymentsRequest transactionId(int index, String transactionId) {
            this.params.addOpt("transactions[id][" + index + "]", transactionId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ImportInvoiceRequest
    extends Request<ImportInvoiceRequest> {
        private ImportInvoiceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportInvoiceRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public ImportInvoiceRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public ImportInvoiceRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ImportInvoiceRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ImportInvoiceRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public ImportInvoiceRequest priceType(PriceType priceType) {
            this.params.addOpt("price_type", (Object)priceType);
            return this;
        }

        public ImportInvoiceRequest taxOverrideReason(TaxOverrideReason taxOverrideReason) {
            this.params.addOpt("tax_override_reason", (Object)taxOverrideReason);
            return this;
        }

        public ImportInvoiceRequest vatNumber(String vatNumber) {
            this.params.addOpt("vat_number", vatNumber);
            return this;
        }

        public ImportInvoiceRequest vatNumberPrefix(String vatNumberPrefix) {
            this.params.addOpt("vat_number_prefix", vatNumberPrefix);
            return this;
        }

        public ImportInvoiceRequest date(Timestamp date) {
            this.params.add("date", date);
            return this;
        }

        public ImportInvoiceRequest total(Long total) {
            this.params.add("total", total);
            return this;
        }

        public ImportInvoiceRequest roundOff(Long roundOff) {
            this.params.addOpt("round_off", roundOff);
            return this;
        }

        public ImportInvoiceRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public ImportInvoiceRequest voidedAt(Timestamp voidedAt) {
            this.params.addOpt("voided_at", voidedAt);
            return this;
        }

        public ImportInvoiceRequest voidReasonCode(String voidReasonCode) {
            this.params.addOpt("void_reason_code", voidReasonCode);
            return this;
        }

        public ImportInvoiceRequest isWrittenOff(Boolean isWrittenOff) {
            this.params.addOpt("is_written_off", isWrittenOff);
            return this;
        }

        public ImportInvoiceRequest writeOffAmount(Long writeOffAmount) {
            this.params.addOpt("write_off_amount", writeOffAmount);
            return this;
        }

        public ImportInvoiceRequest writeOffDate(Timestamp writeOffDate) {
            this.params.addOpt("write_off_date", writeOffDate);
            return this;
        }

        public ImportInvoiceRequest dueDate(Timestamp dueDate) {
            this.params.addOpt("due_date", dueDate);
            return this;
        }

        public ImportInvoiceRequest netTermDays(Integer netTermDays) {
            this.params.addOpt("net_term_days", netTermDays);
            return this;
        }

        public ImportInvoiceRequest useForProration(Boolean useForProration) {
            this.params.addOpt("use_for_proration", useForProration);
            return this;
        }

        public ImportInvoiceRequest creditNoteId(String creditNoteId) {
            this.params.addOpt("credit_note[id]", creditNoteId);
            return this;
        }

        public ImportInvoiceRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public ImportInvoiceRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public ImportInvoiceRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public ImportInvoiceRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public ImportInvoiceRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public ImportInvoiceRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public ImportInvoiceRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public ImportInvoiceRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public ImportInvoiceRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public ImportInvoiceRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public ImportInvoiceRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public ImportInvoiceRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public ImportInvoiceRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public ImportInvoiceRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public ImportInvoiceRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public ImportInvoiceRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public ImportInvoiceRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public ImportInvoiceRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public ImportInvoiceRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public ImportInvoiceRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public ImportInvoiceRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public ImportInvoiceRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public ImportInvoiceRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public ImportInvoiceRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public ImportInvoiceRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public ImportInvoiceRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public ImportInvoiceRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public ImportInvoiceRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public ImportInvoiceRequest lineItemId(int index, String lineItemId) {
            this.params.addOpt("line_items[id][" + index + "]", lineItemId);
            return this;
        }

        public ImportInvoiceRequest lineItemDateFrom(int index, Timestamp lineItemDateFrom) {
            this.params.addOpt("line_items[date_from][" + index + "]", lineItemDateFrom);
            return this;
        }

        public ImportInvoiceRequest lineItemDateTo(int index, Timestamp lineItemDateTo) {
            this.params.addOpt("line_items[date_to][" + index + "]", lineItemDateTo);
            return this;
        }

        public ImportInvoiceRequest lineItemSubscriptionId(int index, String lineItemSubscriptionId) {
            this.params.addOpt("line_items[subscription_id][" + index + "]", lineItemSubscriptionId);
            return this;
        }

        public ImportInvoiceRequest lineItemDescription(int index, String lineItemDescription) {
            this.params.add("line_items[description][" + index + "]", lineItemDescription);
            return this;
        }

        public ImportInvoiceRequest lineItemUnitAmount(int index, Long lineItemUnitAmount) {
            this.params.addOpt("line_items[unit_amount][" + index + "]", lineItemUnitAmount);
            return this;
        }

        public ImportInvoiceRequest lineItemQuantity(int index, Integer lineItemQuantity) {
            this.params.addOpt("line_items[quantity][" + index + "]", lineItemQuantity);
            return this;
        }

        public ImportInvoiceRequest lineItemAmount(int index, Long lineItemAmount) {
            this.params.addOpt("line_items[amount][" + index + "]", lineItemAmount);
            return this;
        }

        public ImportInvoiceRequest lineItemUnitAmountInDecimal(int index, String lineItemUnitAmountInDecimal) {
            this.params.addOpt("line_items[unit_amount_in_decimal][" + index + "]", lineItemUnitAmountInDecimal);
            return this;
        }

        public ImportInvoiceRequest lineItemQuantityInDecimal(int index, String lineItemQuantityInDecimal) {
            this.params.addOpt("line_items[quantity_in_decimal][" + index + "]", lineItemQuantityInDecimal);
            return this;
        }

        public ImportInvoiceRequest lineItemAmountInDecimal(int index, String lineItemAmountInDecimal) {
            this.params.addOpt("line_items[amount_in_decimal][" + index + "]", lineItemAmountInDecimal);
            return this;
        }

        public ImportInvoiceRequest lineItemEntityType(int index, LineItem.EntityType lineItemEntityType) {
            this.params.addOpt("line_items[entity_type][" + index + "]", (Object)lineItemEntityType);
            return this;
        }

        public ImportInvoiceRequest lineItemEntityId(int index, String lineItemEntityId) {
            this.params.addOpt("line_items[entity_id][" + index + "]", lineItemEntityId);
            return this;
        }

        public ImportInvoiceRequest lineItemItemLevelDiscount1EntityId(int index, String lineItemItemLevelDiscount1EntityId) {
            this.params.addOpt("line_items[item_level_discount1_entity_id][" + index + "]", lineItemItemLevelDiscount1EntityId);
            return this;
        }

        public ImportInvoiceRequest lineItemItemLevelDiscount1Amount(int index, Long lineItemItemLevelDiscount1Amount) {
            this.params.addOpt("line_items[item_level_discount1_amount][" + index + "]", lineItemItemLevelDiscount1Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemItemLevelDiscount2EntityId(int index, String lineItemItemLevelDiscount2EntityId) {
            this.params.addOpt("line_items[item_level_discount2_entity_id][" + index + "]", lineItemItemLevelDiscount2EntityId);
            return this;
        }

        public ImportInvoiceRequest lineItemItemLevelDiscount2Amount(int index, Long lineItemItemLevelDiscount2Amount) {
            this.params.addOpt("line_items[item_level_discount2_amount][" + index + "]", lineItemItemLevelDiscount2Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax1Name(int index, String lineItemTax1Name) {
            this.params.addOpt("line_items[tax1_name][" + index + "]", lineItemTax1Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax1Amount(int index, Long lineItemTax1Amount) {
            this.params.addOpt("line_items[tax1_amount][" + index + "]", lineItemTax1Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax2Name(int index, String lineItemTax2Name) {
            this.params.addOpt("line_items[tax2_name][" + index + "]", lineItemTax2Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax2Amount(int index, Long lineItemTax2Amount) {
            this.params.addOpt("line_items[tax2_amount][" + index + "]", lineItemTax2Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax3Name(int index, String lineItemTax3Name) {
            this.params.addOpt("line_items[tax3_name][" + index + "]", lineItemTax3Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax3Amount(int index, Long lineItemTax3Amount) {
            this.params.addOpt("line_items[tax3_amount][" + index + "]", lineItemTax3Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax4Name(int index, String lineItemTax4Name) {
            this.params.addOpt("line_items[tax4_name][" + index + "]", lineItemTax4Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax4Amount(int index, Long lineItemTax4Amount) {
            this.params.addOpt("line_items[tax4_amount][" + index + "]", lineItemTax4Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax5Name(int index, String lineItemTax5Name) {
            this.params.addOpt("line_items[tax5_name][" + index + "]", lineItemTax5Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax5Amount(int index, Long lineItemTax5Amount) {
            this.params.addOpt("line_items[tax5_amount][" + index + "]", lineItemTax5Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax6Name(int index, String lineItemTax6Name) {
            this.params.addOpt("line_items[tax6_name][" + index + "]", lineItemTax6Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax6Amount(int index, Long lineItemTax6Amount) {
            this.params.addOpt("line_items[tax6_amount][" + index + "]", lineItemTax6Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax7Name(int index, String lineItemTax7Name) {
            this.params.addOpt("line_items[tax7_name][" + index + "]", lineItemTax7Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax7Amount(int index, Long lineItemTax7Amount) {
            this.params.addOpt("line_items[tax7_amount][" + index + "]", lineItemTax7Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax8Name(int index, String lineItemTax8Name) {
            this.params.addOpt("line_items[tax8_name][" + index + "]", lineItemTax8Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax8Amount(int index, Long lineItemTax8Amount) {
            this.params.addOpt("line_items[tax8_amount][" + index + "]", lineItemTax8Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax9Name(int index, String lineItemTax9Name) {
            this.params.addOpt("line_items[tax9_name][" + index + "]", lineItemTax9Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax9Amount(int index, Long lineItemTax9Amount) {
            this.params.addOpt("line_items[tax9_amount][" + index + "]", lineItemTax9Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax10Name(int index, String lineItemTax10Name) {
            this.params.addOpt("line_items[tax10_name][" + index + "]", lineItemTax10Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax10Amount(int index, Long lineItemTax10Amount) {
            this.params.addOpt("line_items[tax10_amount][" + index + "]", lineItemTax10Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTierLineItemId(int index, String lineItemTierLineItemId) {
            this.params.add("line_item_tiers[line_item_id][" + index + "]", lineItemTierLineItemId);
            return this;
        }

        public ImportInvoiceRequest lineItemTierStartingUnit(int index, Integer lineItemTierStartingUnit) {
            this.params.addOpt("line_item_tiers[starting_unit][" + index + "]", lineItemTierStartingUnit);
            return this;
        }

        public ImportInvoiceRequest lineItemTierEndingUnit(int index, Integer lineItemTierEndingUnit) {
            this.params.addOpt("line_item_tiers[ending_unit][" + index + "]", lineItemTierEndingUnit);
            return this;
        }

        public ImportInvoiceRequest lineItemTierQuantityUsed(int index, Integer lineItemTierQuantityUsed) {
            this.params.addOpt("line_item_tiers[quantity_used][" + index + "]", lineItemTierQuantityUsed);
            return this;
        }

        public ImportInvoiceRequest lineItemTierUnitAmount(int index, Long lineItemTierUnitAmount) {
            this.params.addOpt("line_item_tiers[unit_amount][" + index + "]", lineItemTierUnitAmount);
            return this;
        }

        public ImportInvoiceRequest lineItemTierStartingUnitInDecimal(int index, String lineItemTierStartingUnitInDecimal) {
            this.params.addOpt("line_item_tiers[starting_unit_in_decimal][" + index + "]", lineItemTierStartingUnitInDecimal);
            return this;
        }

        public ImportInvoiceRequest lineItemTierEndingUnitInDecimal(int index, String lineItemTierEndingUnitInDecimal) {
            this.params.addOpt("line_item_tiers[ending_unit_in_decimal][" + index + "]", lineItemTierEndingUnitInDecimal);
            return this;
        }

        public ImportInvoiceRequest lineItemTierQuantityUsedInDecimal(int index, String lineItemTierQuantityUsedInDecimal) {
            this.params.addOpt("line_item_tiers[quantity_used_in_decimal][" + index + "]", lineItemTierQuantityUsedInDecimal);
            return this;
        }

        public ImportInvoiceRequest lineItemTierUnitAmountInDecimal(int index, String lineItemTierUnitAmountInDecimal) {
            this.params.addOpt("line_item_tiers[unit_amount_in_decimal][" + index + "]", lineItemTierUnitAmountInDecimal);
            return this;
        }

        public ImportInvoiceRequest discountLineItemId(int index, String discountLineItemId) {
            this.params.addOpt("discounts[line_item_id][" + index + "]", discountLineItemId);
            return this;
        }

        public ImportInvoiceRequest discountEntityType(int index, Discount.EntityType discountEntityType) {
            this.params.add("discounts[entity_type][" + index + "]", (Object)discountEntityType);
            return this;
        }

        public ImportInvoiceRequest discountEntityId(int index, String discountEntityId) {
            this.params.addOpt("discounts[entity_id][" + index + "]", discountEntityId);
            return this;
        }

        public ImportInvoiceRequest discountDescription(int index, String discountDescription) {
            this.params.addOpt("discounts[description][" + index + "]", discountDescription);
            return this;
        }

        public ImportInvoiceRequest discountAmount(int index, Long discountAmount) {
            this.params.add("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public ImportInvoiceRequest taxName(int index, String taxName) {
            this.params.add("taxes[name][" + index + "]", taxName);
            return this;
        }

        public ImportInvoiceRequest taxRate(int index, Double taxRate) {
            this.params.add("taxes[rate][" + index + "]", taxRate);
            return this;
        }

        public ImportInvoiceRequest taxAmount(int index, Long taxAmount) {
            this.params.addOpt("taxes[amount][" + index + "]", taxAmount);
            return this;
        }

        public ImportInvoiceRequest taxDescription(int index, String taxDescription) {
            this.params.addOpt("taxes[description][" + index + "]", taxDescription);
            return this;
        }

        public ImportInvoiceRequest taxJurisType(int index, TaxJurisType taxJurisType) {
            this.params.addOpt("taxes[juris_type][" + index + "]", (Object)taxJurisType);
            return this;
        }

        public ImportInvoiceRequest taxJurisName(int index, String taxJurisName) {
            this.params.addOpt("taxes[juris_name][" + index + "]", taxJurisName);
            return this;
        }

        public ImportInvoiceRequest taxJurisCode(int index, String taxJurisCode) {
            this.params.addOpt("taxes[juris_code][" + index + "]", taxJurisCode);
            return this;
        }

        public ImportInvoiceRequest paymentAmount(int index, Long paymentAmount) {
            this.params.add("payments[amount][" + index + "]", paymentAmount);
            return this;
        }

        public ImportInvoiceRequest paymentPaymentMethod(int index, PaymentMethod paymentPaymentMethod) {
            this.params.add("payments[payment_method][" + index + "]", (Object)paymentPaymentMethod);
            return this;
        }

        public ImportInvoiceRequest paymentDate(int index, Timestamp paymentDate) {
            this.params.addOpt("payments[date][" + index + "]", paymentDate);
            return this;
        }

        public ImportInvoiceRequest paymentReferenceNumber(int index, String paymentReferenceNumber) {
            this.params.addOpt("payments[reference_number][" + index + "]", paymentReferenceNumber);
            return this;
        }

        public ImportInvoiceRequest noteEntityType(int index, Note.EntityType noteEntityType) {
            this.params.addOpt("notes[entity_type][" + index + "]", (Object)noteEntityType);
            return this;
        }

        public ImportInvoiceRequest noteEntityId(int index, String noteEntityId) {
            this.params.addOpt("notes[entity_id][" + index + "]", noteEntityId);
            return this;
        }

        public ImportInvoiceRequest noteNote(int index, String noteNote) {
            this.params.addOpt("notes[note][" + index + "]", noteNote);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class StopDunningRequest
    extends Request<StopDunningRequest> {
        private StopDunningRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StopDunningRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateForChargeItemRequest
    extends Request<CreateForChargeItemRequest> {
        private CreateForChargeItemRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateForChargeItemRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public CreateForChargeItemRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public CreateForChargeItemRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public CreateForChargeItemRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateForChargeItemRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CreateForChargeItemRequest invoiceDate(Timestamp invoiceDate) {
            this.params.addOpt("invoice_date", invoiceDate);
            return this;
        }

        public CreateForChargeItemRequest itemPriceItemPriceId(String itemPriceItemPriceId) {
            this.params.add("item_price[item_price_id]", itemPriceItemPriceId);
            return this;
        }

        public CreateForChargeItemRequest itemPriceQuantity(Integer itemPriceQuantity) {
            this.params.addOpt("item_price[quantity]", itemPriceQuantity);
            return this;
        }

        public CreateForChargeItemRequest itemPriceQuantityInDecimal(String itemPriceQuantityInDecimal) {
            this.params.addOpt("item_price[quantity_in_decimal]", itemPriceQuantityInDecimal);
            return this;
        }

        public CreateForChargeItemRequest itemPriceUnitPrice(Long itemPriceUnitPrice) {
            this.params.addOpt("item_price[unit_price]", itemPriceUnitPrice);
            return this;
        }

        public CreateForChargeItemRequest itemPriceUnitPriceInDecimal(String itemPriceUnitPriceInDecimal) {
            this.params.addOpt("item_price[unit_price_in_decimal]", itemPriceUnitPriceInDecimal);
            return this;
        }

        public CreateForChargeItemRequest itemPriceDateFrom(Timestamp itemPriceDateFrom) {
            this.params.addOpt("item_price[date_from]", itemPriceDateFrom);
            return this;
        }

        public CreateForChargeItemRequest itemPriceDateTo(Timestamp itemPriceDateTo) {
            this.params.addOpt("item_price[date_to]", itemPriceDateTo);
            return this;
        }

        public CreateForChargeItemRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public CreateForChargeItemRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public CreateForChargeItemRequest itemTierPrice(int index, Long itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public CreateForChargeItemRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public CreateForChargeItemRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public CreateForChargeItemRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ChargeAddonRequest
    extends Request<ChargeAddonRequest> {
        private ChargeAddonRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeAddonRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ChargeAddonRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ChargeAddonRequest addonId(String addonId) {
            this.params.add("addon_id", addonId);
            return this;
        }

        public ChargeAddonRequest addonQuantity(Integer addonQuantity) {
            this.params.addOpt("addon_quantity", addonQuantity);
            return this;
        }

        public ChargeAddonRequest addonUnitPrice(Long addonUnitPrice) {
            this.params.addOpt("addon_unit_price", addonUnitPrice);
            return this;
        }

        public ChargeAddonRequest addonQuantityInDecimal(String addonQuantityInDecimal) {
            this.params.addOpt("addon_quantity_in_decimal", addonQuantityInDecimal);
            return this;
        }

        public ChargeAddonRequest addonUnitPriceInDecimal(String addonUnitPriceInDecimal) {
            this.params.addOpt("addon_unit_price_in_decimal", addonUnitPriceInDecimal);
            return this;
        }

        public ChargeAddonRequest dateFrom(Timestamp dateFrom) {
            this.params.addOpt("date_from", dateFrom);
            return this;
        }

        public ChargeAddonRequest dateTo(Timestamp dateTo) {
            this.params.addOpt("date_to", dateTo);
            return this;
        }

        public ChargeAddonRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public ChargeAddonRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        @Deprecated
        public ChargeAddonRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public ChargeAddonRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public ChargeAddonRequest invoiceDate(Timestamp invoiceDate) {
            this.params.addOpt("invoice_date", invoiceDate);
            return this;
        }

        public ChargeAddonRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ChargeRequest
    extends Request<ChargeRequest> {
        private ChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ChargeRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ChargeRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public ChargeRequest amount(Long amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public ChargeRequest amountInDecimal(String amountInDecimal) {
            this.params.addOpt("amount_in_decimal", amountInDecimal);
            return this;
        }

        public ChargeRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public ChargeRequest dateFrom(Timestamp dateFrom) {
            this.params.addOpt("date_from", dateFrom);
            return this;
        }

        public ChargeRequest dateTo(Timestamp dateTo) {
            this.params.addOpt("date_to", dateTo);
            return this;
        }

        public ChargeRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public ChargeRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        @Deprecated
        public ChargeRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public ChargeRequest avalaraSaleType(AvalaraSaleType avalaraSaleType) {
            this.params.addOpt("avalara_sale_type", (Object)avalaraSaleType);
            return this;
        }

        public ChargeRequest avalaraTransactionType(Integer avalaraTransactionType) {
            this.params.addOpt("avalara_transaction_type", avalaraTransactionType);
            return this;
        }

        public ChargeRequest avalaraServiceType(Integer avalaraServiceType) {
            this.params.addOpt("avalara_service_type", avalaraServiceType);
            return this;
        }

        public ChargeRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public ChargeRequest invoiceDate(Timestamp invoiceDate) {
            this.params.addOpt("invoice_date", invoiceDate);
            return this;
        }

        public ChargeRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateForChargeItemsAndChargesRequest
    extends Request<CreateForChargeItemsAndChargesRequest> {
        private CreateForChargeItemsAndChargesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateForChargeItemsAndChargesRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest invoiceNote(String invoiceNote) {
            this.params.addOpt("invoice_note", invoiceNote);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest removeGeneralNote(Boolean removeGeneralNote) {
            this.params.addOpt("remove_general_note", removeGeneralNote);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        @Deprecated
        public CreateForChargeItemsAndChargesRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest authorizationTransactionId(String authorizationTransactionId) {
            this.params.addOpt("authorization_transaction_id", authorizationTransactionId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest invoiceDate(Timestamp invoiceDate) {
            this.params.addOpt("invoice_date", invoiceDate);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest tokenId(String tokenId) {
            this.params.addOpt("token_id", tokenId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest retainPaymentSource(Boolean retainPaymentSource) {
            this.params.addOpt("retain_payment_source", retainPaymentSource);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        @Deprecated
        public CreateForChargeItemsAndChargesRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Deprecated
        public CreateForChargeItemsAndChargesRequest cardTmpToken(String cardTmpToken) {
            this.params.addOpt("card[tmp_token]", cardTmpToken);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountGatewayAccountId(String bankAccountGatewayAccountId) {
            this.params.addOpt("bank_account[gateway_account_id]", bankAccountGatewayAccountId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountIban(String bankAccountIban) {
            this.params.addOpt("bank_account[iban]", bankAccountIban);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountFirstName(String bankAccountFirstName) {
            this.params.addOpt("bank_account[first_name]", bankAccountFirstName);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountLastName(String bankAccountLastName) {
            this.params.addOpt("bank_account[last_name]", bankAccountLastName);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountCompany(String bankAccountCompany) {
            this.params.addOpt("bank_account[company]", bankAccountCompany);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountEmail(String bankAccountEmail) {
            this.params.addOpt("bank_account[email]", bankAccountEmail);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountPhone(String bankAccountPhone) {
            this.params.addOpt("bank_account[phone]", bankAccountPhone);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountBankName(String bankAccountBankName) {
            this.params.addOpt("bank_account[bank_name]", bankAccountBankName);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountAccountNumber(String bankAccountAccountNumber) {
            this.params.addOpt("bank_account[account_number]", bankAccountAccountNumber);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountRoutingNumber(String bankAccountRoutingNumber) {
            this.params.addOpt("bank_account[routing_number]", bankAccountRoutingNumber);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountBankCode(String bankAccountBankCode) {
            this.params.addOpt("bank_account[bank_code]", bankAccountBankCode);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountAccountType(AccountType bankAccountAccountType) {
            this.params.addOpt("bank_account[account_type]", (Object)bankAccountAccountType);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountAccountHolderType(AccountHolderType bankAccountAccountHolderType) {
            this.params.addOpt("bank_account[account_holder_type]", (Object)bankAccountAccountHolderType);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountEcheckType(EcheckType bankAccountEcheckType) {
            this.params.addOpt("bank_account[echeck_type]", (Object)bankAccountEcheckType);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountIssuingCountry(String bankAccountIssuingCountry) {
            this.params.addOpt("bank_account[issuing_country]", bankAccountIssuingCountry);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountSwedishIdentityNumber(String bankAccountSwedishIdentityNumber) {
            this.params.addOpt("bank_account[swedish_identity_number]", bankAccountSwedishIdentityNumber);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest bankAccountBillingAddress(JSONObject bankAccountBillingAddress) {
            this.params.addOpt("bank_account[billing_address]", bankAccountBillingAddress);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentMethodType(Type paymentMethodType) {
            this.params.addOpt("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        @Deprecated
        public CreateForChargeItemsAndChargesRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentMethodGatewayAccountId(String paymentMethodGatewayAccountId) {
            this.params.addOpt("payment_method[gateway_account_id]", paymentMethodGatewayAccountId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentMethodTmpToken(String paymentMethodTmpToken) {
            this.params.addOpt("payment_method[tmp_token]", paymentMethodTmpToken);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentMethodIssuingCountry(String paymentMethodIssuingCountry) {
            this.params.addOpt("payment_method[issuing_country]", paymentMethodIssuingCountry);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentMethodAdditionalInformation(JSONObject paymentMethodAdditionalInformation) {
            this.params.addOpt("payment_method[additional_information]", paymentMethodAdditionalInformation);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardNumber(String cardNumber) {
            this.params.addOpt("card[number]", cardNumber);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Deprecated
        public CreateForChargeItemsAndChargesRequest cardIpAddress(String cardIpAddress) {
            this.params.addOpt("card[ip_address]", cardIpAddress);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest cardAdditionalInformation(JSONObject cardAdditionalInformation) {
            this.params.addOpt("card[additional_information]", cardAdditionalInformation);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentIntentPaymentMethodType(PaymentIntent.PaymentMethodType paymentIntentPaymentMethodType) {
            this.params.addOpt("payment_intent[payment_method_type]", (Object)paymentIntentPaymentMethodType);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public CreateForChargeItemsAndChargesRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest paymentIntentAdditionalInformation(JSONObject paymentIntentAdditionalInformation) {
            this.params.addOpt("payment_intent[additional_information]", paymentIntentAdditionalInformation);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemPriceItemPriceId(int index, String itemPriceItemPriceId) {
            this.params.addOpt("item_prices[item_price_id][" + index + "]", itemPriceItemPriceId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemPriceQuantity(int index, Integer itemPriceQuantity) {
            this.params.addOpt("item_prices[quantity][" + index + "]", itemPriceQuantity);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemPriceQuantityInDecimal(int index, String itemPriceQuantityInDecimal) {
            this.params.addOpt("item_prices[quantity_in_decimal][" + index + "]", itemPriceQuantityInDecimal);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemPriceUnitPrice(int index, Long itemPriceUnitPrice) {
            this.params.addOpt("item_prices[unit_price][" + index + "]", itemPriceUnitPrice);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemPriceUnitPriceInDecimal(int index, String itemPriceUnitPriceInDecimal) {
            this.params.addOpt("item_prices[unit_price_in_decimal][" + index + "]", itemPriceUnitPriceInDecimal);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemPriceDateFrom(int index, Timestamp itemPriceDateFrom) {
            this.params.addOpt("item_prices[date_from][" + index + "]", itemPriceDateFrom);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemPriceDateTo(int index, Timestamp itemPriceDateTo) {
            this.params.addOpt("item_prices[date_to][" + index + "]", itemPriceDateTo);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemTierPrice(int index, Long itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeAmount(int index, Long chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeAmountInDecimal(int index, String chargeAmountInDecimal) {
            this.params.addOpt("charges[amount_in_decimal][" + index + "]", chargeAmountInDecimal);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeTaxable(int index, Boolean chargeTaxable) {
            this.params.addOpt("charges[taxable][" + index + "]", chargeTaxable);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeTaxProfileId(int index, String chargeTaxProfileId) {
            this.params.addOpt("charges[tax_profile_id][" + index + "]", chargeTaxProfileId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeAvalaraTaxCode(int index, String chargeAvalaraTaxCode) {
            this.params.addOpt("charges[avalara_tax_code][" + index + "]", chargeAvalaraTaxCode);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeHsnCode(int index, String chargeHsnCode) {
            this.params.addOpt("charges[hsn_code][" + index + "]", chargeHsnCode);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeTaxjarProductCode(int index, String chargeTaxjarProductCode) {
            this.params.addOpt("charges[taxjar_product_code][" + index + "]", chargeTaxjarProductCode);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeAvalaraSaleType(int index, AvalaraSaleType chargeAvalaraSaleType) {
            this.params.addOpt("charges[avalara_sale_type][" + index + "]", (Object)chargeAvalaraSaleType);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeAvalaraTransactionType(int index, Integer chargeAvalaraTransactionType) {
            this.params.addOpt("charges[avalara_transaction_type][" + index + "]", chargeAvalaraTransactionType);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeAvalaraServiceType(int index, Integer chargeAvalaraServiceType) {
            this.params.addOpt("charges[avalara_service_type][" + index + "]", chargeAvalaraServiceType);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeDateFrom(int index, Timestamp chargeDateFrom) {
            this.params.addOpt("charges[date_from][" + index + "]", chargeDateFrom);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest chargeDateTo(int index, Timestamp chargeDateTo) {
            this.params.addOpt("charges[date_to][" + index + "]", chargeDateTo);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest notesToRemoveEntityType(int index, EntityType notesToRemoveEntityType) {
            this.params.addOpt("notes_to_remove[entity_type][" + index + "]", (Object)notesToRemoveEntityType);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest notesToRemoveEntityId(int index, String notesToRemoveEntityId) {
            this.params.addOpt("notes_to_remove[entity_id][" + index + "]", notesToRemoveEntityId);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest discountPercentage(int index, Double discountPercentage) {
            this.params.addOpt("discounts[percentage][" + index + "]", discountPercentage);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest discountAmount(int index, Long discountAmount) {
            this.params.addOpt("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest discountApplyOn(int index, ApplyOn discountApplyOn) {
            this.params.add("discounts[apply_on][" + index + "]", (Object)discountApplyOn);
            return this;
        }

        public CreateForChargeItemsAndChargesRequest discountItemPriceId(int index, String discountItemPriceId) {
            this.params.addOpt("discounts[item_price_id][" + index + "]", discountItemPriceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public CreateRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateRequest invoiceDate(Timestamp invoiceDate) {
            this.params.addOpt("invoice_date", invoiceDate);
            return this;
        }

        public CreateRequest invoiceNote(String invoiceNote) {
            this.params.addOpt("invoice_note", invoiceNote);
            return this;
        }

        public CreateRequest removeGeneralNote(Boolean removeGeneralNote) {
            this.params.addOpt("remove_general_note", removeGeneralNote);
            return this;
        }

        public CreateRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        @Deprecated
        public CreateRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateRequest authorizationTransactionId(String authorizationTransactionId) {
            this.params.addOpt("authorization_transaction_id", authorizationTransactionId);
            return this;
        }

        public CreateRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CreateRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public CreateRequest tokenId(String tokenId) {
            this.params.addOpt("token_id", tokenId);
            return this;
        }

        public CreateRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateRequest retainPaymentSource(Boolean retainPaymentSource) {
            this.params.addOpt("retain_payment_source", retainPaymentSource);
            return this;
        }

        public CreateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        @Deprecated
        public CreateRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CreateRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Deprecated
        public CreateRequest cardTmpToken(String cardTmpToken) {
            this.params.addOpt("card[tmp_token]", cardTmpToken);
            return this;
        }

        public CreateRequest bankAccountGatewayAccountId(String bankAccountGatewayAccountId) {
            this.params.addOpt("bank_account[gateway_account_id]", bankAccountGatewayAccountId);
            return this;
        }

        public CreateRequest bankAccountIban(String bankAccountIban) {
            this.params.addOpt("bank_account[iban]", bankAccountIban);
            return this;
        }

        public CreateRequest bankAccountFirstName(String bankAccountFirstName) {
            this.params.addOpt("bank_account[first_name]", bankAccountFirstName);
            return this;
        }

        public CreateRequest bankAccountLastName(String bankAccountLastName) {
            this.params.addOpt("bank_account[last_name]", bankAccountLastName);
            return this;
        }

        public CreateRequest bankAccountCompany(String bankAccountCompany) {
            this.params.addOpt("bank_account[company]", bankAccountCompany);
            return this;
        }

        public CreateRequest bankAccountEmail(String bankAccountEmail) {
            this.params.addOpt("bank_account[email]", bankAccountEmail);
            return this;
        }

        public CreateRequest bankAccountPhone(String bankAccountPhone) {
            this.params.addOpt("bank_account[phone]", bankAccountPhone);
            return this;
        }

        public CreateRequest bankAccountBankName(String bankAccountBankName) {
            this.params.addOpt("bank_account[bank_name]", bankAccountBankName);
            return this;
        }

        public CreateRequest bankAccountAccountNumber(String bankAccountAccountNumber) {
            this.params.addOpt("bank_account[account_number]", bankAccountAccountNumber);
            return this;
        }

        public CreateRequest bankAccountRoutingNumber(String bankAccountRoutingNumber) {
            this.params.addOpt("bank_account[routing_number]", bankAccountRoutingNumber);
            return this;
        }

        public CreateRequest bankAccountBankCode(String bankAccountBankCode) {
            this.params.addOpt("bank_account[bank_code]", bankAccountBankCode);
            return this;
        }

        public CreateRequest bankAccountAccountType(AccountType bankAccountAccountType) {
            this.params.addOpt("bank_account[account_type]", (Object)bankAccountAccountType);
            return this;
        }

        public CreateRequest bankAccountAccountHolderType(AccountHolderType bankAccountAccountHolderType) {
            this.params.addOpt("bank_account[account_holder_type]", (Object)bankAccountAccountHolderType);
            return this;
        }

        public CreateRequest bankAccountEcheckType(EcheckType bankAccountEcheckType) {
            this.params.addOpt("bank_account[echeck_type]", (Object)bankAccountEcheckType);
            return this;
        }

        public CreateRequest bankAccountIssuingCountry(String bankAccountIssuingCountry) {
            this.params.addOpt("bank_account[issuing_country]", bankAccountIssuingCountry);
            return this;
        }

        public CreateRequest bankAccountSwedishIdentityNumber(String bankAccountSwedishIdentityNumber) {
            this.params.addOpt("bank_account[swedish_identity_number]", bankAccountSwedishIdentityNumber);
            return this;
        }

        public CreateRequest bankAccountBillingAddress(JSONObject bankAccountBillingAddress) {
            this.params.addOpt("bank_account[billing_address]", bankAccountBillingAddress);
            return this;
        }

        public CreateRequest paymentMethodType(Type paymentMethodType) {
            this.params.addOpt("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        @Deprecated
        public CreateRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public CreateRequest paymentMethodGatewayAccountId(String paymentMethodGatewayAccountId) {
            this.params.addOpt("payment_method[gateway_account_id]", paymentMethodGatewayAccountId);
            return this;
        }

        public CreateRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public CreateRequest paymentMethodTmpToken(String paymentMethodTmpToken) {
            this.params.addOpt("payment_method[tmp_token]", paymentMethodTmpToken);
            return this;
        }

        public CreateRequest paymentMethodIssuingCountry(String paymentMethodIssuingCountry) {
            this.params.addOpt("payment_method[issuing_country]", paymentMethodIssuingCountry);
            return this;
        }

        public CreateRequest paymentMethodAdditionalInformation(JSONObject paymentMethodAdditionalInformation) {
            this.params.addOpt("payment_method[additional_information]", paymentMethodAdditionalInformation);
            return this;
        }

        public CreateRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public CreateRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public CreateRequest cardNumber(String cardNumber) {
            this.params.addOpt("card[number]", cardNumber);
            return this;
        }

        public CreateRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public CreateRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public CreateRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public CreateRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public CreateRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public CreateRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public CreateRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public CreateRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public CreateRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public CreateRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Deprecated
        public CreateRequest cardIpAddress(String cardIpAddress) {
            this.params.addOpt("card[ip_address]", cardIpAddress);
            return this;
        }

        public CreateRequest cardAdditionalInformation(JSONObject cardAdditionalInformation) {
            this.params.addOpt("card[additional_information]", cardAdditionalInformation);
            return this;
        }

        public CreateRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public CreateRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public CreateRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public CreateRequest paymentIntentPaymentMethodType(PaymentIntent.PaymentMethodType paymentIntentPaymentMethodType) {
            this.params.addOpt("payment_intent[payment_method_type]", (Object)paymentIntentPaymentMethodType);
            return this;
        }

        public CreateRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public CreateRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        public CreateRequest paymentIntentAdditionalInformation(JSONObject paymentIntentAdditionalInformation) {
            this.params.addOpt("payment_intent[additional_information]", paymentIntentAdditionalInformation);
            return this;
        }

        public CreateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateRequest addonUnitPrice(int index, Long addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateRequest addonQuantityInDecimal(int index, String addonQuantityInDecimal) {
            this.params.addOpt("addons[quantity_in_decimal][" + index + "]", addonQuantityInDecimal);
            return this;
        }

        public CreateRequest addonUnitPriceInDecimal(int index, String addonUnitPriceInDecimal) {
            this.params.addOpt("addons[unit_price_in_decimal][" + index + "]", addonUnitPriceInDecimal);
            return this;
        }

        public CreateRequest addonDateFrom(int index, Timestamp addonDateFrom) {
            this.params.addOpt("addons[date_from][" + index + "]", addonDateFrom);
            return this;
        }

        public CreateRequest addonDateTo(int index, Timestamp addonDateTo) {
            this.params.addOpt("addons[date_to][" + index + "]", addonDateTo);
            return this;
        }

        public CreateRequest chargeAmount(int index, Long chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CreateRequest chargeAmountInDecimal(int index, String chargeAmountInDecimal) {
            this.params.addOpt("charges[amount_in_decimal][" + index + "]", chargeAmountInDecimal);
            return this;
        }

        public CreateRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        public CreateRequest chargeTaxable(int index, Boolean chargeTaxable) {
            this.params.addOpt("charges[taxable][" + index + "]", chargeTaxable);
            return this;
        }

        public CreateRequest chargeTaxProfileId(int index, String chargeTaxProfileId) {
            this.params.addOpt("charges[tax_profile_id][" + index + "]", chargeTaxProfileId);
            return this;
        }

        public CreateRequest chargeAvalaraTaxCode(int index, String chargeAvalaraTaxCode) {
            this.params.addOpt("charges[avalara_tax_code][" + index + "]", chargeAvalaraTaxCode);
            return this;
        }

        public CreateRequest chargeHsnCode(int index, String chargeHsnCode) {
            this.params.addOpt("charges[hsn_code][" + index + "]", chargeHsnCode);
            return this;
        }

        public CreateRequest chargeTaxjarProductCode(int index, String chargeTaxjarProductCode) {
            this.params.addOpt("charges[taxjar_product_code][" + index + "]", chargeTaxjarProductCode);
            return this;
        }

        public CreateRequest chargeAvalaraSaleType(int index, AvalaraSaleType chargeAvalaraSaleType) {
            this.params.addOpt("charges[avalara_sale_type][" + index + "]", (Object)chargeAvalaraSaleType);
            return this;
        }

        public CreateRequest chargeAvalaraTransactionType(int index, Integer chargeAvalaraTransactionType) {
            this.params.addOpt("charges[avalara_transaction_type][" + index + "]", chargeAvalaraTransactionType);
            return this;
        }

        public CreateRequest chargeAvalaraServiceType(int index, Integer chargeAvalaraServiceType) {
            this.params.addOpt("charges[avalara_service_type][" + index + "]", chargeAvalaraServiceType);
            return this;
        }

        public CreateRequest chargeDateFrom(int index, Timestamp chargeDateFrom) {
            this.params.addOpt("charges[date_from][" + index + "]", chargeDateFrom);
            return this;
        }

        public CreateRequest chargeDateTo(int index, Timestamp chargeDateTo) {
            this.params.addOpt("charges[date_to][" + index + "]", chargeDateTo);
            return this;
        }

        public CreateRequest notesToRemoveEntityType(int index, EntityType notesToRemoveEntityType) {
            this.params.addOpt("notes_to_remove[entity_type][" + index + "]", (Object)notesToRemoveEntityType);
            return this;
        }

        public CreateRequest notesToRemoveEntityId(int index, String notesToRemoveEntityId) {
            this.params.addOpt("notes_to_remove[entity_id][" + index + "]", notesToRemoveEntityId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Einvoice
    extends Resource<Einvoice> {
        public Einvoice(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public String message() {
            return this.optString("message");
        }

        public static enum Status {
            SCHEDULED,
            SKIPPED,
            IN_PROGRESS,
            SUCCESS,
            FAILED,
            REGISTERED,
            _UNKNOWN;

        }
    }

    public static class BillingAddress
    extends Resource<BillingAddress> {
        public BillingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }

        public Integer index() {
            return this.reqInteger("index");
        }
    }

    public static class Note
    extends Resource<Note> {
        public Note(JSONObject jsonObj) {
            super(jsonObj);
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String note() {
            return this.reqString("note");
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public static enum EntityType {
            PLAN,
            ADDON,
            COUPON,
            SUBSCRIPTION,
            CUSTOMER,
            PLAN_ITEM_PRICE,
            ADDON_ITEM_PRICE,
            CHARGE_ITEM_PRICE,
            _UNKNOWN;

        }
    }

    public static class LinkedOrder
    extends Resource<LinkedOrder> {
        public LinkedOrder(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public String documentNumber() {
            return this.optString("document_number");
        }

        public Status status() {
            return this.optEnum("status", Status.class);
        }

        public OrderType orderType() {
            return this.optEnum("order_type", OrderType.class);
        }

        public String referenceId() {
            return this.optString("reference_id");
        }

        public String fulfillmentStatus() {
            return this.optString("fulfillment_status");
        }

        public String batchId() {
            return this.optString("batch_id");
        }

        public Timestamp createdAt() {
            return this.reqTimestamp("created_at");
        }

        public static enum OrderType {
            MANUAL,
            SYSTEM_GENERATED,
            _UNKNOWN;

        }

        public static enum Status {
            NEW,
            PROCESSING,
            COMPLETE,
            CANCELLED,
            VOIDED,
            QUEUED,
            AWAITING_SHIPMENT,
            ON_HOLD,
            DELIVERED,
            SHIPPED,
            PARTIALLY_DELIVERED,
            RETURNED,
            _UNKNOWN;

        }
    }

    public static class IssuedCreditNote
    extends Resource<IssuedCreditNote> {
        public IssuedCreditNote(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String cnId() {
            return this.reqString("cn_id");
        }

        public CreditNote.ReasonCode cnReasonCode() {
            return this.optEnum("cn_reason_code", CreditNote.ReasonCode.class);
        }

        public String cnCreateReasonCode() {
            return this.optString("cn_create_reason_code");
        }

        public Timestamp cnDate() {
            return this.optTimestamp("cn_date");
        }

        public Long cnTotal() {
            return this.optLong("cn_total");
        }

        public CreditNote.Status cnStatus() {
            return this.reqEnum("cn_status", CreditNote.Status.class);
        }
    }

    public static class AdjustmentCreditNote
    extends Resource<AdjustmentCreditNote> {
        public AdjustmentCreditNote(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String cnId() {
            return this.reqString("cn_id");
        }

        public CreditNote.ReasonCode cnReasonCode() {
            return this.optEnum("cn_reason_code", CreditNote.ReasonCode.class);
        }

        public String cnCreateReasonCode() {
            return this.optString("cn_create_reason_code");
        }

        public Timestamp cnDate() {
            return this.optTimestamp("cn_date");
        }

        public Long cnTotal() {
            return this.optLong("cn_total");
        }

        public CreditNote.Status cnStatus() {
            return this.reqEnum("cn_status", CreditNote.Status.class);
        }
    }

    public static class AppliedCredit
    extends Resource<AppliedCredit> {
        public AppliedCredit(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String cnId() {
            return this.reqString("cn_id");
        }

        public Long appliedAmount() {
            return this.reqLong("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public CreditNote.ReasonCode cnReasonCode() {
            return this.optEnum("cn_reason_code", CreditNote.ReasonCode.class);
        }

        public String cnCreateReasonCode() {
            return this.optString("cn_create_reason_code");
        }

        public Timestamp cnDate() {
            return this.optTimestamp("cn_date");
        }

        public CreditNote.Status cnStatus() {
            return this.reqEnum("cn_status", CreditNote.Status.class);
        }
    }

    public static class DunningAttempt
    extends Resource<DunningAttempt> {
        public DunningAttempt(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer attempt() {
            return this.reqInteger("attempt");
        }

        public String transactionId() {
            return this.optString("transaction_id");
        }

        public DunningType dunningType() {
            return this.reqEnum("dunning_type", DunningType.class);
        }

        public Timestamp createdAt() {
            return this.optTimestamp("created_at");
        }

        public Transaction.Status txnStatus() {
            return this.optEnum("txn_status", Transaction.Status.class);
        }

        public Long txnAmount() {
            return this.optLong("txn_amount");
        }
    }

    public static class LinkedPayment
    extends Resource<LinkedPayment> {
        public LinkedPayment(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String txnId() {
            return this.reqString("txn_id");
        }

        public Long appliedAmount() {
            return this.reqLong("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public Transaction.Status txnStatus() {
            return this.optEnum("txn_status", Transaction.Status.class);
        }

        public Timestamp txnDate() {
            return this.optTimestamp("txn_date");
        }

        public Long txnAmount() {
            return this.optLong("txn_amount");
        }
    }

    public static class LineItemTier
    extends Resource<LineItemTier> {
        public LineItemTier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Integer quantityUsed() {
            return this.reqInteger("quantity_used");
        }

        public Long unitAmount() {
            return this.reqLong("unit_amount");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String quantityUsedInDecimal() {
            return this.optString("quantity_used_in_decimal");
        }

        public String unitAmountInDecimal() {
            return this.optString("unit_amount_in_decimal");
        }
    }

    public static class LineItemTax
    extends Resource<LineItemTax> {
        public LineItemTax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public String taxName() {
            return this.reqString("tax_name");
        }

        public Double taxRate() {
            return this.reqDouble("tax_rate");
        }

        public Boolean isPartialTaxApplied() {
            return this.optBoolean("is_partial_tax_applied");
        }

        public Boolean isNonComplianceTax() {
            return this.optBoolean("is_non_compliance_tax");
        }

        public Long taxableAmount() {
            return this.reqLong("taxable_amount");
        }

        public Long taxAmount() {
            return this.reqLong("tax_amount");
        }

        public TaxJurisType taxJurisType() {
            return this.optEnum("tax_juris_type", TaxJurisType.class);
        }

        public String taxJurisName() {
            return this.optString("tax_juris_name");
        }

        public String taxJurisCode() {
            return this.optString("tax_juris_code");
        }

        public Long taxAmountInLocalCurrency() {
            return this.optLong("tax_amount_in_local_currency");
        }

        public String localCurrencyCode() {
            return this.optString("local_currency_code");
        }
    }

    public static class Tax
    extends Resource<Tax> {
        public Tax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String name() {
            return this.reqString("name");
        }

        public Long amount() {
            return this.reqLong("amount");
        }

        public String description() {
            return this.optString("description");
        }
    }

    public static class LineItemDiscount
    extends Resource<LineItemDiscount> {
        public LineItemDiscount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.reqString("line_item_id");
        }

        public DiscountType discountType() {
            return this.reqEnum("discount_type", DiscountType.class);
        }

        public String couponId() {
            return this.optString("coupon_id");
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public Long discountAmount() {
            return this.reqLong("discount_amount");
        }

        public static enum DiscountType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            ITEM_LEVEL_DISCOUNT,
            DOCUMENT_LEVEL_DISCOUNT,
            _UNKNOWN;

        }
    }

    public static class Discount
    extends Resource<Discount> {
        public Discount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Long amount() {
            return this.reqLong("amount");
        }

        public String description() {
            return this.optString("description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public String couponSetCode() {
            return this.optString("coupon_set_code");
        }

        public static enum EntityType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            ITEM_LEVEL_DISCOUNT,
            DOCUMENT_LEVEL_DISCOUNT,
            _UNKNOWN;

        }
    }

    public static class LineItem
    extends Resource<LineItem> {
        public LineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.optString("id");
        }

        public String subscriptionId() {
            return this.optString("subscription_id");
        }

        public Timestamp dateFrom() {
            return this.reqTimestamp("date_from");
        }

        public Timestamp dateTo() {
            return this.reqTimestamp("date_to");
        }

        public Long unitAmount() {
            return this.reqLong("unit_amount");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Long amount() {
            return this.optLong("amount");
        }

        public PricingModel pricingModel() {
            return this.optEnum("pricing_model", PricingModel.class);
        }

        public Boolean isTaxed() {
            return this.reqBoolean("is_taxed");
        }

        public Long taxAmount() {
            return this.optLong("tax_amount");
        }

        public Double taxRate() {
            return this.optDouble("tax_rate");
        }

        public String unitAmountInDecimal() {
            return this.optString("unit_amount_in_decimal");
        }

        public String quantityInDecimal() {
            return this.optString("quantity_in_decimal");
        }

        public String amountInDecimal() {
            return this.optString("amount_in_decimal");
        }

        public Long discountAmount() {
            return this.optLong("discount_amount");
        }

        public Long itemLevelDiscountAmount() {
            return this.optLong("item_level_discount_amount");
        }

        public String referenceLineItemId() {
            return this.optString("reference_line_item_id");
        }

        public String description() {
            return this.reqString("description");
        }

        public String entityDescription() {
            return this.reqString("entity_description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public TaxExemptReason taxExemptReason() {
            return this.optEnum("tax_exempt_reason", TaxExemptReason.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public String customerId() {
            return this.optString("customer_id");
        }

        public static enum EntityType {
            PLAN_SETUP,
            PLAN,
            ADDON,
            ADHOC,
            PLAN_ITEM_PRICE,
            ADDON_ITEM_PRICE,
            CHARGE_ITEM_PRICE,
            _UNKNOWN;

        }
    }

    public static enum DunningStatus {
        IN_PROGRESS,
        EXHAUSTED,
        STOPPED,
        SUCCESS,
        _UNKNOWN;

    }

    public static enum Status {
        PAID,
        POSTED,
        PAYMENT_DUE,
        NOT_PAID,
        VOIDED,
        PENDING,
        _UNKNOWN;

    }
}

