/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.Resource;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.models.enums.TaxExemptReason;
import com.chargebee.models.enums.TaxJurisType;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class InvoiceEstimate
extends Resource<InvoiceEstimate> {
    public InvoiceEstimate(String jsonStr) {
        super(jsonStr);
    }

    public InvoiceEstimate(JSONObject jsonObj) {
        super(jsonObj);
    }

    public Boolean recurring() {
        return this.reqBoolean("recurring");
    }

    public PriceType priceType() {
        return this.reqEnum("price_type", PriceType.class);
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Long subTotal() {
        return this.reqLong("sub_total");
    }

    public Long total() {
        return this.optLong("total");
    }

    public Long creditsApplied() {
        return this.optLong("credits_applied");
    }

    public Long amountPaid() {
        return this.optLong("amount_paid");
    }

    public Long amountDue() {
        return this.optLong("amount_due");
    }

    public List<LineItem> lineItems() {
        return this.optList("line_items", LineItem.class);
    }

    public List<Discount> discounts() {
        return this.optList("discounts", Discount.class);
    }

    public List<Tax> taxes() {
        return this.optList("taxes", Tax.class);
    }

    public List<LineItemTax> lineItemTaxes() {
        return this.optList("line_item_taxes", LineItemTax.class);
    }

    public List<LineItemTier> lineItemTiers() {
        return this.optList("line_item_tiers", LineItemTier.class);
    }

    public List<LineItemDiscount> lineItemDiscounts() {
        return this.optList("line_item_discounts", LineItemDiscount.class);
    }

    public Long roundOffAmount() {
        return this.optLong("round_off_amount");
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public static class LineItemDiscount
    extends Resource<LineItemDiscount> {
        public LineItemDiscount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.reqString("line_item_id");
        }

        public DiscountType discountType() {
            return this.reqEnum("discount_type", DiscountType.class);
        }

        public String couponId() {
            return this.optString("coupon_id");
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public Long discountAmount() {
            return this.reqLong("discount_amount");
        }

        public static enum DiscountType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            ITEM_LEVEL_DISCOUNT,
            DOCUMENT_LEVEL_DISCOUNT,
            _UNKNOWN;

        }
    }

    public static class LineItemTier
    extends Resource<LineItemTier> {
        public LineItemTier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Integer quantityUsed() {
            return this.reqInteger("quantity_used");
        }

        public Long unitAmount() {
            return this.reqLong("unit_amount");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String quantityUsedInDecimal() {
            return this.optString("quantity_used_in_decimal");
        }

        public String unitAmountInDecimal() {
            return this.optString("unit_amount_in_decimal");
        }
    }

    public static class LineItemTax
    extends Resource<LineItemTax> {
        public LineItemTax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public String taxName() {
            return this.reqString("tax_name");
        }

        public Double taxRate() {
            return this.reqDouble("tax_rate");
        }

        public Boolean isPartialTaxApplied() {
            return this.optBoolean("is_partial_tax_applied");
        }

        public Boolean isNonComplianceTax() {
            return this.optBoolean("is_non_compliance_tax");
        }

        public Long taxableAmount() {
            return this.reqLong("taxable_amount");
        }

        public Long taxAmount() {
            return this.reqLong("tax_amount");
        }

        public TaxJurisType taxJurisType() {
            return this.optEnum("tax_juris_type", TaxJurisType.class);
        }

        public String taxJurisName() {
            return this.optString("tax_juris_name");
        }

        public String taxJurisCode() {
            return this.optString("tax_juris_code");
        }

        public Long taxAmountInLocalCurrency() {
            return this.optLong("tax_amount_in_local_currency");
        }

        public String localCurrencyCode() {
            return this.optString("local_currency_code");
        }
    }

    public static class Tax
    extends Resource<Tax> {
        public Tax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String name() {
            return this.reqString("name");
        }

        public Long amount() {
            return this.reqLong("amount");
        }

        public String description() {
            return this.optString("description");
        }
    }

    public static class Discount
    extends Resource<Discount> {
        public Discount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Long amount() {
            return this.reqLong("amount");
        }

        public String description() {
            return this.optString("description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public String couponSetCode() {
            return this.optString("coupon_set_code");
        }

        public static enum EntityType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            ITEM_LEVEL_DISCOUNT,
            DOCUMENT_LEVEL_DISCOUNT,
            _UNKNOWN;

        }
    }

    public static class LineItem
    extends Resource<LineItem> {
        public LineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.optString("id");
        }

        public String subscriptionId() {
            return this.optString("subscription_id");
        }

        public Timestamp dateFrom() {
            return this.reqTimestamp("date_from");
        }

        public Timestamp dateTo() {
            return this.reqTimestamp("date_to");
        }

        public Long unitAmount() {
            return this.reqLong("unit_amount");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Long amount() {
            return this.optLong("amount");
        }

        public PricingModel pricingModel() {
            return this.optEnum("pricing_model", PricingModel.class);
        }

        public Boolean isTaxed() {
            return this.reqBoolean("is_taxed");
        }

        public Long taxAmount() {
            return this.optLong("tax_amount");
        }

        public Double taxRate() {
            return this.optDouble("tax_rate");
        }

        public String unitAmountInDecimal() {
            return this.optString("unit_amount_in_decimal");
        }

        public String quantityInDecimal() {
            return this.optString("quantity_in_decimal");
        }

        public String amountInDecimal() {
            return this.optString("amount_in_decimal");
        }

        public Long discountAmount() {
            return this.optLong("discount_amount");
        }

        public Long itemLevelDiscountAmount() {
            return this.optLong("item_level_discount_amount");
        }

        public String referenceLineItemId() {
            return this.optString("reference_line_item_id");
        }

        public String description() {
            return this.reqString("description");
        }

        public String entityDescription() {
            return this.reqString("entity_description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public TaxExemptReason taxExemptReason() {
            return this.optEnum("tax_exempt_reason", TaxExemptReason.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public String customerId() {
            return this.optString("customer_id");
        }

        public static enum EntityType {
            PLAN_SETUP,
            PLAN,
            ADDON,
            ADHOC,
            PLAN_ITEM_PRICE,
            ADDON_ITEM_PRICE,
            CHARGE_ITEM_PRICE,
            _UNKNOWN;

        }
    }
}

