/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Channel;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class ItemFamily
extends Resource<ItemFamily> {
    public ItemFamily(String jsonStr) {
        super(jsonStr);
    }

    public ItemFamily(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String description() {
        return this.optString("description");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Channel channel() {
        return this.optEnum("channel", Channel.class);
    }

    public static CreateRequest create() {
        String uri = ItemFamily.uri("item_families");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = ItemFamily.uri("item_families", ItemFamily.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static ItemFamilyListRequest list() {
        String uri = ItemFamily.uri("item_families");
        return new ItemFamilyListRequest(uri);
    }

    public static UpdateRequest update(String id) {
        String uri = ItemFamily.uri("item_families", ItemFamily.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) {
        String uri = ItemFamily.uri("item_families", ItemFamily.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ItemFamilyListRequest
    extends ListRequest<ItemFamilyListRequest> {
        private ItemFamilyListRequest(String uri) {
            super(uri);
        }

        public StringFilter<ItemFamilyListRequest> id() {
            return new StringFilter<ItemFamilyListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemFamilyListRequest> name() {
            return new StringFilter<ItemFamilyListRequest>("name", this);
        }

        public TimestampFilter<ItemFamilyListRequest> updatedAt() {
            return new TimestampFilter<ItemFamilyListRequest>("updated_at", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum Status {
        ACTIVE,
        DELETED,
        _UNKNOWN;

    }
}

