/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.CustomerType;
import com.chargebee.models.enums.EntityCode;
import com.chargebee.models.enums.Taxability;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class Purchase
extends Resource<Purchase> {
    public Purchase(String jsonStr) {
        super(jsonStr);
    }

    public Purchase(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.optString("id");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public Timestamp createdAt() {
        return this.optTimestamp("created_at");
    }

    public Timestamp modifiedAt() {
        return this.optTimestamp("modified_at");
    }

    public List<String> subscriptionIds() {
        return this.optList("subscription_ids", String.class);
    }

    public List<String> invoiceIds() {
        return this.optList("invoice_ids", String.class);
    }

    public static CreateRequest create() {
        String uri = Purchase.uri("purchases");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static EstimateRequest estimate() {
        String uri = Purchase.uri("purchases", "estimate");
        return new EstimateRequest(HttpUtil.Method.POST, uri);
    }

    public static class EstimateRequest
    extends Request<EstimateRequest> {
        private EstimateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public EstimateRequest clientProfileId(String clientProfileId) {
            this.params.addOpt("client_profile_id", clientProfileId);
            return this;
        }

        public EstimateRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public EstimateRequest invoiceInfoPoNumber(String invoiceInfoPoNumber) {
            this.params.addOpt("invoice_info[po_number]", invoiceInfoPoNumber);
            return this;
        }

        public EstimateRequest invoiceInfoNotes(String invoiceInfoNotes) {
            this.params.addOpt("invoice_info[notes]", invoiceInfoNotes);
            return this;
        }

        public EstimateRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public EstimateRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        public EstimateRequest customerRegisteredForGst(Boolean customerRegisteredForGst) {
            this.params.addOpt("customer[registered_for_gst]", customerRegisteredForGst);
            return this;
        }

        public EstimateRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public EstimateRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public EstimateRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public EstimateRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public EstimateRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public EstimateRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public EstimateRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public EstimateRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public EstimateRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public EstimateRequest customerEntityCode(EntityCode customerEntityCode) {
            this.params.addOpt("customer[entity_code]", (Object)customerEntityCode);
            return this;
        }

        public EstimateRequest customerExemptNumber(String customerExemptNumber) {
            this.params.addOpt("customer[exempt_number]", customerExemptNumber);
            return this;
        }

        public EstimateRequest customerExemptionDetails(JSONArray customerExemptionDetails) {
            this.params.addOpt("customer[exemption_details]", customerExemptionDetails);
            return this;
        }

        public EstimateRequest customerCustomerType(CustomerType customerCustomerType) {
            this.params.addOpt("customer[customer_type]", (Object)customerCustomerType);
            return this;
        }

        public EstimateRequest purchaseItemIndex(int index, Integer purchaseItemIndex) {
            this.params.add("purchase_items[index][" + index + "]", purchaseItemIndex);
            return this;
        }

        public EstimateRequest purchaseItemItemPriceId(int index, String purchaseItemItemPriceId) {
            this.params.add("purchase_items[item_price_id][" + index + "]", purchaseItemItemPriceId);
            return this;
        }

        public EstimateRequest purchaseItemQuantity(int index, Integer purchaseItemQuantity) {
            this.params.addOpt("purchase_items[quantity][" + index + "]", purchaseItemQuantity);
            return this;
        }

        public EstimateRequest purchaseItemUnitAmount(int index, Long purchaseItemUnitAmount) {
            this.params.addOpt("purchase_items[unit_amount][" + index + "]", purchaseItemUnitAmount);
            return this;
        }

        public EstimateRequest purchaseItemUnitAmountInDecimal(int index, String purchaseItemUnitAmountInDecimal) {
            this.params.addOpt("purchase_items[unit_amount_in_decimal][" + index + "]", purchaseItemUnitAmountInDecimal);
            return this;
        }

        public EstimateRequest purchaseItemQuantityInDecimal(int index, String purchaseItemQuantityInDecimal) {
            this.params.addOpt("purchase_items[quantity_in_decimal][" + index + "]", purchaseItemQuantityInDecimal);
            return this;
        }

        public EstimateRequest itemTierIndex(int index, Integer itemTierIndex) {
            this.params.add("item_tiers[index][" + index + "]", itemTierIndex);
            return this;
        }

        public EstimateRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            return this;
        }

        public EstimateRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public EstimateRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public EstimateRequest itemTierPrice(int index, Long itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public EstimateRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public EstimateRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public EstimateRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        public EstimateRequest shippingAddressFirstName(int index, String shippingAddressFirstName) {
            this.params.addOpt("shipping_addresses[first_name][" + index + "]", shippingAddressFirstName);
            return this;
        }

        public EstimateRequest shippingAddressLastName(int index, String shippingAddressLastName) {
            this.params.addOpt("shipping_addresses[last_name][" + index + "]", shippingAddressLastName);
            return this;
        }

        public EstimateRequest shippingAddressEmail(int index, String shippingAddressEmail) {
            this.params.addOpt("shipping_addresses[email][" + index + "]", shippingAddressEmail);
            return this;
        }

        public EstimateRequest shippingAddressCompany(int index, String shippingAddressCompany) {
            this.params.addOpt("shipping_addresses[company][" + index + "]", shippingAddressCompany);
            return this;
        }

        public EstimateRequest shippingAddressPhone(int index, String shippingAddressPhone) {
            this.params.addOpt("shipping_addresses[phone][" + index + "]", shippingAddressPhone);
            return this;
        }

        public EstimateRequest shippingAddressLine1(int index, String shippingAddressLine1) {
            this.params.addOpt("shipping_addresses[line1][" + index + "]", shippingAddressLine1);
            return this;
        }

        public EstimateRequest shippingAddressLine2(int index, String shippingAddressLine2) {
            this.params.addOpt("shipping_addresses[line2][" + index + "]", shippingAddressLine2);
            return this;
        }

        public EstimateRequest shippingAddressLine3(int index, String shippingAddressLine3) {
            this.params.addOpt("shipping_addresses[line3][" + index + "]", shippingAddressLine3);
            return this;
        }

        public EstimateRequest shippingAddressCity(int index, String shippingAddressCity) {
            this.params.addOpt("shipping_addresses[city][" + index + "]", shippingAddressCity);
            return this;
        }

        public EstimateRequest shippingAddressState(int index, String shippingAddressState) {
            this.params.addOpt("shipping_addresses[state][" + index + "]", shippingAddressState);
            return this;
        }

        public EstimateRequest shippingAddressStateCode(int index, String shippingAddressStateCode) {
            this.params.addOpt("shipping_addresses[state_code][" + index + "]", shippingAddressStateCode);
            return this;
        }

        public EstimateRequest shippingAddressCountry(int index, String shippingAddressCountry) {
            this.params.addOpt("shipping_addresses[country][" + index + "]", shippingAddressCountry);
            return this;
        }

        public EstimateRequest shippingAddressZip(int index, String shippingAddressZip) {
            this.params.addOpt("shipping_addresses[zip][" + index + "]", shippingAddressZip);
            return this;
        }

        public EstimateRequest shippingAddressValidationStatus(int index, ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_addresses[validation_status][" + index + "]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public EstimateRequest discountIndex(int index, Integer discountIndex) {
            this.params.addOpt("discounts[index][" + index + "]", discountIndex);
            return this;
        }

        public EstimateRequest discountCouponId(int index, String discountCouponId) {
            this.params.addOpt("discounts[coupon_id][" + index + "]", discountCouponId);
            return this;
        }

        public EstimateRequest discountPercentage(int index, Double discountPercentage) {
            this.params.addOpt("discounts[percentage][" + index + "]", discountPercentage);
            return this;
        }

        public EstimateRequest discountAmount(int index, Long discountAmount) {
            this.params.addOpt("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public EstimateRequest discountIncludedInMrr(int index, Boolean discountIncludedInMrr) {
            this.params.addOpt("discounts[included_in_mrr][" + index + "]", discountIncludedInMrr);
            return this;
        }

        public EstimateRequest subscriptionInfoIndex(int index, Integer subscriptionInfoIndex) {
            this.params.add("subscription_info[index][" + index + "]", subscriptionInfoIndex);
            return this;
        }

        public EstimateRequest subscriptionInfoSubscriptionId(int index, String subscriptionInfoSubscriptionId) {
            this.params.addOpt("subscription_info[subscription_id][" + index + "]", subscriptionInfoSubscriptionId);
            return this;
        }

        public EstimateRequest subscriptionInfoBillingCycles(int index, Integer subscriptionInfoBillingCycles) {
            this.params.addOpt("subscription_info[billing_cycles][" + index + "]", subscriptionInfoBillingCycles);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateRequest invoiceInfoPoNumber(String invoiceInfoPoNumber) {
            this.params.addOpt("invoice_info[po_number]", invoiceInfoPoNumber);
            return this;
        }

        public CreateRequest invoiceInfoNotes(String invoiceInfoNotes) {
            this.params.addOpt("invoice_info[notes]", invoiceInfoNotes);
            return this;
        }

        public CreateRequest purchaseItemIndex(int index, Integer purchaseItemIndex) {
            this.params.add("purchase_items[index][" + index + "]", purchaseItemIndex);
            return this;
        }

        public CreateRequest purchaseItemItemPriceId(int index, String purchaseItemItemPriceId) {
            this.params.add("purchase_items[item_price_id][" + index + "]", purchaseItemItemPriceId);
            return this;
        }

        public CreateRequest purchaseItemQuantity(int index, Integer purchaseItemQuantity) {
            this.params.addOpt("purchase_items[quantity][" + index + "]", purchaseItemQuantity);
            return this;
        }

        public CreateRequest purchaseItemUnitAmount(int index, Long purchaseItemUnitAmount) {
            this.params.addOpt("purchase_items[unit_amount][" + index + "]", purchaseItemUnitAmount);
            return this;
        }

        public CreateRequest purchaseItemUnitAmountInDecimal(int index, String purchaseItemUnitAmountInDecimal) {
            this.params.addOpt("purchase_items[unit_amount_in_decimal][" + index + "]", purchaseItemUnitAmountInDecimal);
            return this;
        }

        public CreateRequest purchaseItemQuantityInDecimal(int index, String purchaseItemQuantityInDecimal) {
            this.params.addOpt("purchase_items[quantity_in_decimal][" + index + "]", purchaseItemQuantityInDecimal);
            return this;
        }

        public CreateRequest itemTierIndex(int index, Integer itemTierIndex) {
            this.params.add("item_tiers[index][" + index + "]", itemTierIndex);
            return this;
        }

        public CreateRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            return this;
        }

        public CreateRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public CreateRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public CreateRequest itemTierPrice(int index, Long itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public CreateRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public CreateRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public CreateRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        public CreateRequest shippingAddressFirstName(int index, String shippingAddressFirstName) {
            this.params.addOpt("shipping_addresses[first_name][" + index + "]", shippingAddressFirstName);
            return this;
        }

        public CreateRequest shippingAddressLastName(int index, String shippingAddressLastName) {
            this.params.addOpt("shipping_addresses[last_name][" + index + "]", shippingAddressLastName);
            return this;
        }

        public CreateRequest shippingAddressEmail(int index, String shippingAddressEmail) {
            this.params.addOpt("shipping_addresses[email][" + index + "]", shippingAddressEmail);
            return this;
        }

        public CreateRequest shippingAddressCompany(int index, String shippingAddressCompany) {
            this.params.addOpt("shipping_addresses[company][" + index + "]", shippingAddressCompany);
            return this;
        }

        public CreateRequest shippingAddressPhone(int index, String shippingAddressPhone) {
            this.params.addOpt("shipping_addresses[phone][" + index + "]", shippingAddressPhone);
            return this;
        }

        public CreateRequest shippingAddressLine1(int index, String shippingAddressLine1) {
            this.params.addOpt("shipping_addresses[line1][" + index + "]", shippingAddressLine1);
            return this;
        }

        public CreateRequest shippingAddressLine2(int index, String shippingAddressLine2) {
            this.params.addOpt("shipping_addresses[line2][" + index + "]", shippingAddressLine2);
            return this;
        }

        public CreateRequest shippingAddressLine3(int index, String shippingAddressLine3) {
            this.params.addOpt("shipping_addresses[line3][" + index + "]", shippingAddressLine3);
            return this;
        }

        public CreateRequest shippingAddressCity(int index, String shippingAddressCity) {
            this.params.addOpt("shipping_addresses[city][" + index + "]", shippingAddressCity);
            return this;
        }

        public CreateRequest shippingAddressState(int index, String shippingAddressState) {
            this.params.addOpt("shipping_addresses[state][" + index + "]", shippingAddressState);
            return this;
        }

        public CreateRequest shippingAddressStateCode(int index, String shippingAddressStateCode) {
            this.params.addOpt("shipping_addresses[state_code][" + index + "]", shippingAddressStateCode);
            return this;
        }

        public CreateRequest shippingAddressCountry(int index, String shippingAddressCountry) {
            this.params.addOpt("shipping_addresses[country][" + index + "]", shippingAddressCountry);
            return this;
        }

        public CreateRequest shippingAddressZip(int index, String shippingAddressZip) {
            this.params.addOpt("shipping_addresses[zip][" + index + "]", shippingAddressZip);
            return this;
        }

        public CreateRequest shippingAddressValidationStatus(int index, ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_addresses[validation_status][" + index + "]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateRequest discountIndex(int index, Integer discountIndex) {
            this.params.addOpt("discounts[index][" + index + "]", discountIndex);
            return this;
        }

        public CreateRequest discountCouponId(int index, String discountCouponId) {
            this.params.addOpt("discounts[coupon_id][" + index + "]", discountCouponId);
            return this;
        }

        public CreateRequest discountPercentage(int index, Double discountPercentage) {
            this.params.addOpt("discounts[percentage][" + index + "]", discountPercentage);
            return this;
        }

        public CreateRequest discountAmount(int index, Long discountAmount) {
            this.params.addOpt("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public CreateRequest discountIncludedInMrr(int index, Boolean discountIncludedInMrr) {
            this.params.addOpt("discounts[included_in_mrr][" + index + "]", discountIncludedInMrr);
            return this;
        }

        public CreateRequest subscriptionInfoIndex(int index, Integer subscriptionInfoIndex) {
            this.params.add("subscription_info[index][" + index + "]", subscriptionInfoIndex);
            return this;
        }

        public CreateRequest subscriptionInfoSubscriptionId(int index, String subscriptionInfoSubscriptionId) {
            this.params.addOpt("subscription_info[subscription_id][" + index + "]", subscriptionInfoSubscriptionId);
            return this;
        }

        public CreateRequest subscriptionInfoBillingCycles(int index, Integer subscriptionInfoBillingCycles) {
            this.params.addOpt("subscription_info[billing_cycles][" + index + "]", subscriptionInfoBillingCycles);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }
}

