/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.Resource;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.ChargeOnEvent;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class QuotedSubscription
extends Resource<QuotedSubscription> {
    public QuotedSubscription(String jsonStr) {
        super(jsonStr);
    }

    public QuotedSubscription(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String planId() {
        return this.reqString("plan_id");
    }

    public Integer planQuantity() {
        return this.reqInteger("plan_quantity");
    }

    public Long planUnitPrice() {
        return this.optLong("plan_unit_price");
    }

    public Long setupFee() {
        return this.optLong("setup_fee");
    }

    public Integer billingPeriod() {
        return this.optInteger("billing_period");
    }

    public BillingPeriodUnit billingPeriodUnit() {
        return this.optEnum("billing_period_unit", BillingPeriodUnit.class);
    }

    public Timestamp startDate() {
        return this.optTimestamp("start_date");
    }

    public Timestamp trialEnd() {
        return this.optTimestamp("trial_end");
    }

    public Integer remainingBillingCycles() {
        return this.optInteger("remaining_billing_cycles");
    }

    public String poNumber() {
        return this.optString("po_number");
    }

    public AutoCollection autoCollection() {
        return this.optEnum("auto_collection", AutoCollection.class);
    }

    public String planQuantityInDecimal() {
        return this.optString("plan_quantity_in_decimal");
    }

    public String planUnitPriceInDecimal() {
        return this.optString("plan_unit_price_in_decimal");
    }

    public Timestamp changesScheduledAt() {
        return this.optTimestamp("changes_scheduled_at");
    }

    public ChangeOption changeOption() {
        return this.optEnum("change_option", ChangeOption.class);
    }

    public Integer contractTermBillingCycleOnRenewal() {
        return this.optInteger("contract_term_billing_cycle_on_renewal");
    }

    public List<Addon> addons() {
        return this.optList("addons", Addon.class);
    }

    public List<EventBasedAddon> eventBasedAddons() {
        return this.optList("event_based_addons", EventBasedAddon.class);
    }

    public List<Coupon> coupons() {
        return this.optList("coupons", Coupon.class);
    }

    public List<SubscriptionItem> subscriptionItems() {
        return this.optList("subscription_items", SubscriptionItem.class);
    }

    public List<ItemTier> itemTiers() {
        return this.optList("item_tiers", ItemTier.class);
    }

    public QuotedContractTerm quotedContractTerm() {
        return this.optSubResource("quoted_contract_term", QuotedContractTerm.class);
    }

    public static class QuotedContractTerm
    extends Resource<QuotedContractTerm> {
        public QuotedContractTerm(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Timestamp contractStart() {
            return this.reqTimestamp("contract_start");
        }

        public Timestamp contractEnd() {
            return this.reqTimestamp("contract_end");
        }

        public Integer billingCycle() {
            return this.reqInteger("billing_cycle");
        }

        public ActionAtTermEnd actionAtTermEnd() {
            return this.reqEnum("action_at_term_end", ActionAtTermEnd.class);
        }

        public Long totalContractValue() {
            return this.reqLong("total_contract_value");
        }

        public Integer cancellationCutoffPeriod() {
            return this.optInteger("cancellation_cutoff_period");
        }

        public static enum ActionAtTermEnd {
            RENEW,
            EVERGREEN,
            CANCEL,
            RENEW_ONCE,
            _UNKNOWN;

        }
    }

    public static class ItemTier
    extends Resource<ItemTier> {
        public ItemTier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String itemPriceId() {
            return this.reqString("item_price_id");
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Long price() {
            return this.reqLong("price");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String priceInDecimal() {
            return this.optString("price_in_decimal");
        }

        public Integer index() {
            return this.reqInteger("index");
        }
    }

    public static class SubscriptionItem
    extends Resource<SubscriptionItem> {
        public SubscriptionItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String itemPriceId() {
            return this.reqString("item_price_id");
        }

        public ItemType itemType() {
            return this.reqEnum("item_type", ItemType.class);
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public String quantityInDecimal() {
            return this.optString("quantity_in_decimal");
        }

        @Deprecated
        public String meteredQuantity() {
            return this.optString("metered_quantity");
        }

        @Deprecated
        public Timestamp lastCalculatedAt() {
            return this.optTimestamp("last_calculated_at");
        }

        public Long unitPrice() {
            return this.optLong("unit_price");
        }

        public String unitPriceInDecimal() {
            return this.optString("unit_price_in_decimal");
        }

        public Long amount() {
            return this.optLong("amount");
        }

        public String amountInDecimal() {
            return this.optString("amount_in_decimal");
        }

        public Integer freeQuantity() {
            return this.optInteger("free_quantity");
        }

        public String freeQuantityInDecimal() {
            return this.optString("free_quantity_in_decimal");
        }

        public Timestamp trialEnd() {
            return this.optTimestamp("trial_end");
        }

        public Integer billingCycles() {
            return this.optInteger("billing_cycles");
        }

        public Integer servicePeriodDays() {
            return this.optInteger("service_period_days");
        }

        public ChargeOnEvent chargeOnEvent() {
            return this.optEnum("charge_on_event", ChargeOnEvent.class);
        }

        public Boolean chargeOnce() {
            return this.optBoolean("charge_once");
        }

        public ChargeOnOption chargeOnOption() {
            return this.optEnum("charge_on_option", ChargeOnOption.class);
        }

        public static enum ChargeOnOption {
            IMMEDIATELY,
            ON_EVENT,
            _UNKNOWN;

        }

        public static enum ItemType {
            PLAN,
            ADDON,
            CHARGE,
            _UNKNOWN;

        }
    }

    public static class Coupon
    extends Resource<Coupon> {
        public Coupon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String couponId() {
            return this.reqString("coupon_id");
        }
    }

    public static class EventBasedAddon
    extends Resource<EventBasedAddon> {
        public EventBasedAddon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Integer quantity() {
            return this.reqInteger("quantity");
        }

        public Long unitPrice() {
            return this.reqLong("unit_price");
        }

        @Deprecated
        public Integer servicePeriodInDays() {
            return this.optInteger("service_period_in_days");
        }

        public OnEvent onEvent() {
            return this.reqEnum("on_event", OnEvent.class);
        }

        public Boolean chargeOnce() {
            return this.reqBoolean("charge_once");
        }

        public String quantityInDecimal() {
            return this.optString("quantity_in_decimal");
        }

        public String unitPriceInDecimal() {
            return this.optString("unit_price_in_decimal");
        }

        public static enum OnEvent {
            SUBSCRIPTION_CREATION,
            SUBSCRIPTION_TRIAL_START,
            PLAN_ACTIVATION,
            SUBSCRIPTION_ACTIVATION,
            CONTRACT_TERMINATION,
            _UNKNOWN;

        }
    }

    public static class Addon
    extends Resource<Addon> {
        public Addon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Long unitPrice() {
            return this.optLong("unit_price");
        }

        public Long amount() {
            return this.optLong("amount");
        }

        public Timestamp trialEnd() {
            return this.optTimestamp("trial_end");
        }

        public Integer remainingBillingCycles() {
            return this.optInteger("remaining_billing_cycles");
        }

        public String quantityInDecimal() {
            return this.optString("quantity_in_decimal");
        }

        public String unitPriceInDecimal() {
            return this.optString("unit_price_in_decimal");
        }

        public String amountInDecimal() {
            return this.optString("amount_in_decimal");
        }
    }

    public static enum ChangeOption {
        END_OF_TERM,
        SPECIFIC_DATE,
        IMMEDIATELY,
        _UNKNOWN;

    }

    public static enum BillingPeriodUnit {
        DAY,
        WEEK,
        MONTH,
        YEAR,
        _UNKNOWN;

    }
}

