/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.CreditNote;
import com.chargebee.models.Invoice;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.org.json.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;

public class Transaction
extends Resource<Transaction> {
    public Transaction(String jsonStr) {
        super(jsonStr);
    }

    public Transaction(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public String gatewayAccountId() {
        return this.optString("gateway_account_id");
    }

    public String paymentSourceId() {
        return this.optString("payment_source_id");
    }

    public PaymentMethod paymentMethod() {
        return this.reqEnum("payment_method", PaymentMethod.class);
    }

    public String referenceNumber() {
        return this.optString("reference_number");
    }

    public Gateway gateway() {
        return this.reqEnum("gateway", Gateway.class);
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public Timestamp date() {
        return this.optTimestamp("date");
    }

    public Timestamp settledAt() {
        return this.optTimestamp("settled_at");
    }

    public BigDecimal exchangeRate() {
        return this.optBigDecimal("exchange_rate");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Long amount() {
        return this.optLong("amount");
    }

    public String idAtGateway() {
        return this.optString("id_at_gateway");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public FraudFlag fraudFlag() {
        return this.optEnum("fraud_flag", FraudFlag.class);
    }

    public InitiatorType initiatorType() {
        return this.optEnum("initiator_type", InitiatorType.class);
    }

    public Boolean threeDSecure() {
        return this.optBoolean("three_d_secure");
    }

    public AuthorizationReason authorizationReason() {
        return this.optEnum("authorization_reason", AuthorizationReason.class);
    }

    public String errorCode() {
        return this.optString("error_code");
    }

    public String errorText() {
        return this.optString("error_text");
    }

    public Timestamp voidedAt() {
        return this.optTimestamp("voided_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public String fraudReason() {
        return this.optString("fraud_reason");
    }

    public Long amountUnused() {
        return this.optLong("amount_unused");
    }

    public String maskedCardNumber() {
        return this.optString("masked_card_number");
    }

    public String referenceTransactionId() {
        return this.optString("reference_transaction_id");
    }

    public String refundedTxnId() {
        return this.optString("refunded_txn_id");
    }

    public String referenceAuthorizationId() {
        return this.optString("reference_authorization_id");
    }

    public Long amountCapturable() {
        return this.optLong("amount_capturable");
    }

    public String reversalTransactionId() {
        return this.optString("reversal_transaction_id");
    }

    public List<LinkedInvoice> linkedInvoices() {
        return this.optList("linked_invoices", LinkedInvoice.class);
    }

    public List<LinkedCreditNote> linkedCreditNotes() {
        return this.optList("linked_credit_notes", LinkedCreditNote.class);
    }

    public List<LinkedRefund> linkedRefunds() {
        return this.optList("linked_refunds", LinkedRefund.class);
    }

    public List<LinkedPayment> linkedPayments() {
        return this.optList("linked_payments", LinkedPayment.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public String iin() {
        return this.optString("iin");
    }

    public String last4() {
        return this.optString("last4");
    }

    public String merchantReferenceId() {
        return this.optString("merchant_reference_id");
    }

    public String businessEntityId() {
        return this.optString("business_entity_id");
    }

    public String paymentMethodDetails() {
        return this.optString("payment_method_details");
    }

    public static CreateAuthorizationRequest createAuthorization() {
        String uri = Transaction.uri("transactions", "create_authorization");
        return new CreateAuthorizationRequest(HttpUtil.Method.POST, uri);
    }

    public static Request voidTransaction(String id) {
        String uri = Transaction.uri("transactions", Transaction.nullCheck(id), "void");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static RecordRefundRequest recordRefund(String id) {
        String uri = Transaction.uri("transactions", Transaction.nullCheck(id), "record_refund");
        return new RecordRefundRequest(HttpUtil.Method.POST, uri);
    }

    public static RefundRequest refund(String id) {
        String uri = Transaction.uri("transactions", Transaction.nullCheck(id), "refund");
        return new RefundRequest(HttpUtil.Method.POST, uri);
    }

    public static TransactionListRequest list() {
        String uri = Transaction.uri("transactions");
        return new TransactionListRequest(uri);
    }

    @Deprecated
    public static ListRequest transactionsForCustomer(String id) {
        String uri = Transaction.uri("customers", Transaction.nullCheck(id), "transactions");
        return new ListRequest(uri);
    }

    @Deprecated
    public static ListRequest transactionsForSubscription(String id) {
        String uri = Transaction.uri("subscriptions", Transaction.nullCheck(id), "transactions");
        return new ListRequest(uri);
    }

    public static ListRequest paymentsForInvoice(String id) {
        String uri = Transaction.uri("invoices", Transaction.nullCheck(id), "payments");
        return new ListRequest(uri);
    }

    public static Request retrieve(String id) {
        String uri = Transaction.uri("transactions", Transaction.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static DeleteOfflineTransactionRequest deleteOfflineTransaction(String id) {
        String uri = Transaction.uri("transactions", Transaction.nullCheck(id), "delete_offline_transaction");
        return new DeleteOfflineTransactionRequest(HttpUtil.Method.POST, uri);
    }

    public static class DeleteOfflineTransactionRequest
    extends Request<DeleteOfflineTransactionRequest> {
        private DeleteOfflineTransactionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteOfflineTransactionRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class TransactionListRequest
    extends ListRequest<TransactionListRequest> {
        private TransactionListRequest(String uri) {
            super(uri);
        }

        public TransactionListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<TransactionListRequest> id() {
            return new StringFilter<TransactionListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<TransactionListRequest> customerId() {
            return new StringFilter<TransactionListRequest>("customer_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<TransactionListRequest> subscriptionId() {
            return new StringFilter<TransactionListRequest>("subscription_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<TransactionListRequest> paymentSourceId() {
            return new StringFilter<TransactionListRequest>("payment_source_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public EnumFilter<PaymentMethod, TransactionListRequest> paymentMethod() {
            return new EnumFilter<PaymentMethod, TransactionListRequest>("payment_method", this);
        }

        public EnumFilter<Gateway, TransactionListRequest> gateway() {
            return new EnumFilter<Gateway, TransactionListRequest>("gateway", this);
        }

        public StringFilter<TransactionListRequest> gatewayAccountId() {
            return new StringFilter<TransactionListRequest>("gateway_account_id", this).supportsMultiOperators(true);
        }

        public StringFilter<TransactionListRequest> idAtGateway() {
            return new StringFilter<TransactionListRequest>("id_at_gateway", this);
        }

        public StringFilter<TransactionListRequest> referenceNumber() {
            return new StringFilter<TransactionListRequest>("reference_number", this).supportsPresenceOperator(true);
        }

        public EnumFilter<Type, TransactionListRequest> type() {
            return new EnumFilter<Type, TransactionListRequest>("type", this);
        }

        public TimestampFilter<TransactionListRequest> date() {
            return new TimestampFilter<TransactionListRequest>("date", this);
        }

        public NumberFilter<Long, TransactionListRequest> amount() {
            return new NumberFilter<Long, TransactionListRequest>("amount", this);
        }

        public NumberFilter<Long, TransactionListRequest> amountCapturable() {
            return new NumberFilter<Long, TransactionListRequest>("amount_capturable", this);
        }

        public EnumFilter<Status, TransactionListRequest> status() {
            return new EnumFilter<Status, TransactionListRequest>("status", this);
        }

        public TimestampFilter<TransactionListRequest> updatedAt() {
            return new TimestampFilter<TransactionListRequest>("updated_at", this);
        }

        public TransactionListRequest sortByDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "date");
            return this;
        }

        public TransactionListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RefundRequest
    extends Request<RefundRequest> {
        private RefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RefundRequest amount(Long amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public RefundRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RecordRefundRequest
    extends Request<RecordRefundRequest> {
        private RecordRefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordRefundRequest amount(Long amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public RecordRefundRequest paymentMethod(PaymentMethod paymentMethod) {
            this.params.add("payment_method", (Object)paymentMethod);
            return this;
        }

        public RecordRefundRequest date(Timestamp date) {
            this.params.add("date", date);
            return this;
        }

        public RecordRefundRequest referenceNumber(String referenceNumber) {
            this.params.addOpt("reference_number", referenceNumber);
            return this;
        }

        public RecordRefundRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateAuthorizationRequest
    extends Request<CreateAuthorizationRequest> {
        private CreateAuthorizationRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateAuthorizationRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateAuthorizationRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CreateAuthorizationRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateAuthorizationRequest amount(Long amount) {
            this.params.add("amount", amount);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class LinkedPayment
    extends Resource<LinkedPayment> {
        public LinkedPayment(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Status status() {
            return this.optEnum("status", Status.class);
        }

        public Long amount() {
            return this.optLong("amount");
        }

        public Timestamp date() {
            return this.optTimestamp("date");
        }

        public static enum Status {
            IN_PROGRESS,
            SUCCESS,
            VOIDED,
            FAILURE,
            TIMEOUT,
            NEEDS_ATTENTION,
            _UNKNOWN;

        }
    }

    public static class LinkedRefund
    extends Resource<LinkedRefund> {
        public LinkedRefund(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String txnId() {
            return this.reqString("txn_id");
        }

        public Status txnStatus() {
            return this.reqEnum("txn_status", Status.class);
        }

        public Timestamp txnDate() {
            return this.reqTimestamp("txn_date");
        }

        public Long txnAmount() {
            return this.reqLong("txn_amount");
        }
    }

    public static class LinkedCreditNote
    extends Resource<LinkedCreditNote> {
        public LinkedCreditNote(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String cnId() {
            return this.reqString("cn_id");
        }

        public Long appliedAmount() {
            return this.reqLong("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public CreditNote.ReasonCode cnReasonCode() {
            return this.optEnum("cn_reason_code", CreditNote.ReasonCode.class);
        }

        public String cnCreateReasonCode() {
            return this.optString("cn_create_reason_code");
        }

        public Timestamp cnDate() {
            return this.optTimestamp("cn_date");
        }

        public Long cnTotal() {
            return this.optLong("cn_total");
        }

        public CreditNote.Status cnStatus() {
            return this.reqEnum("cn_status", CreditNote.Status.class);
        }

        public String cnReferenceInvoiceId() {
            return this.reqString("cn_reference_invoice_id");
        }
    }

    public static class LinkedInvoice
    extends Resource<LinkedInvoice> {
        public LinkedInvoice(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String invoiceId() {
            return this.reqString("invoice_id");
        }

        public Long appliedAmount() {
            return this.reqLong("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public Timestamp invoiceDate() {
            return this.optTimestamp("invoice_date");
        }

        public Long invoiceTotal() {
            return this.optLong("invoice_total");
        }

        public Invoice.Status invoiceStatus() {
            return this.reqEnum("invoice_status", Invoice.Status.class);
        }
    }

    public static enum AuthorizationReason {
        BLOCKING_FUNDS,
        VERIFICATION,
        _UNKNOWN;

    }

    public static enum InitiatorType {
        CUSTOMER,
        MERCHANT,
        _UNKNOWN;

    }

    public static enum FraudFlag {
        SAFE,
        SUSPICIOUS,
        FRAUDULENT,
        _UNKNOWN;

    }

    public static enum Status {
        IN_PROGRESS,
        SUCCESS,
        VOIDED,
        FAILURE,
        TIMEOUT,
        NEEDS_ATTENTION,
        _UNKNOWN;

    }

    public static enum Type {
        AUTHORIZATION,
        PAYMENT,
        REFUND,
        PAYMENT_REVERSAL,
        _UNKNOWN;

    }
}

