/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee;

import com.chargebee.RequestInterceptor;

public class Environment {
    public final String apiKey;
    public final String siteName;
    public int connectTimeout = Integer.getInteger("com.chargebee.api.http.timeout.connect", 30000);
    public int readTimeout = Integer.getInteger("com.chargebee.api.http.timeout.read", 80000);
    public static final String CHARSET = "UTF-8";
    public static final String API_VERSION = "v2";
    public static final String LIBRARY_VERSION = "3.23.0";
    private final String apiBaseUrl;
    private static Environment defaultEnv;
    private RequestInterceptor reqInterceptor;

    public Environment(String siteName, String apiKey) {
        this(siteName, apiKey, null);
    }

    public Environment(String siteName, String apiKey, RequestInterceptor reqInterceptor) {
        this.apiKey = apiKey;
        this.siteName = siteName;
        this.reqInterceptor = reqInterceptor;
        String domainSuffix = System.getProperty("com.chargebee.api.domain.suffix", "chargebee.com");
        String proto = System.getProperty("com.chargebee.api.protocol", "https");
        this.apiBaseUrl = proto + "://" + siteName + "." + domainSuffix + "/api/" + API_VERSION;
    }

    public static void configure(String siteName, String apikey) {
        defaultEnv = new Environment(siteName, apikey);
    }

    public static void reqInterceptor(RequestInterceptor reqInterceptor) {
        Environment.defaultConfig().reqInterceptor = reqInterceptor;
    }

    public RequestInterceptor reqInterceptor() {
        return this.reqInterceptor;
    }

    public static Environment defaultConfig() {
        if (defaultEnv == null) {
            throw new RuntimeException("The default environment has not been configured");
        }
        return defaultEnv;
    }

    public String apiBaseUrl() {
        return this.apiBaseUrl;
    }

    public static void updateConnectTimeoutInMillis(int connectTimeout) {
        Environment.defaultEnv.connectTimeout = connectTimeout;
    }

    public static void updateReadTimeoutInMillis(int readTimeout) {
        Environment.defaultEnv.readTimeout = readTimeout;
    }
}

