/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.filters;

import com.chargebee.internal.Params;
import com.chargebee.internal.RequestBase;
import com.chargebee.org.json.JSONArray;
import java.util.Arrays;
import java.util.List;

public class EnumFilter<T, U extends RequestBase> {
    private U req;
    private String paramName;
    private boolean supportsPresenceOperator;
    private boolean supportsMultiOperators = true;

    public EnumFilter(String paramName, U req) {
        this.paramName = paramName;
        this.req = req;
    }

    public EnumFilter<T, U> supportsPresenceOperator(boolean supportsPresenceOperator) {
        this.supportsPresenceOperator = supportsPresenceOperator;
        return this;
    }

    public EnumFilter<T, U> supportsMultiOperators(boolean supportsMultiOperators) {
        this.supportsMultiOperators = supportsMultiOperators;
        return this;
    }

    public U is(T value) {
        ((RequestBase)this.req).params().addOpt(this.paramName + "[is]", value);
        return this.req;
    }

    public U isNot(T value) {
        ((RequestBase)this.req).params().addOpt(this.paramName + "[is_not]", value);
        return this.req;
    }

    public U in(T ... value) {
        if (!this.supportsMultiOperators) {
            throw new UnsupportedOperationException("operator '[in]' is not supported for this filter-parameter");
        }
        JSONArray jArr = this.serialize(Arrays.asList(value));
        ((RequestBase)this.req).params().addOpt(this.paramName + "[in]", jArr);
        return this.req;
    }

    public U notIn(T ... value) {
        if (!this.supportsMultiOperators) {
            throw new UnsupportedOperationException("operator '[not_in]' is not supported for this filter-parameter");
        }
        JSONArray jArr = this.serialize(Arrays.asList(value));
        ((RequestBase)this.req).params().addOpt(this.paramName + "[not_in]", jArr);
        return this.req;
    }

    public U isPresent(boolean value) {
        if (!this.supportsPresenceOperator) {
            throw new UnsupportedOperationException("operator '[is_present]' is not supported for this filter-parameter");
        }
        ((RequestBase)this.req).params().addOpt(this.paramName + "[is_present]", value);
        return this.req;
    }

    private JSONArray serialize(List<T> list) {
        JSONArray jArr = new JSONArray();
        for (T val : list) {
            jArr.put(Params.toValStr(val));
        }
        return jArr;
    }
}

