/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.BatchEntry;
import com.chargebee.BatchResult;
import com.chargebee.Environment;
import com.chargebee.Result;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Parameter;
import com.chargebee.internal.Request;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class BatchRequest<T extends Request>
extends Request<BatchRequest<T>> {
    List<BatchEntry> entries = new ArrayList<BatchEntry>();
    JSONObject jsonPayload = new JSONObject();
    String pathParamName = null;

    public BatchRequest(HttpUtil.Method httpMeth, String uri) {
        super(httpMeth, uri);
        this.uri = "/batch" + uri;
        this.headers.put("Content-Type", "application/json;charset=UTF-8");
    }

    public BatchRequest(HttpUtil.Method httpMeth, String uri, String pathParamName) {
        this(httpMeth, uri);
        this.pathParamName = pathParamName;
    }

    public BatchRequest<T> addEntry(T requestObject) {
        this.entries.add(new BatchEntry(requestObject));
        return this;
    }

    public BatchRequest<T> addEntry(T requestObject, String correlationId) {
        this.entries.add(new BatchEntry(requestObject, correlationId));
        return this;
    }

    public BatchRequest<T> addEntries(List<BatchEntry<?>> requestObjects) {
        this.entries.addAll(requestObjects);
        return this;
    }

    @Override
    public BatchResult request() throws Exception {
        Result result = super.request();
        return new BatchResult(result.httpCode, result.jsonObj(), result.responseHeaders).get();
    }

    @Override
    public BatchResult request(Environment environment) throws Exception {
        Result result = super.request(environment);
        return new BatchResult(result.httpCode, result.jsonObj(), result.responseHeaders).get();
    }

    public String buildRequest() {
        JSONArray batchRequestArray = new JSONArray();
        for (BatchEntry batchEntry : this.entries) {
            JSONObject batchRequest = new JSONObject();
            List<Parameter> parameterList = batchEntry.getRequestObject().paramsV2().getParameters();
            for (Parameter p : parameterList) {
                batchRequest = p.toJSONBody(batchRequest);
            }
            if (this.pathParamName != null) {
                batchRequest.put(this.pathParamName, batchEntry.getRequestObject().pathParam());
            }
            batchEntry.setParameters(batchRequest);
            batchRequestArray.put(batchEntry.getJSON());
        }
        this.jsonPayload.put("requests", batchRequestArray);
        return this.jsonPayload.toString();
    }
}

