/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.PeriodUnit;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class Coupon
extends Resource<Coupon> {
    public Coupon(String jsonStr) {
        super(jsonStr);
    }

    public Coupon(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String invoiceName() {
        return this.optString("invoice_name");
    }

    public DiscountType discountType() {
        return this.reqEnum("discount_type", DiscountType.class);
    }

    public Double discountPercentage() {
        return this.optDouble("discount_percentage");
    }

    public Long discountAmount() {
        return this.optLong("discount_amount");
    }

    @Deprecated
    public Integer discountQuantity() {
        return this.optInteger("discount_quantity");
    }

    public String currencyCode() {
        return this.optString("currency_code");
    }

    public DurationType durationType() {
        return this.reqEnum("duration_type", DurationType.class);
    }

    @Deprecated
    public Integer durationMonth() {
        return this.optInteger("duration_month");
    }

    public Timestamp validTill() {
        return this.optTimestamp("valid_till");
    }

    public Integer maxRedemptions() {
        return this.optInteger("max_redemptions");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    @Deprecated
    public ApplyDiscountOn applyDiscountOn() {
        return this.reqEnum("apply_discount_on", ApplyDiscountOn.class);
    }

    public ApplyOn applyOn() {
        return this.reqEnum("apply_on", ApplyOn.class);
    }

    public PlanConstraint planConstraint() {
        return this.reqEnum("plan_constraint", PlanConstraint.class);
    }

    public AddonConstraint addonConstraint() {
        return this.reqEnum("addon_constraint", AddonConstraint.class);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp archivedAt() {
        return this.optTimestamp("archived_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Boolean includedInMrr() {
        return this.optBoolean("included_in_mrr");
    }

    public Integer period() {
        return this.optInteger("period");
    }

    public PeriodUnit periodUnit() {
        return this.optEnum("period_unit", PeriodUnit.class);
    }

    public List<String> planIds() {
        return this.optList("plan_ids", String.class);
    }

    public List<String> addonIds() {
        return this.optList("addon_ids", String.class);
    }

    public List<ItemConstraint> itemConstraints() {
        return this.optList("item_constraints", ItemConstraint.class);
    }

    public List<ItemConstraintCriteria> itemConstraintCriteria() {
        return this.optList("item_constraint_criteria", ItemConstraintCriteria.class);
    }

    public Integer redemptions() {
        return this.optInteger("redemptions");
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public List<CouponConstraint> couponConstraints() {
        return this.optList("coupon_constraints", CouponConstraint.class);
    }

    public static CreateRequest create() {
        String uri = Coupon.uri("coupons");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateForItemsRequest createForItems() {
        String uri = Coupon.uri("coupons", "create_for_items");
        return new CreateForItemsRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateForItemsRequest updateForItems(String id) {
        String uri = Coupon.uri("coupons", Coupon.nullCheck(id), "update_for_items");
        return new UpdateForItemsRequest(HttpUtil.Method.POST, uri);
    }

    public static CouponListRequest list() {
        String uri = Coupon.uri("coupons");
        return new CouponListRequest(uri);
    }

    public static Request retrieve(String id) {
        String uri = Coupon.uri("coupons", Coupon.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = Coupon.uri("coupons", Coupon.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) {
        String uri = Coupon.uri("coupons", Coupon.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static CopyRequest copy() {
        String uri = Coupon.uri("coupons", "copy");
        return new CopyRequest(HttpUtil.Method.POST, uri);
    }

    public static Request unarchive(String id) {
        String uri = Coupon.uri("coupons", Coupon.nullCheck(id), "unarchive");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class CopyRequest
    extends Request<CopyRequest> {
        private CopyRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CopyRequest fromSite(String fromSite) {
            this.params.add("from_site", fromSite);
            return this;
        }

        public CopyRequest idAtFromSite(String idAtFromSite) {
            this.params.add("id_at_from_site", idAtFromSite);
            return this;
        }

        public CopyRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CopyRequest forSiteMerging(Boolean forSiteMerging) {
            this.params.addOpt("for_site_merging", forSiteMerging);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public UpdateRequest discountType(DiscountType discountType) {
            this.params.addOpt("discount_type", (Object)discountType);
            return this;
        }

        public UpdateRequest discountAmount(Long discountAmount) {
            this.params.addOpt("discount_amount", discountAmount);
            return this;
        }

        public UpdateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public UpdateRequest discountPercentage(Double discountPercentage) {
            this.params.addOpt("discount_percentage", discountPercentage);
            return this;
        }

        @Deprecated
        public UpdateRequest discountQuantity(Integer discountQuantity) {
            this.params.addOpt("discount_quantity", discountQuantity);
            return this;
        }

        public UpdateRequest applyOn(ApplyOn applyOn) {
            this.params.addOpt("apply_on", (Object)applyOn);
            return this;
        }

        public UpdateRequest durationType(DurationType durationType) {
            this.params.addOpt("duration_type", (Object)durationType);
            return this;
        }

        public UpdateRequest durationMonth(Integer durationMonth) {
            this.params.addOpt("duration_month", durationMonth);
            return this;
        }

        public UpdateRequest validTill(Timestamp validTill) {
            this.params.addOpt("valid_till", validTill);
            return this;
        }

        public UpdateRequest maxRedemptions(Integer maxRedemptions) {
            this.params.addOpt("max_redemptions", maxRedemptions);
            return this;
        }

        public UpdateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public UpdateRequest includedInMrr(Boolean includedInMrr) {
            this.params.addOpt("included_in_mrr", includedInMrr);
            return this;
        }

        public UpdateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public UpdateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public UpdateRequest planConstraint(PlanConstraint planConstraint) {
            this.params.addOpt("plan_constraint", (Object)planConstraint);
            return this;
        }

        public UpdateRequest addonConstraint(AddonConstraint addonConstraint) {
            this.params.addOpt("addon_constraint", (Object)addonConstraint);
            return this;
        }

        public UpdateRequest planIds(List<String> planIds) {
            this.params.addOpt("plan_ids", planIds);
            return this;
        }

        public UpdateRequest planIds(String ... planIds) {
            this.params.addOpt("plan_ids", planIds);
            return this;
        }

        public UpdateRequest addonIds(List<String> addonIds) {
            this.params.addOpt("addon_ids", addonIds);
            return this;
        }

        public UpdateRequest addonIds(String ... addonIds) {
            this.params.addOpt("addon_ids", addonIds);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CouponListRequest
    extends ListRequest<CouponListRequest> {
        private CouponListRequest(String uri) {
            super(uri);
        }

        public StringFilter<CouponListRequest> id() {
            return new StringFilter<CouponListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<CouponListRequest> name() {
            return new StringFilter<CouponListRequest>("name", this).supportsMultiOperators(true);
        }

        public EnumFilter<DiscountType, CouponListRequest> discountType() {
            return new EnumFilter<DiscountType, CouponListRequest>("discount_type", this);
        }

        public EnumFilter<DurationType, CouponListRequest> durationType() {
            return new EnumFilter<DurationType, CouponListRequest>("duration_type", this);
        }

        public EnumFilter<Status, CouponListRequest> status() {
            return new EnumFilter<Status, CouponListRequest>("status", this);
        }

        public EnumFilter<ApplyOn, CouponListRequest> applyOn() {
            return new EnumFilter<ApplyOn, CouponListRequest>("apply_on", this);
        }

        public TimestampFilter<CouponListRequest> createdAt() {
            return new TimestampFilter<CouponListRequest>("created_at", this);
        }

        public TimestampFilter<CouponListRequest> updatedAt() {
            return new TimestampFilter<CouponListRequest>("updated_at", this);
        }

        public CouponListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        public StringFilter<CouponListRequest> currencyCode() {
            return new StringFilter<CouponListRequest>("currency_code", this).supportsMultiOperators(true);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateForItemsRequest
    extends Request<UpdateForItemsRequest> {
        private UpdateForItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateForItemsRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateForItemsRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public UpdateForItemsRequest discountType(DiscountType discountType) {
            this.params.addOpt("discount_type", (Object)discountType);
            return this;
        }

        public UpdateForItemsRequest discountAmount(Long discountAmount) {
            this.params.addOpt("discount_amount", discountAmount);
            return this;
        }

        public UpdateForItemsRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public UpdateForItemsRequest discountPercentage(Double discountPercentage) {
            this.params.addOpt("discount_percentage", discountPercentage);
            return this;
        }

        @Deprecated
        public UpdateForItemsRequest discountQuantity(Integer discountQuantity) {
            this.params.addOpt("discount_quantity", discountQuantity);
            return this;
        }

        public UpdateForItemsRequest applyOn(ApplyOn applyOn) {
            this.params.addOpt("apply_on", (Object)applyOn);
            return this;
        }

        public UpdateForItemsRequest durationType(DurationType durationType) {
            this.params.addOpt("duration_type", (Object)durationType);
            return this;
        }

        public UpdateForItemsRequest durationMonth(Integer durationMonth) {
            this.params.addOpt("duration_month", durationMonth);
            return this;
        }

        public UpdateForItemsRequest validTill(Timestamp validTill) {
            this.params.addOpt("valid_till", validTill);
            return this;
        }

        public UpdateForItemsRequest maxRedemptions(Integer maxRedemptions) {
            this.params.addOpt("max_redemptions", maxRedemptions);
            return this;
        }

        public UpdateForItemsRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateForItemsRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public UpdateForItemsRequest includedInMrr(Boolean includedInMrr) {
            this.params.addOpt("included_in_mrr", includedInMrr);
            return this;
        }

        public UpdateForItemsRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public UpdateForItemsRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public UpdateForItemsRequest itemConstraintConstraint(int index, ItemConstraint.Constraint itemConstraintConstraint) {
            this.params.add("item_constraints[constraint][" + index + "]", (Object)itemConstraintConstraint);
            return this;
        }

        public UpdateForItemsRequest itemConstraintItemType(int index, ItemConstraint.ItemType itemConstraintItemType) {
            this.params.add("item_constraints[item_type][" + index + "]", (Object)itemConstraintItemType);
            return this;
        }

        public UpdateForItemsRequest itemConstraintItemPriceIds(int index, JSONArray itemConstraintItemPriceIds) {
            this.params.addOpt("item_constraints[item_price_ids][" + index + "]", itemConstraintItemPriceIds);
            return this;
        }

        public UpdateForItemsRequest itemConstraintCriteriaItemType(int index, ItemConstraintCriteria.ItemType itemConstraintCriteriaItemType) {
            this.params.addOpt("item_constraint_criteria[item_type][" + index + "]", (Object)itemConstraintCriteriaItemType);
            return this;
        }

        public UpdateForItemsRequest itemConstraintCriteriaItemFamilyIds(int index, JSONArray itemConstraintCriteriaItemFamilyIds) {
            this.params.addOpt("item_constraint_criteria[item_family_ids][" + index + "]", itemConstraintCriteriaItemFamilyIds);
            return this;
        }

        public UpdateForItemsRequest itemConstraintCriteriaCurrencies(int index, JSONArray itemConstraintCriteriaCurrencies) {
            this.params.addOpt("item_constraint_criteria[currencies][" + index + "]", itemConstraintCriteriaCurrencies);
            return this;
        }

        public UpdateForItemsRequest itemConstraintCriteriaItemPricePeriods(int index, JSONArray itemConstraintCriteriaItemPricePeriods) {
            this.params.addOpt("item_constraint_criteria[item_price_periods][" + index + "]", itemConstraintCriteriaItemPricePeriods);
            return this;
        }

        public UpdateForItemsRequest couponConstraintEntityType(int index, CouponConstraint.EntityType couponConstraintEntityType) {
            this.params.add("coupon_constraints[entity_type][" + index + "]", (Object)couponConstraintEntityType);
            return this;
        }

        public UpdateForItemsRequest couponConstraintType(int index, CouponConstraint.Type couponConstraintType) {
            this.params.add("coupon_constraints[type][" + index + "]", (Object)couponConstraintType);
            return this;
        }

        public UpdateForItemsRequest couponConstraintValue(int index, String couponConstraintValue) {
            this.params.addOpt("coupon_constraints[value][" + index + "]", couponConstraintValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateForItemsRequest
    extends Request<CreateForItemsRequest> {
        private CreateForItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateForItemsRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateForItemsRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateForItemsRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public CreateForItemsRequest discountType(DiscountType discountType) {
            this.params.addOpt("discount_type", (Object)discountType);
            return this;
        }

        public CreateForItemsRequest discountAmount(Long discountAmount) {
            this.params.addOpt("discount_amount", discountAmount);
            return this;
        }

        public CreateForItemsRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateForItemsRequest discountPercentage(Double discountPercentage) {
            this.params.addOpt("discount_percentage", discountPercentage);
            return this;
        }

        @Deprecated
        public CreateForItemsRequest discountQuantity(Integer discountQuantity) {
            this.params.addOpt("discount_quantity", discountQuantity);
            return this;
        }

        public CreateForItemsRequest applyOn(ApplyOn applyOn) {
            this.params.add("apply_on", (Object)applyOn);
            return this;
        }

        public CreateForItemsRequest durationType(DurationType durationType) {
            this.params.addOpt("duration_type", (Object)durationType);
            return this;
        }

        public CreateForItemsRequest durationMonth(Integer durationMonth) {
            this.params.addOpt("duration_month", durationMonth);
            return this;
        }

        public CreateForItemsRequest validTill(Timestamp validTill) {
            this.params.addOpt("valid_till", validTill);
            return this;
        }

        public CreateForItemsRequest maxRedemptions(Integer maxRedemptions) {
            this.params.addOpt("max_redemptions", maxRedemptions);
            return this;
        }

        public CreateForItemsRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateForItemsRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public CreateForItemsRequest includedInMrr(Boolean includedInMrr) {
            this.params.addOpt("included_in_mrr", includedInMrr);
            return this;
        }

        public CreateForItemsRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public CreateForItemsRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public CreateForItemsRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public CreateForItemsRequest itemConstraintConstraint(int index, ItemConstraint.Constraint itemConstraintConstraint) {
            this.params.add("item_constraints[constraint][" + index + "]", (Object)itemConstraintConstraint);
            return this;
        }

        public CreateForItemsRequest itemConstraintItemType(int index, ItemConstraint.ItemType itemConstraintItemType) {
            this.params.add("item_constraints[item_type][" + index + "]", (Object)itemConstraintItemType);
            return this;
        }

        public CreateForItemsRequest itemConstraintItemPriceIds(int index, JSONArray itemConstraintItemPriceIds) {
            this.params.addOpt("item_constraints[item_price_ids][" + index + "]", itemConstraintItemPriceIds);
            return this;
        }

        public CreateForItemsRequest itemConstraintCriteriaItemType(int index, ItemConstraintCriteria.ItemType itemConstraintCriteriaItemType) {
            this.params.addOpt("item_constraint_criteria[item_type][" + index + "]", (Object)itemConstraintCriteriaItemType);
            return this;
        }

        public CreateForItemsRequest itemConstraintCriteriaItemFamilyIds(int index, JSONArray itemConstraintCriteriaItemFamilyIds) {
            this.params.addOpt("item_constraint_criteria[item_family_ids][" + index + "]", itemConstraintCriteriaItemFamilyIds);
            return this;
        }

        public CreateForItemsRequest itemConstraintCriteriaCurrencies(int index, JSONArray itemConstraintCriteriaCurrencies) {
            this.params.addOpt("item_constraint_criteria[currencies][" + index + "]", itemConstraintCriteriaCurrencies);
            return this;
        }

        public CreateForItemsRequest itemConstraintCriteriaItemPricePeriods(int index, JSONArray itemConstraintCriteriaItemPricePeriods) {
            this.params.addOpt("item_constraint_criteria[item_price_periods][" + index + "]", itemConstraintCriteriaItemPricePeriods);
            return this;
        }

        public CreateForItemsRequest couponConstraintEntityType(int index, CouponConstraint.EntityType couponConstraintEntityType) {
            this.params.add("coupon_constraints[entity_type][" + index + "]", (Object)couponConstraintEntityType);
            return this;
        }

        public CreateForItemsRequest couponConstraintType(int index, CouponConstraint.Type couponConstraintType) {
            this.params.add("coupon_constraints[type][" + index + "]", (Object)couponConstraintType);
            return this;
        }

        public CreateForItemsRequest couponConstraintValue(int index, String couponConstraintValue) {
            this.params.addOpt("coupon_constraints[value][" + index + "]", couponConstraintValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public CreateRequest discountType(DiscountType discountType) {
            this.params.addOpt("discount_type", (Object)discountType);
            return this;
        }

        public CreateRequest discountAmount(Long discountAmount) {
            this.params.addOpt("discount_amount", discountAmount);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateRequest discountPercentage(Double discountPercentage) {
            this.params.addOpt("discount_percentage", discountPercentage);
            return this;
        }

        @Deprecated
        public CreateRequest discountQuantity(Integer discountQuantity) {
            this.params.addOpt("discount_quantity", discountQuantity);
            return this;
        }

        public CreateRequest applyOn(ApplyOn applyOn) {
            this.params.add("apply_on", (Object)applyOn);
            return this;
        }

        public CreateRequest durationType(DurationType durationType) {
            this.params.addOpt("duration_type", (Object)durationType);
            return this;
        }

        public CreateRequest durationMonth(Integer durationMonth) {
            this.params.addOpt("duration_month", durationMonth);
            return this;
        }

        public CreateRequest validTill(Timestamp validTill) {
            this.params.addOpt("valid_till", validTill);
            return this;
        }

        public CreateRequest maxRedemptions(Integer maxRedemptions) {
            this.params.addOpt("max_redemptions", maxRedemptions);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public CreateRequest includedInMrr(Boolean includedInMrr) {
            this.params.addOpt("included_in_mrr", includedInMrr);
            return this;
        }

        public CreateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public CreateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public CreateRequest planConstraint(PlanConstraint planConstraint) {
            this.params.addOpt("plan_constraint", (Object)planConstraint);
            return this;
        }

        public CreateRequest addonConstraint(AddonConstraint addonConstraint) {
            this.params.addOpt("addon_constraint", (Object)addonConstraint);
            return this;
        }

        public CreateRequest planIds(List<String> planIds) {
            this.params.addOpt("plan_ids", planIds);
            return this;
        }

        public CreateRequest planIds(String ... planIds) {
            this.params.addOpt("plan_ids", planIds);
            return this;
        }

        public CreateRequest addonIds(List<String> addonIds) {
            this.params.addOpt("addon_ids", addonIds);
            return this;
        }

        public CreateRequest addonIds(String ... addonIds) {
            this.params.addOpt("addon_ids", addonIds);
            return this;
        }

        public CreateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CouponConstraint
    extends Resource<CouponConstraint> {
        public CouponConstraint(JSONObject jsonObj) {
            super(jsonObj);
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public Type type() {
            return this.reqEnum("type", Type.class);
        }

        public String value() {
            return this.optString("value");
        }

        public static enum Type {
            MAX_REDEMPTIONS,
            UNIQUE_BY,
            _UNKNOWN;

        }

        public static enum EntityType {
            CUSTOMER,
            _UNKNOWN;

        }
    }

    public static class ItemConstraintCriteria
    extends Resource<ItemConstraintCriteria> {
        public ItemConstraintCriteria(JSONObject jsonObj) {
            super(jsonObj);
        }

        public ItemType itemType() {
            return this.reqEnum("item_type", ItemType.class);
        }

        public JSONArray currencies() {
            return this.optJSONArray("currencies");
        }

        public JSONArray itemFamilyIds() {
            return this.optJSONArray("item_family_ids");
        }

        public JSONArray itemPricePeriods() {
            return this.optJSONArray("item_price_periods");
        }

        public static enum ItemType {
            PLAN,
            ADDON,
            CHARGE,
            _UNKNOWN;

        }
    }

    public static class ItemConstraint
    extends Resource<ItemConstraint> {
        public ItemConstraint(JSONObject jsonObj) {
            super(jsonObj);
        }

        public ItemType itemType() {
            return this.reqEnum("item_type", ItemType.class);
        }

        public Constraint constraint() {
            return this.reqEnum("constraint", Constraint.class);
        }

        public JSONArray itemPriceIds() {
            return this.optJSONArray("item_price_ids");
        }

        public static enum Constraint {
            NONE,
            ALL,
            SPECIFIC,
            CRITERIA,
            _UNKNOWN;

        }

        public static enum ItemType {
            PLAN,
            ADDON,
            CHARGE,
            _UNKNOWN;

        }
    }

    public static enum PlanConstraint {
        NONE,
        ALL,
        SPECIFIC,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    public static enum AddonConstraint {
        NONE,
        ALL,
        SPECIFIC,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    public static enum ApplyOn {
        INVOICE_AMOUNT,
        SPECIFIED_ITEMS_TOTAL,
        EACH_SPECIFIED_ITEM,
        EACH_UNIT_OF_SPECIFIED_ITEMS,
        _UNKNOWN;

    }

    @Deprecated
    public static enum ApplyDiscountOn {
        PLANS,
        PLANS_AND_ADDONS,
        PLANS_WITH_QUANTITY,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    public static enum Status {
        ACTIVE,
        EXPIRED,
        ARCHIVED,
        DELETED,
        _UNKNOWN;

    }

    public static enum DurationType {
        ONE_TIME,
        FOREVER,
        LIMITED_PERIOD,
        _UNKNOWN;

    }

    public static enum DiscountType {
        FIXED_AMOUNT,
        PERCENTAGE,
        OFFER_QUANTITY,
        _UNKNOWN;

    }
}

