/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class Currency
extends Resource<Currency> {
    public Currency(String jsonStr) {
        super(jsonStr);
    }

    public Currency(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.optString("id");
    }

    public Boolean enabled() {
        return this.reqBoolean("enabled");
    }

    public ForexType forexType() {
        return this.optEnum("forex_type", ForexType.class);
    }

    public String currencyCode() {
        return this.optString("currency_code");
    }

    public Boolean isBaseCurrency() {
        return this.optBoolean("is_base_currency");
    }

    public String manualExchangeRate() {
        return this.optString("manual_exchange_rate");
    }

    public static Request list() {
        String uri = Currency.uri("currencies", "list");
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request retrieve(String id) {
        String uri = Currency.uri("currencies", Currency.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static CreateRequest create() {
        String uri = Currency.uri("currencies");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = Currency.uri("currencies", Currency.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static AddScheduleRequest addSchedule(String id) {
        String uri = Currency.uri("currencies", Currency.nullCheck(id), "add_schedule");
        return new AddScheduleRequest(HttpUtil.Method.POST, uri);
    }

    public static Request removeSchedule(String id) {
        String uri = Currency.uri("currencies", Currency.nullCheck(id), "remove_schedule");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class AddScheduleRequest
    extends Request<AddScheduleRequest> {
        private AddScheduleRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddScheduleRequest manualExchangeRate(String manualExchangeRate) {
            this.params.add("manual_exchange_rate", manualExchangeRate);
            return this;
        }

        public AddScheduleRequest scheduleAt(Timestamp scheduleAt) {
            this.params.add("schedule_at", scheduleAt);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest forexType(ForexType forexType) {
            this.params.add("forex_type", (Object)forexType);
            return this;
        }

        public UpdateRequest manualExchangeRate(String manualExchangeRate) {
            this.params.addOpt("manual_exchange_rate", manualExchangeRate);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.add("currency_code", currencyCode);
            return this;
        }

        public CreateRequest forexType(ForexType forexType) {
            this.params.add("forex_type", (Object)forexType);
            return this;
        }

        public CreateRequest manualExchangeRate(String manualExchangeRate) {
            this.params.addOpt("manual_exchange_rate", manualExchangeRate);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum ForexType {
        MANUAL,
        AUTO,
        _UNKNOWN;

    }
}

