/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class Installment
extends Resource<Installment> {
    public Installment(String jsonStr) {
        super(jsonStr);
    }

    public Installment(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String invoiceId() {
        return this.reqString("invoice_id");
    }

    public Timestamp date() {
        return this.reqTimestamp("date");
    }

    public Long amount() {
        return this.reqLong("amount");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public static Request retrieve(String id) {
        String uri = Installment.uri("installments", Installment.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static InstallmentListRequest list() {
        String uri = Installment.uri("installments");
        return new InstallmentListRequest(uri);
    }

    public static class InstallmentListRequest
    extends ListRequest<InstallmentListRequest> {
        private InstallmentListRequest(String uri) {
            super(uri);
        }

        public InstallmentListRequest sortBy(String sortBy) {
            this.params.addOpt("sort_by", sortBy);
            return this;
        }

        public StringFilter<InstallmentListRequest> invoiceId() {
            return new StringFilter<InstallmentListRequest>("invoice_id", this).supportsMultiOperators(true);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum Status {
        POSTED,
        PAYMENT_DUE,
        PAID,
        _UNKNOWN;

    }
}

