/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;

public class InstallmentConfig
extends Resource<InstallmentConfig> {
    public InstallmentConfig(String jsonStr) {
        super(jsonStr);
    }

    public InstallmentConfig(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String description() {
        return this.optString("description");
    }

    public Integer numberOfInstallments() {
        return this.reqInteger("number_of_installments");
    }

    public PeriodUnit periodUnit() {
        return this.reqEnum("period_unit", PeriodUnit.class);
    }

    public Integer period() {
        return this.optInteger("period");
    }

    public Integer preferredDay() {
        return this.optInteger("preferred_day");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public List<Installment> installments() {
        return this.optList("installments", Installment.class);
    }

    public static CreateRequest create() {
        String uri = InstallmentConfig.uri("installment_configs");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = InstallmentConfig.uri("installment_configs", InstallmentConfig.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request delete(String id) {
        String uri = InstallmentConfig.uri("installment_configs", InstallmentConfig.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest numberOfInstallments(Integer numberOfInstallments) {
            this.params.add("number_of_installments", numberOfInstallments);
            return this;
        }

        public CreateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.add("period_unit", (Object)periodUnit);
            return this;
        }

        public CreateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public CreateRequest preferredDay(Integer preferredDay) {
            this.params.addOpt("preferred_day", preferredDay);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public CreateRequest installmentPeriod(int index, Integer installmentPeriod) {
            this.params.addOpt("installments[period][" + index + "]", installmentPeriod);
            return this;
        }

        public CreateRequest installmentAmountPercentage(int index, BigDecimal installmentAmountPercentage) {
            this.params.addOpt("installments[amount_percentage][" + index + "]", installmentAmountPercentage);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Installment
    extends Resource<Installment> {
        public Installment(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer period() {
            return this.optInteger("period");
        }

        public BigDecimal amountPercentage() {
            return this.optBigDecimal("amount_percentage");
        }
    }

    public static enum PeriodUnit {
        DAY,
        WEEK,
        MONTH,
        _UNKNOWN;

    }
}

