/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.AvalaraSaleType;
import com.chargebee.models.enums.Channel;
import com.chargebee.models.enums.ItemType;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class ItemPrice
extends Resource<ItemPrice> {
    public ItemPrice(String jsonStr) {
        super(jsonStr);
    }

    public ItemPrice(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String itemFamilyId() {
        return this.optString("item_family_id");
    }

    public String itemId() {
        return this.optString("item_id");
    }

    public String description() {
        return this.optString("description");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public String externalName() {
        return this.optString("external_name");
    }

    public String priceVariantId() {
        return this.optString("price_variant_id");
    }

    public ProrationType prorationType() {
        return this.optEnum("proration_type", ProrationType.class);
    }

    public PricingModel pricingModel() {
        return this.reqEnum("pricing_model", PricingModel.class);
    }

    public Long price() {
        return this.optLong("price");
    }

    public String priceInDecimal() {
        return this.optString("price_in_decimal");
    }

    public Integer period() {
        return this.optInteger("period");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public PeriodUnit periodUnit() {
        return this.optEnum("period_unit", PeriodUnit.class);
    }

    public Integer trialPeriod() {
        return this.optInteger("trial_period");
    }

    public TrialPeriodUnit trialPeriodUnit() {
        return this.optEnum("trial_period_unit", TrialPeriodUnit.class);
    }

    public TrialEndAction trialEndAction() {
        return this.optEnum("trial_end_action", TrialEndAction.class);
    }

    public Integer shippingPeriod() {
        return this.optInteger("shipping_period");
    }

    public ShippingPeriodUnit shippingPeriodUnit() {
        return this.optEnum("shipping_period_unit", ShippingPeriodUnit.class);
    }

    public Integer billingCycles() {
        return this.optInteger("billing_cycles");
    }

    public Integer freeQuantity() {
        return this.reqInteger("free_quantity");
    }

    public String freeQuantityInDecimal() {
        return this.optString("free_quantity_in_decimal");
    }

    public Channel channel() {
        return this.optEnum("channel", Channel.class);
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp archivedAt() {
        return this.optTimestamp("archived_at");
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public List<Tier> tiers() {
        return this.optList("tiers", Tier.class);
    }

    public Boolean isTaxable() {
        return this.optBoolean("is_taxable");
    }

    public TaxDetail taxDetail() {
        return this.optSubResource("tax_detail", TaxDetail.class);
    }

    public List<TaxProvidersField> taxProvidersFields() {
        return this.optList("tax_providers_fields", TaxProvidersField.class);
    }

    public AccountingDetail accountingDetail() {
        return this.optSubResource("accounting_detail", AccountingDetail.class);
    }

    public JSONObject metadata() {
        return this.optJSONObject("metadata");
    }

    public ItemType itemType() {
        return this.optEnum("item_type", ItemType.class);
    }

    @Deprecated
    public Boolean archivable() {
        return this.optBoolean("archivable");
    }

    @Deprecated
    public String parentItemId() {
        return this.optString("parent_item_id");
    }

    public Boolean showDescriptionInInvoices() {
        return this.optBoolean("show_description_in_invoices");
    }

    public Boolean showDescriptionInQuotes() {
        return this.optBoolean("show_description_in_quotes");
    }

    public static CreateRequest create() {
        String uri = ItemPrice.uri("item_prices");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = ItemPrice.uri("item_prices", ItemPrice.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = ItemPrice.uri("item_prices", ItemPrice.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static ItemPriceListRequest list() {
        String uri = ItemPrice.uri("item_prices");
        return new ItemPriceListRequest(uri);
    }

    public static Request delete(String id) {
        String uri = ItemPrice.uri("item_prices", ItemPrice.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static ItemPriceFindApplicableItemsRequest findApplicableItems(String id) {
        String uri = ItemPrice.uri("item_prices", ItemPrice.nullCheck(id), "applicable_items");
        return new ItemPriceFindApplicableItemsRequest(uri);
    }

    public static ItemPriceFindApplicableItemPricesRequest findApplicableItemPrices(String id) {
        String uri = ItemPrice.uri("item_prices", ItemPrice.nullCheck(id), "applicable_item_prices");
        return new ItemPriceFindApplicableItemPricesRequest(uri);
    }

    public static class ItemPriceFindApplicableItemPricesRequest
    extends ListRequest<ItemPriceFindApplicableItemPricesRequest> {
        private ItemPriceFindApplicableItemPricesRequest(String uri) {
            super(uri);
        }

        public ItemPriceFindApplicableItemPricesRequest itemId(String itemId) {
            this.params.addOpt("item_id", itemId);
            return this;
        }

        public ItemPriceFindApplicableItemPricesRequest sortByName(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "name");
            return this;
        }

        public ItemPriceFindApplicableItemPricesRequest sortById(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "id");
            return this;
        }

        public ItemPriceFindApplicableItemPricesRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ItemPriceFindApplicableItemsRequest
    extends ListRequest<ItemPriceFindApplicableItemsRequest> {
        private ItemPriceFindApplicableItemsRequest(String uri) {
            super(uri);
        }

        public ItemPriceFindApplicableItemsRequest sortByName(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "name");
            return this;
        }

        public ItemPriceFindApplicableItemsRequest sortById(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "id");
            return this;
        }

        public ItemPriceFindApplicableItemsRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ItemPriceListRequest
    extends ListRequest<ItemPriceListRequest> {
        private ItemPriceListRequest(String uri) {
            super(uri);
        }

        public StringFilter<ItemPriceListRequest> id() {
            return new StringFilter<ItemPriceListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemPriceListRequest> name() {
            return new StringFilter<ItemPriceListRequest>("name", this).supportsMultiOperators(true);
        }

        public EnumFilter<PricingModel, ItemPriceListRequest> pricingModel() {
            return new EnumFilter<PricingModel, ItemPriceListRequest>("pricing_model", this);
        }

        public StringFilter<ItemPriceListRequest> itemId() {
            return new StringFilter<ItemPriceListRequest>("item_id", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemPriceListRequest> itemFamilyId() {
            return new StringFilter<ItemPriceListRequest>("item_family_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<ItemType, ItemPriceListRequest> itemType() {
            return new EnumFilter<ItemType, ItemPriceListRequest>("item_type", this);
        }

        public StringFilter<ItemPriceListRequest> currencyCode() {
            return new StringFilter<ItemPriceListRequest>("currency_code", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemPriceListRequest> priceVariantId() {
            return new StringFilter<ItemPriceListRequest>("price_variant_id", this).supportsMultiOperators(true);
        }

        public NumberFilter<Integer, ItemPriceListRequest> trialPeriod() {
            return new NumberFilter<Integer, ItemPriceListRequest>("trial_period", this);
        }

        public EnumFilter<TrialPeriodUnit, ItemPriceListRequest> trialPeriodUnit() {
            return new EnumFilter<TrialPeriodUnit, ItemPriceListRequest>("trial_period_unit", this);
        }

        public EnumFilter<Status, ItemPriceListRequest> status() {
            return new EnumFilter<Status, ItemPriceListRequest>("status", this);
        }

        public TimestampFilter<ItemPriceListRequest> updatedAt() {
            return new TimestampFilter<ItemPriceListRequest>("updated_at", this);
        }

        public EnumFilter<PeriodUnit, ItemPriceListRequest> periodUnit() {
            return new EnumFilter<PeriodUnit, ItemPriceListRequest>("period_unit", this);
        }

        public NumberFilter<Integer, ItemPriceListRequest> period() {
            return new NumberFilter<Integer, ItemPriceListRequest>("period", this);
        }

        public EnumFilter<Channel, ItemPriceListRequest> channel() {
            return new EnumFilter<Channel, ItemPriceListRequest>("channel", this);
        }

        public ItemPriceListRequest sortByName(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "name");
            return this;
        }

        public ItemPriceListRequest sortById(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "id");
            return this;
        }

        public ItemPriceListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public UpdateRequest prorationType(ProrationType prorationType) {
            this.params.addOpt("proration_type", (Object)prorationType);
            return this;
        }

        public UpdateRequest priceVariantId(String priceVariantId) {
            this.params.addOpt("price_variant_id", priceVariantId);
            return this;
        }

        public UpdateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public UpdateRequest externalName(String externalName) {
            this.params.addOpt("external_name", externalName);
            return this;
        }

        public UpdateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public UpdateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateRequest isTaxable(Boolean isTaxable) {
            this.params.addOpt("is_taxable", isTaxable);
            return this;
        }

        public UpdateRequest freeQuantity(Integer freeQuantity) {
            this.params.addOpt("free_quantity", freeQuantity);
            return this;
        }

        public UpdateRequest freeQuantityInDecimal(String freeQuantityInDecimal) {
            this.params.addOpt("free_quantity_in_decimal", freeQuantityInDecimal);
            return this;
        }

        public UpdateRequest metadata(JSONObject metadata) {
            this.params.addOpt("metadata", metadata);
            return this;
        }

        public UpdateRequest pricingModel(PricingModel pricingModel) {
            this.params.addOpt("pricing_model", (Object)pricingModel);
            return this;
        }

        public UpdateRequest price(Long price) {
            this.params.addOpt("price", price);
            return this;
        }

        public UpdateRequest priceInDecimal(String priceInDecimal) {
            this.params.addOpt("price_in_decimal", priceInDecimal);
            return this;
        }

        public UpdateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public UpdateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public UpdateRequest trialPeriodUnit(TrialPeriodUnit trialPeriodUnit) {
            this.params.addOpt("trial_period_unit", (Object)trialPeriodUnit);
            return this;
        }

        public UpdateRequest trialPeriod(Integer trialPeriod) {
            this.params.addOpt("trial_period", trialPeriod);
            return this;
        }

        public UpdateRequest shippingPeriod(Integer shippingPeriod) {
            this.params.addOpt("shipping_period", shippingPeriod);
            return this;
        }

        public UpdateRequest shippingPeriodUnit(ShippingPeriodUnit shippingPeriodUnit) {
            this.params.addOpt("shipping_period_unit", (Object)shippingPeriodUnit);
            return this;
        }

        public UpdateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public UpdateRequest trialEndAction(TrialEndAction trialEndAction) {
            this.params.addOpt("trial_end_action", (Object)trialEndAction);
            return this;
        }

        public UpdateRequest showDescriptionInInvoices(Boolean showDescriptionInInvoices) {
            this.params.addOpt("show_description_in_invoices", showDescriptionInInvoices);
            return this;
        }

        public UpdateRequest showDescriptionInQuotes(Boolean showDescriptionInQuotes) {
            this.params.addOpt("show_description_in_quotes", showDescriptionInQuotes);
            return this;
        }

        public UpdateRequest taxDetailTaxProfileId(String taxDetailTaxProfileId) {
            this.params.addOpt("tax_detail[tax_profile_id]", taxDetailTaxProfileId);
            return this;
        }

        public UpdateRequest taxDetailAvalaraTaxCode(String taxDetailAvalaraTaxCode) {
            this.params.addOpt("tax_detail[avalara_tax_code]", taxDetailAvalaraTaxCode);
            return this;
        }

        public UpdateRequest taxDetailHsnCode(String taxDetailHsnCode) {
            this.params.addOpt("tax_detail[hsn_code]", taxDetailHsnCode);
            return this;
        }

        public UpdateRequest taxDetailAvalaraSaleType(AvalaraSaleType taxDetailAvalaraSaleType) {
            this.params.addOpt("tax_detail[avalara_sale_type]", (Object)taxDetailAvalaraSaleType);
            return this;
        }

        public UpdateRequest taxDetailAvalaraTransactionType(Integer taxDetailAvalaraTransactionType) {
            this.params.addOpt("tax_detail[avalara_transaction_type]", taxDetailAvalaraTransactionType);
            return this;
        }

        public UpdateRequest taxDetailAvalaraServiceType(Integer taxDetailAvalaraServiceType) {
            this.params.addOpt("tax_detail[avalara_service_type]", taxDetailAvalaraServiceType);
            return this;
        }

        public UpdateRequest taxDetailTaxjarProductCode(String taxDetailTaxjarProductCode) {
            this.params.addOpt("tax_detail[taxjar_product_code]", taxDetailTaxjarProductCode);
            return this;
        }

        public UpdateRequest accountingDetailSku(String accountingDetailSku) {
            this.params.addOpt("accounting_detail[sku]", accountingDetailSku);
            return this;
        }

        public UpdateRequest accountingDetailAccountingCode(String accountingDetailAccountingCode) {
            this.params.addOpt("accounting_detail[accounting_code]", accountingDetailAccountingCode);
            return this;
        }

        public UpdateRequest accountingDetailAccountingCategory1(String accountingDetailAccountingCategory1) {
            this.params.addOpt("accounting_detail[accounting_category1]", accountingDetailAccountingCategory1);
            return this;
        }

        public UpdateRequest accountingDetailAccountingCategory2(String accountingDetailAccountingCategory2) {
            this.params.addOpt("accounting_detail[accounting_category2]", accountingDetailAccountingCategory2);
            return this;
        }

        public UpdateRequest accountingDetailAccountingCategory3(String accountingDetailAccountingCategory3) {
            this.params.addOpt("accounting_detail[accounting_category3]", accountingDetailAccountingCategory3);
            return this;
        }

        public UpdateRequest accountingDetailAccountingCategory4(String accountingDetailAccountingCategory4) {
            this.params.addOpt("accounting_detail[accounting_category4]", accountingDetailAccountingCategory4);
            return this;
        }

        public UpdateRequest tierStartingUnit(int index, Integer tierStartingUnit) {
            this.params.addOpt("tiers[starting_unit][" + index + "]", tierStartingUnit);
            return this;
        }

        public UpdateRequest tierEndingUnit(int index, Integer tierEndingUnit) {
            this.params.addOpt("tiers[ending_unit][" + index + "]", tierEndingUnit);
            return this;
        }

        public UpdateRequest tierPrice(int index, Long tierPrice) {
            this.params.addOpt("tiers[price][" + index + "]", tierPrice);
            return this;
        }

        public UpdateRequest tierStartingUnitInDecimal(int index, String tierStartingUnitInDecimal) {
            this.params.addOpt("tiers[starting_unit_in_decimal][" + index + "]", tierStartingUnitInDecimal);
            return this;
        }

        public UpdateRequest tierEndingUnitInDecimal(int index, String tierEndingUnitInDecimal) {
            this.params.addOpt("tiers[ending_unit_in_decimal][" + index + "]", tierEndingUnitInDecimal);
            return this;
        }

        public UpdateRequest tierPriceInDecimal(int index, String tierPriceInDecimal) {
            this.params.addOpt("tiers[price_in_decimal][" + index + "]", tierPriceInDecimal);
            return this;
        }

        public UpdateRequest taxProvidersFieldProviderName(int index, String taxProvidersFieldProviderName) {
            this.params.add("tax_providers_fields[provider_name][" + index + "]", taxProvidersFieldProviderName);
            return this;
        }

        public UpdateRequest taxProvidersFieldFieldId(int index, String taxProvidersFieldFieldId) {
            this.params.add("tax_providers_fields[field_id][" + index + "]", taxProvidersFieldFieldId);
            return this;
        }

        public UpdateRequest taxProvidersFieldFieldValue(int index, String taxProvidersFieldFieldValue) {
            this.params.add("tax_providers_fields[field_value][" + index + "]", taxProvidersFieldFieldValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public CreateRequest itemId(String itemId) {
            this.params.add("item_id", itemId);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest prorationType(ProrationType prorationType) {
            this.params.addOpt("proration_type", (Object)prorationType);
            return this;
        }

        public CreateRequest externalName(String externalName) {
            this.params.addOpt("external_name", externalName);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateRequest priceVariantId(String priceVariantId) {
            this.params.addOpt("price_variant_id", priceVariantId);
            return this;
        }

        public CreateRequest isTaxable(Boolean isTaxable) {
            this.params.addOpt("is_taxable", isTaxable);
            return this;
        }

        public CreateRequest freeQuantity(Integer freeQuantity) {
            this.params.addOpt("free_quantity", freeQuantity);
            return this;
        }

        public CreateRequest freeQuantityInDecimal(String freeQuantityInDecimal) {
            this.params.addOpt("free_quantity_in_decimal", freeQuantityInDecimal);
            return this;
        }

        public CreateRequest metadata(JSONObject metadata) {
            this.params.addOpt("metadata", metadata);
            return this;
        }

        public CreateRequest showDescriptionInInvoices(Boolean showDescriptionInInvoices) {
            this.params.addOpt("show_description_in_invoices", showDescriptionInInvoices);
            return this;
        }

        public CreateRequest showDescriptionInQuotes(Boolean showDescriptionInQuotes) {
            this.params.addOpt("show_description_in_quotes", showDescriptionInQuotes);
            return this;
        }

        public CreateRequest pricingModel(PricingModel pricingModel) {
            this.params.addOpt("pricing_model", (Object)pricingModel);
            return this;
        }

        public CreateRequest price(Long price) {
            this.params.addOpt("price", price);
            return this;
        }

        public CreateRequest priceInDecimal(String priceInDecimal) {
            this.params.addOpt("price_in_decimal", priceInDecimal);
            return this;
        }

        public CreateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public CreateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public CreateRequest trialPeriodUnit(TrialPeriodUnit trialPeriodUnit) {
            this.params.addOpt("trial_period_unit", (Object)trialPeriodUnit);
            return this;
        }

        public CreateRequest trialPeriod(Integer trialPeriod) {
            this.params.addOpt("trial_period", trialPeriod);
            return this;
        }

        public CreateRequest shippingPeriod(Integer shippingPeriod) {
            this.params.addOpt("shipping_period", shippingPeriod);
            return this;
        }

        public CreateRequest shippingPeriodUnit(ShippingPeriodUnit shippingPeriodUnit) {
            this.params.addOpt("shipping_period_unit", (Object)shippingPeriodUnit);
            return this;
        }

        public CreateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateRequest trialEndAction(TrialEndAction trialEndAction) {
            this.params.addOpt("trial_end_action", (Object)trialEndAction);
            return this;
        }

        public CreateRequest taxDetailTaxProfileId(String taxDetailTaxProfileId) {
            this.params.addOpt("tax_detail[tax_profile_id]", taxDetailTaxProfileId);
            return this;
        }

        public CreateRequest taxDetailAvalaraTaxCode(String taxDetailAvalaraTaxCode) {
            this.params.addOpt("tax_detail[avalara_tax_code]", taxDetailAvalaraTaxCode);
            return this;
        }

        public CreateRequest taxDetailHsnCode(String taxDetailHsnCode) {
            this.params.addOpt("tax_detail[hsn_code]", taxDetailHsnCode);
            return this;
        }

        public CreateRequest taxDetailAvalaraSaleType(AvalaraSaleType taxDetailAvalaraSaleType) {
            this.params.addOpt("tax_detail[avalara_sale_type]", (Object)taxDetailAvalaraSaleType);
            return this;
        }

        public CreateRequest taxDetailAvalaraTransactionType(Integer taxDetailAvalaraTransactionType) {
            this.params.addOpt("tax_detail[avalara_transaction_type]", taxDetailAvalaraTransactionType);
            return this;
        }

        public CreateRequest taxDetailAvalaraServiceType(Integer taxDetailAvalaraServiceType) {
            this.params.addOpt("tax_detail[avalara_service_type]", taxDetailAvalaraServiceType);
            return this;
        }

        public CreateRequest taxDetailTaxjarProductCode(String taxDetailTaxjarProductCode) {
            this.params.addOpt("tax_detail[taxjar_product_code]", taxDetailTaxjarProductCode);
            return this;
        }

        public CreateRequest accountingDetailSku(String accountingDetailSku) {
            this.params.addOpt("accounting_detail[sku]", accountingDetailSku);
            return this;
        }

        public CreateRequest accountingDetailAccountingCode(String accountingDetailAccountingCode) {
            this.params.addOpt("accounting_detail[accounting_code]", accountingDetailAccountingCode);
            return this;
        }

        public CreateRequest accountingDetailAccountingCategory1(String accountingDetailAccountingCategory1) {
            this.params.addOpt("accounting_detail[accounting_category1]", accountingDetailAccountingCategory1);
            return this;
        }

        public CreateRequest accountingDetailAccountingCategory2(String accountingDetailAccountingCategory2) {
            this.params.addOpt("accounting_detail[accounting_category2]", accountingDetailAccountingCategory2);
            return this;
        }

        public CreateRequest accountingDetailAccountingCategory3(String accountingDetailAccountingCategory3) {
            this.params.addOpt("accounting_detail[accounting_category3]", accountingDetailAccountingCategory3);
            return this;
        }

        public CreateRequest accountingDetailAccountingCategory4(String accountingDetailAccountingCategory4) {
            this.params.addOpt("accounting_detail[accounting_category4]", accountingDetailAccountingCategory4);
            return this;
        }

        public CreateRequest tierStartingUnit(int index, Integer tierStartingUnit) {
            this.params.addOpt("tiers[starting_unit][" + index + "]", tierStartingUnit);
            return this;
        }

        public CreateRequest tierEndingUnit(int index, Integer tierEndingUnit) {
            this.params.addOpt("tiers[ending_unit][" + index + "]", tierEndingUnit);
            return this;
        }

        public CreateRequest tierPrice(int index, Long tierPrice) {
            this.params.addOpt("tiers[price][" + index + "]", tierPrice);
            return this;
        }

        public CreateRequest tierStartingUnitInDecimal(int index, String tierStartingUnitInDecimal) {
            this.params.addOpt("tiers[starting_unit_in_decimal][" + index + "]", tierStartingUnitInDecimal);
            return this;
        }

        public CreateRequest tierEndingUnitInDecimal(int index, String tierEndingUnitInDecimal) {
            this.params.addOpt("tiers[ending_unit_in_decimal][" + index + "]", tierEndingUnitInDecimal);
            return this;
        }

        public CreateRequest tierPriceInDecimal(int index, String tierPriceInDecimal) {
            this.params.addOpt("tiers[price_in_decimal][" + index + "]", tierPriceInDecimal);
            return this;
        }

        public CreateRequest taxProvidersFieldProviderName(int index, String taxProvidersFieldProviderName) {
            this.params.add("tax_providers_fields[provider_name][" + index + "]", taxProvidersFieldProviderName);
            return this;
        }

        public CreateRequest taxProvidersFieldFieldId(int index, String taxProvidersFieldFieldId) {
            this.params.add("tax_providers_fields[field_id][" + index + "]", taxProvidersFieldFieldId);
            return this;
        }

        public CreateRequest taxProvidersFieldFieldValue(int index, String taxProvidersFieldFieldValue) {
            this.params.add("tax_providers_fields[field_value][" + index + "]", taxProvidersFieldFieldValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AccountingDetail
    extends Resource<AccountingDetail> {
        public AccountingDetail(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String sku() {
            return this.optString("sku");
        }

        public String accountingCode() {
            return this.optString("accounting_code");
        }

        public String accountingCategory1() {
            return this.optString("accounting_category1");
        }

        public String accountingCategory2() {
            return this.optString("accounting_category2");
        }

        public String accountingCategory3() {
            return this.optString("accounting_category3");
        }

        public String accountingCategory4() {
            return this.optString("accounting_category4");
        }
    }

    public static class TaxProvidersField
    extends Resource<TaxProvidersField> {
        public TaxProvidersField(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String providerName() {
            return this.reqString("provider_name");
        }

        public String fieldId() {
            return this.reqString("field_id");
        }

        public String fieldValue() {
            return this.reqString("field_value");
        }
    }

    public static class TaxDetail
    extends Resource<TaxDetail> {
        public TaxDetail(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String taxProfileId() {
            return this.optString("tax_profile_id");
        }

        public AvalaraSaleType avalaraSaleType() {
            return this.optEnum("avalara_sale_type", AvalaraSaleType.class);
        }

        public Integer avalaraTransactionType() {
            return this.optInteger("avalara_transaction_type");
        }

        public Integer avalaraServiceType() {
            return this.optInteger("avalara_service_type");
        }

        public String avalaraTaxCode() {
            return this.optString("avalara_tax_code");
        }

        public String hsnCode() {
            return this.optString("hsn_code");
        }

        public String taxjarProductCode() {
            return this.optString("taxjar_product_code");
        }
    }

    public static class Tier
    extends Resource<Tier> {
        public Tier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Long price() {
            return this.reqLong("price");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String priceInDecimal() {
            return this.optString("price_in_decimal");
        }
    }

    public static enum ShippingPeriodUnit {
        DAY,
        WEEK,
        MONTH,
        YEAR,
        _UNKNOWN;

    }

    public static enum TrialEndAction {
        SITE_DEFAULT,
        ACTIVATE_SUBSCRIPTION,
        CANCEL_SUBSCRIPTION,
        _UNKNOWN;

    }

    public static enum TrialPeriodUnit {
        DAY,
        MONTH,
        _UNKNOWN;

    }

    public static enum PeriodUnit {
        DAY,
        WEEK,
        MONTH,
        YEAR,
        _UNKNOWN;

    }

    public static enum ProrationType {
        SITE_DEFAULT,
        PARTIAL_TERM,
        FULL_TERM,
        _UNKNOWN;

    }

    public static enum Status {
        ACTIVE,
        ARCHIVED,
        DELETED,
        _UNKNOWN;

    }
}

