/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.PaymentVoucherType;
import com.chargebee.models.enums.VoucherType;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class PaymentVoucher
extends Resource<PaymentVoucher> {
    public PaymentVoucher(String jsonStr) {
        super(jsonStr);
    }

    public PaymentVoucher(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String idAtGateway() {
        return this.optString("id_at_gateway");
    }

    public PaymentVoucherType paymentVoucherType() {
        return this.reqEnum("payment_voucher_type", PaymentVoucherType.class);
    }

    public Timestamp expiresAt() {
        return this.optTimestamp("expires_at");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Long amount() {
        return this.optLong("amount");
    }

    public String gatewayAccountId() {
        return this.optString("gateway_account_id");
    }

    public String paymentSourceId() {
        return this.optString("payment_source_id");
    }

    public Gateway gateway() {
        return this.reqEnum("gateway", Gateway.class);
    }

    public String payload() {
        return this.optString("payload");
    }

    public String errorCode() {
        return this.optString("error_code");
    }

    public String errorText() {
        return this.optString("error_text");
    }

    public String url() {
        return this.optString("url");
    }

    public Timestamp date() {
        return this.optTimestamp("date");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public List<LinkedInvoice> linkedInvoices() {
        return this.optList("linked_invoices", LinkedInvoice.class);
    }

    public static CreateRequest create() {
        String uri = PaymentVoucher.uri("payment_vouchers");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = PaymentVoucher.uri("payment_vouchers", PaymentVoucher.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    @Deprecated
    public static PaymentVoucherPaymentVouchersForInvoiceRequest payment_vouchersForInvoice(String id) {
        String uri = PaymentVoucher.uri("invoices", PaymentVoucher.nullCheck(id), "payment_vouchers");
        return new PaymentVoucherPaymentVouchersForInvoiceRequest(uri);
    }

    public static PaymentVoucherPaymentVouchersForInvoiceRequest paymentVouchersForInvoice(String id) {
        String uri = PaymentVoucher.uri("invoices", PaymentVoucher.nullCheck(id), "payment_vouchers");
        return new PaymentVoucherPaymentVouchersForInvoiceRequest(uri);
    }

    @Deprecated
    public static PaymentVoucherPaymentVouchersForCustomerRequest payment_vouchersForCustomer(String id) {
        String uri = PaymentVoucher.uri("customers", PaymentVoucher.nullCheck(id), "payment_vouchers");
        return new PaymentVoucherPaymentVouchersForCustomerRequest(uri);
    }

    public static PaymentVoucherPaymentVouchersForCustomerRequest paymentVouchersForCustomer(String id) {
        String uri = PaymentVoucher.uri("customers", PaymentVoucher.nullCheck(id), "payment_vouchers");
        return new PaymentVoucherPaymentVouchersForCustomerRequest(uri);
    }

    public static class PaymentVoucherPaymentVouchersForCustomerRequest
    extends ListRequest<PaymentVoucherPaymentVouchersForCustomerRequest> {
        private PaymentVoucherPaymentVouchersForCustomerRequest(String uri) {
            super(uri);
        }

        public EnumFilter<Status, PaymentVoucherPaymentVouchersForCustomerRequest> status() {
            return new EnumFilter<Status, PaymentVoucherPaymentVouchersForCustomerRequest>("status", this);
        }

        public PaymentVoucherPaymentVouchersForCustomerRequest sortByDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "date");
            return this;
        }

        public PaymentVoucherPaymentVouchersForCustomerRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class PaymentVoucherPaymentVouchersForInvoiceRequest
    extends ListRequest<PaymentVoucherPaymentVouchersForInvoiceRequest> {
        private PaymentVoucherPaymentVouchersForInvoiceRequest(String uri) {
            super(uri);
        }

        public EnumFilter<Status, PaymentVoucherPaymentVouchersForInvoiceRequest> status() {
            return new EnumFilter<Status, PaymentVoucherPaymentVouchersForInvoiceRequest>("status", this);
        }

        public PaymentVoucherPaymentVouchersForInvoiceRequest sortByDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "date");
            return this;
        }

        public PaymentVoucherPaymentVouchersForInvoiceRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CreateRequest voucherPaymentSourceVoucherType(VoucherType voucherPaymentSourceVoucherType) {
            this.params.add("voucher_payment_source[voucher_type]", (Object)voucherPaymentSourceVoucherType);
            return this;
        }

        public CreateRequest invoiceAllocationInvoiceId(int index, String invoiceAllocationInvoiceId) {
            this.params.add("invoice_allocations[invoice_id][" + index + "]", invoiceAllocationInvoiceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class LinkedInvoice
    extends Resource<LinkedInvoice> {
        public LinkedInvoice(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String invoiceId() {
            return this.reqString("invoice_id");
        }

        public String txnId() {
            return this.reqString("txn_id");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }
    }

    public static enum Status {
        ACTIVE,
        CONSUMED,
        EXPIRED,
        FAILURE,
        _UNKNOWN;

    }
}

