/*
 * Decompiled with CFR 0.152.
 */
package com.charleskorn.kaml;

import com.charleskorn.kaml.YamlNode;
import com.charleskorn.kaml.YamlPath;
import com.charleskorn.kaml.YamlScalar;
import com.charleskorn.kaml.YamlScalarFormatException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J5\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\rJ\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020\u0003H\u0016J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010+\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006."}, d2={"Lcom/charleskorn/kaml/YamlScalar;", "Lcom/charleskorn/kaml/YamlNode;", "content", "", "path", "Lcom/charleskorn/kaml/YamlPath;", "<init>", "(Ljava/lang/String;Lcom/charleskorn/kaml/YamlPath;)V", "getContent", "()Ljava/lang/String;", "getPath", "()Lcom/charleskorn/kaml/YamlPath;", "equivalentContentTo", "", "other", "contentToString", "toByte", "", "toShort", "", "toInt", "", "toLong", "", "convertToIntegerLikeValue", "T", "converter", "Lkotlin/Function2;", "description", "(Lkotlin/jvm/functions/Function2;Ljava/lang/String;)Ljava/lang/Object;", "toFloat", "", "toDouble", "", "toBoolean", "toChar", "", "withPath", "newPath", "toString", "component1", "component2", "copy", "equals", "", "hashCode", "kaml"})
public final class YamlScalar
extends YamlNode {
    @NotNull
    private final String content;
    @NotNull
    private final YamlPath path;

    public YamlScalar(@NotNull String content, @NotNull YamlPath path) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(path, null);
        this.content = content;
        this.path = path;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public YamlPath getPath() {
        return this.path;
    }

    @Override
    public boolean equivalentContentTo(@NotNull YamlNode other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof YamlScalar && Intrinsics.areEqual((Object)this.content, (Object)((YamlScalar)other).content);
    }

    @Override
    @NotNull
    public String contentToString() {
        return '\'' + this.content + '\'';
    }

    public final byte toByte() {
        return ((Number)this.convertToIntegerLikeValue(toByte.1.INSTANCE, "byte")).byteValue();
    }

    public final short toShort() {
        return ((Number)this.convertToIntegerLikeValue(toShort.1.INSTANCE, "short")).shortValue();
    }

    public final int toInt() {
        return ((Number)this.convertToIntegerLikeValue(toInt.1.INSTANCE, "integer")).intValue();
    }

    public final long toLong() {
        return ((Number)this.convertToIntegerLikeValue(toLong.1.INSTANCE, "long")).longValue();
    }

    private final <T> T convertToIntegerLikeValue(Function2<? super String, ? super Integer, ? extends T> converter, String description) {
        try {
            Object object;
            if (StringsKt.startsWith$default((String)this.content, (String)"0x", (boolean)false, (int)2, null)) {
                String string = this.content.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = converter.invoke((Object)string, (Object)16);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"-0x", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append('-');
                String string = this.content.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = converter.invoke((Object)stringBuilder.append(string).toString(), (Object)16);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"0o", (boolean)false, (int)2, null)) {
                String string = this.content.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = converter.invoke((Object)string, (Object)8);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"-0o", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append('-');
                String string = this.content.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = converter.invoke((Object)stringBuilder.append(string).toString(), (Object)8);
            } else {
                object = converter.invoke((Object)this.content, (Object)10);
            }
            return (T)object;
        }
        catch (NumberFormatException e) {
            throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid " + description + " value.", this.getPath(), this.content);
        }
    }

    public final float toFloat() {
        float f;
        switch (this.content) {
            case ".inf": 
            case ".Inf": 
            case ".INF": {
                f = Float.POSITIVE_INFINITY;
                break;
            }
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": {
                f = Float.NEGATIVE_INFINITY;
                break;
            }
            case ".nan": 
            case ".NaN": 
            case ".NAN": {
                f = Float.NaN;
                break;
            }
            default: {
                float f2;
                try {
                    f2 = Float.parseFloat(this.content);
                }
                catch (NumberFormatException e) {
                    throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", this.getPath(), this.content);
                }
                f = f2;
            }
        }
        return f;
    }

    public final double toDouble() {
        double d;
        switch (this.content) {
            case ".inf": 
            case ".Inf": 
            case ".INF": {
                d = Double.POSITIVE_INFINITY;
                break;
            }
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": {
                d = Double.NEGATIVE_INFINITY;
                break;
            }
            case ".nan": 
            case ".NaN": 
            case ".NAN": {
                d = Double.NaN;
                break;
            }
            default: {
                double d2;
                try {
                    d2 = Double.parseDouble(this.content);
                }
                catch (NumberFormatException e) {
                    throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", this.getPath(), this.content);
                }
                d = d2;
            }
        }
        return d;
    }

    public final boolean toBoolean() {
        boolean bl;
        switch (this.content) {
            case "true": 
            case "True": 
            case "TRUE": {
                bl = true;
                break;
            }
            case "false": 
            case "FALSE": 
            case "False": {
                bl = false;
                break;
            }
            default: {
                throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid boolean, permitted choices are: true or false", this.getPath(), this.content);
            }
        }
        return bl;
    }

    public final char toChar() {
        Character c = StringsKt.singleOrNull((CharSequence)this.content);
        if (c == null) {
            throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid character value.", this.getPath(), this.content);
        }
        return c.charValue();
    }

    @Override
    @NotNull
    public YamlScalar withPath(@NotNull YamlPath newPath) {
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        return YamlScalar.copy$default(this, null, newPath, 1, null);
    }

    @NotNull
    public String toString() {
        return "scalar @ " + this.getPath() + " : " + this.content;
    }

    @NotNull
    public final String component1() {
        return this.content;
    }

    @NotNull
    public final YamlPath component2() {
        return this.path;
    }

    @NotNull
    public final YamlScalar copy(@NotNull String content, @NotNull YamlPath path) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new YamlScalar(content, path);
    }

    public static /* synthetic */ YamlScalar copy$default(YamlScalar yamlScalar, String string, YamlPath yamlPath, int n, Object object) {
        if ((n & 1) != 0) {
            string = yamlScalar.content;
        }
        if ((n & 2) != 0) {
            yamlPath = yamlScalar.path;
        }
        return yamlScalar.copy(string, yamlPath);
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = result * 31 + this.path.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof YamlScalar)) {
            return false;
        }
        YamlScalar yamlScalar = (YamlScalar)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)yamlScalar.content)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)yamlScalar.path);
    }
}

