/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common;

import com.chavaillaz.client.common.Client;
import com.chavaillaz.client.common.security.AnonymousAuthentication;
import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.common.security.PasswordAuthentication;
import com.chavaillaz.client.common.security.TokenAuthentication;
import com.chavaillaz.client.common.utility.ProxyConfiguration;

public abstract class AbstractClient<C, I>
implements Client<I> {
    protected final String baseUrl;
    protected Authentication authentication;
    protected ProxyConfiguration proxy;

    protected AbstractClient(String baseUrl) {
        this.baseUrl = baseUrl;
        this.withAnonymousAuthentication();
    }

    protected abstract C newHttpClient();

    @Override
    public I withProxy(String host, Integer port) {
        this.proxy = ProxyConfiguration.from(host, port);
        return (I)this;
    }

    @Override
    public I withProxy(String url) {
        this.proxy = ProxyConfiguration.from(url);
        return (I)this;
    }

    @Override
    public I withAnonymousAuthentication() {
        this.authentication = new AnonymousAuthentication();
        return (I)this;
    }

    @Override
    public I withTokenAuthentication(String token) {
        this.authentication = new TokenAuthentication(token);
        return (I)this;
    }

    @Override
    public I withUserAuthentication(String username, String password) {
        this.authentication = new PasswordAuthentication(username, password);
        return (I)this;
    }
}

