/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common;

import com.chavaillaz.client.common.exception.DeserializationException;
import com.chavaillaz.client.common.exception.ResponseException;
import com.chavaillaz.client.common.exception.SerializationException;
import com.chavaillaz.client.common.security.Authentication;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClient.class);
    public static final String HEADER_COOKIE = "Cookie";
    public static final String HEADER_SET_COOKIE = "Set-Cookie";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_JSON = "application/json";
    public static final String HEADER_CONTENT_XML = "application/xml";
    public static final String HEADER_CONTENT_FORM = "application/x-www-form-urlencoded";
    protected final Authentication authentication;
    protected final String baseUrl;
    protected ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).serializationInclusion(JsonInclude.Include.NON_NULL)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build();

    protected AbstractHttpClient(String baseUrl, Authentication authentication) {
        this.baseUrl = baseUrl;
        this.authentication = authentication;
    }

    protected URI url(String url, Object ... parameters) {
        return URI.create((url.startsWith("http") ? "" : this.baseUrl) + MessageFormat.format(url, parameters));
    }

    public <C extends Collection<O>, O> Collection<O> deserializeCollection(String content, Class<C> collectionType, Class<O> objectType) {
        try {
            return (Collection)this.objectMapper.readValue(content, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(collectionType, objectType));
        }
        catch (Exception e) {
            throw new DeserializationException(content, objectType, (Throwable)e);
        }
    }

    public <M extends Map<K, V>, K, V> Map<K, V> deserializeMap(String content, Class<M> mapClass, Class<K> keyType, Class<V> valueType) {
        try {
            return (Map)this.objectMapper.readValue(content, (JavaType)this.objectMapper.getTypeFactory().constructMapType(mapClass, keyType, valueType));
        }
        catch (Exception e) {
            throw new DeserializationException(content, valueType, (Throwable)e);
        }
    }

    public <T> T deserialize(String content, Class<T> type) {
        return this.deserialize(content, this.objectMapper.constructType(type));
    }

    public <T> T deserialize(String content, JavaType type) {
        if (type.getRawClass() == Void.class || StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            log.trace("Response to deserialize: {}", (Object)content);
            return (T)this.objectMapper.readValue(content, type);
        }
        catch (Exception e) {
            throw new DeserializationException(content, type, (Throwable)e);
        }
    }

    public String serialize(Object content) {
        try {
            String json = this.objectMapper.writeValueAsString(content);
            log.trace("Request serialized: {}", (Object)json);
            return json;
        }
        catch (Exception e) {
            throw new SerializationException(content, (Throwable)e);
        }
    }

    public ResponseException responseException(int code, String body) {
        return new ResponseException(code, body);
    }

    public ResponseException responseException(String method, String url, int code, String body) {
        return new ResponseException(method, url, code, body);
    }

    @Generated
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

