/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.apache;

import com.chavaillaz.client.common.AbstractHttpClient;
import com.chavaillaz.client.common.apache.CompletableFutureCallback;
import com.chavaillaz.client.common.security.Authentication;
import com.fasterxml.jackson.databind.JavaType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.protocol.HttpContext;

public abstract class AbstractApacheHttpClient
extends AbstractHttpClient
implements AutoCloseable {
    protected final CloseableHttpAsyncClient client;

    protected AbstractApacheHttpClient(CloseableHttpAsyncClient client, String baseUrl, Authentication authentication) {
        super(baseUrl, authentication);
        this.client = client;
        this.client.start();
    }

    protected SimpleRequestBuilder requestBuilder(SimpleRequestBuilder builder, String url, Object ... parameters) {
        builder.setUri(this.url(url, parameters)).setHeader("Content-Type", "application/json");
        this.getAuthentication().fillHeaders((arg_0, arg_1) -> ((SimpleRequestBuilder)builder).setHeader(arg_0, arg_1));
        return builder;
    }

    protected <T> CompletableFuture<T> sendAsync(SimpleRequestBuilder requestBuilder, Class<T> returnType) {
        return this.sendAsync(requestBuilder, this.objectMapper.constructType(returnType));
    }

    protected <T> CompletableFuture<T> sendAsync(SimpleRequestBuilder requestBuilder, JavaType returnType) {
        return ((CompletableFuture)this.sendAsyncBase(requestBuilder).thenApply(SimpleHttpResponse::getBodyText)).thenApply(body -> this.deserialize((String)body, returnType));
    }

    protected CompletableFuture<InputStream> sendAsync(SimpleRequestBuilder requestBuilder) {
        return ((CompletableFuture)this.sendAsyncBase(requestBuilder).thenApply(SimpleHttpResponse::getBodyBytes)).thenApply(ByteArrayInputStream::new);
    }

    protected CompletableFuture<SimpleHttpResponse> sendAsyncBase(SimpleRequestBuilder requestBuilder) {
        SimpleHttpRequest request = requestBuilder.build();
        CompletableFuture<SimpleHttpResponse> completableFuture = new CompletableFuture<SimpleHttpResponse>();
        this.client.execute(request, this.createContext(), (FutureCallback)new CompletableFutureCallback(this, request, completableFuture));
        return completableFuture;
    }

    protected <T> CompletableFuture<T> sendAsync(SimpleRequestBuilder requestBuilder, MultipartEntityBuilder multipartBuilder, Class<T> returnType) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String boundary = RandomStringUtils.randomAlphanumeric((int)16);
        multipartBuilder.setBoundary(boundary);
        try (HttpEntity entity = multipartBuilder.build();){
            entity.writeTo((OutputStream)outputStream);
        }
        requestBuilder.setHeader("Content-Type", ContentType.MULTIPART_FORM_DATA.getMimeType() + "; boundary=" + boundary).setBody(outputStream.toByteArray(), ContentType.MULTIPART_FORM_DATA);
        return this.sendAsync(requestBuilder, returnType);
    }

    protected HttpContext createContext() {
        HttpClientContext localContext = HttpClientContext.create();
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.getAuthentication().fillCookies((key, value) -> this.addCookie((CookieStore)cookieStore, (String)key, (String)value));
        localContext.setAttribute("http.cookie-store", (Object)cookieStore);
        return localContext;
    }

    protected void addCookie(CookieStore store, String key, String value) {
        BasicClientCookie cookie = new BasicClientCookie(key, value);
        cookie.setDomain(this.getBaseUrl());
        cookie.setPath("/");
        store.addCookie((Cookie)cookie);
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

