/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.apache;

import com.chavaillaz.client.common.utility.ProxyConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;

public final class ApacheHttpUtils {
    public static HttpAsyncClientBuilder defaultHttpClientBuilder(ProxyConfiguration proxy) {
        return HttpAsyncClientBuilder.create().useSystemProperties().setDefaultCookieStore((CookieStore)new BasicCookieStore()).setProxy((HttpHost)Optional.ofNullable(proxy).map(config -> new HttpHost(config.getScheme(), config.getHost(), config.getPort().intValue())).orElse(null)).setConnectionManager((AsyncClientConnectionManager)PoolingAsyncClientConnectionManagerBuilder.create().setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)30L)).setSocketTimeout(null).build()).build()).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(null).build());
    }

    public static MultipartEntityBuilder multipartWithFiles(File ... files) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setContentType(ContentType.DEFAULT_BINARY).setStrictMode();
        Stream.of(files).map(FileBody::new).forEach(body -> builder.addPart("file", (ContentBody)body));
        return builder;
    }

    public static NameValuePair[] formData(Map<Object, Object> data) {
        ArrayList parameters = new ArrayList();
        data.forEach((key, value) -> parameters.add(new BasicNameValuePair(key.toString(), value.toString())));
        return parameters.toArray(new NameValuePair[0]);
    }

    @Generated
    private ApacheHttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

