/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.apache;

import com.chavaillaz.client.common.AbstractHttpClient;
import com.chavaillaz.client.common.exception.RequestException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableFutureCallback
implements FutureCallback<SimpleHttpResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompletableFutureCallback.class);
    private final AbstractHttpClient client;
    private final SimpleHttpRequest request;
    private final CompletableFuture<SimpleHttpResponse> future;

    public void completed(SimpleHttpResponse response) {
        log.debug("Request {} completed: {}", (Object)this.request, (Object)response);
        if (response.getCode() >= 400) {
            this.future.completeExceptionally(this.client.responseException(this.request.getMethod(), this.request.getRequestUri(), response.getCode(), response.getBodyText()));
        } else {
            this.future.complete(response);
        }
    }

    public void failed(Exception exception) {
        log.debug("Request {} failed: {}", (Object)this.request, (Object)exception.getMessage());
        this.future.completeExceptionally(new RequestException(this.request.getMethod(), this.request.getRequestUri(), exception));
    }

    public void cancelled() {
        log.debug("Request {} cancelled", (Object)this.request);
        this.future.cancel(false);
    }

    @Generated
    public CompletableFutureCallback(AbstractHttpClient client, SimpleHttpRequest request, CompletableFuture<SimpleHttpResponse> future) {
        this.client = client;
        this.request = request;
        this.future = future;
    }
}

