/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.exception;

import com.chavaillaz.client.common.exception.ClientException;
import lombok.Generated;

public class ResponseException
extends ClientException {
    private final Integer statusCode;
    private final String body;

    public ResponseException(int statusCode, String body) {
        this(statusCode, body, ResponseException.errorMessage(statusCode, body));
    }

    public ResponseException(String method, String url, int statusCode, String body) {
        this(statusCode, body, ResponseException.errorMessage(statusCode, body) + " for " + method + " " + url);
    }

    public ResponseException(int statusCode, String body, String errorMessage) {
        super(errorMessage);
        this.statusCode = statusCode;
        this.body = body;
    }

    private static String errorMessage(Integer statusCode, String content) {
        return "Service responded with " + statusCode + ": " + content;
    }

    @Generated
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public String getBody() {
        return this.body;
    }
}

