/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.java;

import com.chavaillaz.client.common.AbstractHttpClient;
import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.common.utility.Utils;
import com.fasterxml.jackson.databind.JavaType;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractJavaHttpClient
extends AbstractHttpClient
implements AutoCloseable {
    protected final HttpClient client;

    protected AbstractJavaHttpClient(HttpClient client, String baseUrl, Authentication authentication) {
        super(baseUrl, authentication);
        this.client = client;
    }

    protected HttpRequest.Builder requestBuilder(String url, Object ... parameters) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.url(url, parameters)).header("Content-Type", "application/json");
        this.getAuthentication().fillHeaders(builder::setHeader);
        Utils.getCookieHeader(this.getAuthentication()).ifPresent(value -> builder.setHeader("Cookie", (String)value));
        return builder;
    }

    protected HttpRequest.BodyPublisher body(Object object) {
        return HttpRequest.BodyPublishers.ofString(this.serialize(object));
    }

    protected <T> HttpResponse<T> checkResponse(HttpResponse<T> response) {
        if (response.statusCode() >= 400) {
            throw this.responseException(response.request().method(), response.request().uri().toString(), response.statusCode(), Objects.toString(response.body(), null));
        }
        return response;
    }

    protected <T> CompletableFuture<T> sendAsync(HttpRequest.Builder requestBuilder, Class<T> returnType) {
        return this.sendAsync(requestBuilder, this.objectMapper.constructType(returnType));
    }

    protected <T> CompletableFuture<T> sendAsync(HttpRequest.Builder requestBuilder, JavaType returnType) {
        return ((CompletableFuture)this.client.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenApply(this::checkResponse)).thenApply(response -> this.deserialize((String)response.body(), returnType));
    }

    protected CompletableFuture<InputStream> sendAsync(HttpRequest.Builder requestBuilder) {
        return ((CompletableFuture)this.client.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream()).thenApply(this::checkResponse)).thenApply(HttpResponse::body);
    }

    @Override
    public void close() {
    }
}

