/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.java;

import com.chavaillaz.client.common.utility.ProxyConfiguration;
import com.chavaillaz.client.common.utility.Utils;
import java.io.File;
import java.io.IOException;
import java.net.CookieManager;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class JavaHttpUtils {
    public static HttpClient.Builder defaultHttpClientBuilder(ProxyConfiguration proxy) {
        return HttpClient.newBuilder().cookieHandler(new CookieManager()).proxy(Optional.ofNullable(proxy).map(config -> ProxySelector.of(new InetSocketAddress(config.getHost(), (int)config.getPort()))).orElse(ProxySelector.getDefault())).connectTimeout(Duration.ofSeconds(30L));
    }

    public static HttpRequest.BodyPublisher formData(Map<Object, Object> data) {
        return HttpRequest.BodyPublishers.ofString(Utils.encodeQuery(data));
    }

    public static HttpRequest.BodyPublisher mimeMultipartData(Map<Object, Object> data, String boundary, Charset charset) throws IOException {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        byte[] separator = ("--" + boundary + "\r\nContent-Disposition: form-data; name=").getBytes(charset);
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            byteArrays.add(separator);
            Object object = entry.getValue();
            if (object instanceof Path) {
                Path path = (Path)object;
                String mimeType = Files.probeContentType(path);
                byteArrays.add(("\"" + entry.getKey() + "\"; filename=\"" + path.getFileName() + "\"\r\nContent-Type: " + mimeType + "\r\n\r\n").getBytes(charset));
                byteArrays.add(Files.readAllBytes(path));
                byteArrays.add("\r\n".getBytes(charset));
                continue;
            }
            byteArrays.add(("\"" + entry.getKey() + "\"\r\n\r\n" + entry.getValue() + "\r\n").getBytes(charset));
        }
        byteArrays.add(("--" + boundary + "--").getBytes(charset));
        return HttpRequest.BodyPublishers.ofByteArrays(byteArrays);
    }

    public static Map<Object, Object> multipartWithFiles(File ... files) {
        LinkedHashMap<Object, Object> data = new LinkedHashMap<Object, Object>();
        for (File file : files) {
            data.put("file", file.toPath());
        }
        return data;
    }

    @Generated
    private JavaHttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

