/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.okhttp;

import com.chavaillaz.client.common.AbstractHttpClient;
import com.chavaillaz.client.common.okhttp.CompletableFutureCallback;
import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.common.utility.Utils;
import com.fasterxml.jackson.databind.JavaType;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class AbstractOkHttpClient
extends AbstractHttpClient
implements AutoCloseable {
    public static final RequestBody EMPTY_BODY = RequestBody.create((String)"", null);
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    public static final MediaType MEDIA_TYPE_XML = MediaType.parse((String)"application/xml");
    protected final OkHttpClient client;

    protected AbstractOkHttpClient(OkHttpClient client, String baseUrl, Authentication authentication) {
        super(baseUrl, authentication);
        this.client = client;
    }

    protected Request.Builder requestBuilder(String url, Object ... parameters) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url(url, parameters).toString()).header("Content-Type", "application/json");
        this.getAuthentication().fillHeaders((arg_0, arg_1) -> ((Request.Builder)requestBuilder).header(arg_0, arg_1));
        Utils.getCookieHeader(this.getAuthentication()).ifPresent(value -> requestBuilder.header("Cookie", value));
        return requestBuilder;
    }

    protected RequestBody body(Object object) {
        return RequestBody.create((String)this.serialize(object), (MediaType)MEDIA_TYPE_JSON);
    }

    protected RequestBody body() {
        return EMPTY_BODY;
    }

    protected <T> CompletableFuture<T> sendAsync(Request.Builder requestBuilder, Class<T> returnType) {
        return this.sendAsync(requestBuilder, this.objectMapper.constructType(returnType));
    }

    protected <T> CompletableFuture<T> sendAsync(Request.Builder requestBuilder, JavaType returnType) {
        return this.sendAsyncBase(requestBuilder).thenApply(response -> this.handleResponse((Response)response, returnType));
    }

    protected CompletableFuture<InputStream> sendAsync(Request.Builder requestBuilder) {
        return ((CompletableFuture)this.sendAsyncBase(requestBuilder).thenApply(Response::body)).thenApply(ResponseBody::byteStream);
    }

    protected CompletableFuture<Response> sendAsyncBase(Request.Builder requestBuilder) {
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        this.client.newCall(requestBuilder.build()).enqueue((Callback)new CompletableFutureCallback(this, completableFuture));
        return completableFuture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T handleResponse(Response response, JavaType type) {
        try (ResponseBody body = response.body();){
            T t = body != null ? (T)this.deserialize(body.string(), type) : null;
            return t;
        }
    }

    @Override
    public void close() throws Exception {
    }
}

