/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.okhttp;

import com.chavaillaz.client.common.AbstractHttpClient;
import com.chavaillaz.client.common.exception.RequestException;
import com.chavaillaz.client.common.exception.ResponseException;
import com.chavaillaz.client.common.okhttp.OkHttpUtils;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableFutureCallback
implements Callback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompletableFutureCallback.class);
    private final AbstractHttpClient client;
    private final CompletableFuture<Response> future;

    public void onResponse(Call call, Response response) {
        log.debug("{} completed: {}", (Object)call.request(), (Object)response);
        if (response.code() >= 400) {
            this.future.completeExceptionally(this.getResponseException(call, response));
        } else {
            this.future.complete(response);
        }
    }

    private ResponseException getResponseException(Call call, Response response) {
        String content = OkHttpUtils.getBodyOrError(response);
        String method = call.request().method();
        String url = call.request().url().uri().toString();
        return this.client.responseException(method, url, response.code(), content);
    }

    public void onFailure(Call call, IOException exception) {
        log.debug("{} failed: {}", (Object)call.request(), (Object)exception.getMessage());
        this.future.completeExceptionally(this.getFailureException(call, exception));
    }

    private RequestException getFailureException(Call call, IOException exception) {
        String method = call.request().method();
        String url = call.request().url().uri().toString();
        return new RequestException(method, url, exception);
    }

    @Generated
    public CompletableFutureCallback(AbstractHttpClient client, CompletableFuture<Response> future) {
        this.client = client;
        this.future = future;
    }
}

