/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.okhttp;

import com.chavaillaz.client.common.utility.ProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Files;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class OkHttpUtils {
    public static OkHttpClient.Builder defaultHttpClientBuilder(ProxyConfiguration proxy) {
        return new OkHttpClient.Builder().proxy((Proxy)Optional.ofNullable(proxy).map(config -> new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getHost(), (int)config.getPort()))).orElse(null)).connectTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(30L)).callTimeout(Duration.ofSeconds(0L));
    }

    public static MultipartBody multipartWithFiles(File ... files) {
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (File file : files) {
            MediaType fileType = MediaType.parse((String)Files.probeContentType(file.toPath()));
            multipartBuilder.addFormDataPart("file", file.getName(), RequestBody.create((File)file, (MediaType)fileType));
        }
        return multipartBuilder.build();
    }

    public static RequestBody formData(Map<Object, Object> data) {
        MultipartBody.Builder form = new MultipartBody.Builder().setType(MultipartBody.FORM);
        data.forEach((key, value) -> form.addFormDataPart(key.toString(), value.toString()));
        return form.build();
    }

    public static String getBody(Response response) throws IOException {
        try (ResponseBody body = response.body();){
            String string = body != null ? body.string() : null;
            return string;
        }
    }

    public static String getBodyOrError(Response response) {
        String string;
        block8: {
            ResponseBody body = response.body();
            try {
                String string2 = string = body != null ? body.string() : null;
                if (body == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            body.close();
        }
        return string;
    }

    @Generated
    private OkHttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

