/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.utility;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ProxyConfiguration {
    public static final Pattern PROXY_PATTERN = Pattern.compile("(https?):\\/\\/(.*):(\\d+)");
    private final String host;
    private final Integer port;
    private final String scheme;

    protected ProxyConfiguration(String scheme, String host, Integer port) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
    }

    public static ProxyConfiguration from(String host, Integer port) {
        return ProxyConfiguration.from(null, host, port);
    }

    public static ProxyConfiguration from(String scheme, String host, Integer port) {
        if (StringUtils.isNotBlank((CharSequence)host) && Objects.nonNull(port)) {
            return new ProxyConfiguration(scheme, host, port);
        }
        return null;
    }

    public static ProxyConfiguration from(String path) {
        Matcher matcher = PROXY_PATTERN.matcher(path);
        if (matcher.find()) {
            return new ProxyConfiguration(matcher.group(1), matcher.group(2), NumberUtils.toInt((String)matcher.group(3)));
        }
        return null;
    }

    public String getUrl() {
        StringBuilder url = new StringBuilder();
        if (this.scheme != null) {
            url.append(this.scheme);
            url.append("://");
        }
        url.append(this.host);
        if (this.port != null) {
            url.append(":");
            url.append(this.port);
        }
        return url.toString();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        return !(this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProxyConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProxyConfiguration(host=" + this.getHost() + ", port=" + this.getPort() + ", scheme=" + this.getScheme() + ")";
    }
}

