/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.utility;

import com.chavaillaz.client.common.exception.AsynchronousException;
import com.chavaillaz.client.common.security.Authentication;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String readInputStream(InputStream inputStream) throws IOException {
        return Utils.readInputStream(inputStream, StandardCharsets.UTF_8);
    }

    public static String readInputStream(InputStream inputStream, Charset charset) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(charset);
    }

    public static String encodeQuery(Map<Object, Object> data) {
        StringBuilder result = new StringBuilder();
        data.forEach((key, value) -> {
            if (!result.isEmpty()) {
                result.append("&");
            }
            String encodedName = URLEncoder.encode(key.toString(), StandardCharsets.UTF_8);
            String encodedValue = URLEncoder.encode(value.toString(), StandardCharsets.UTF_8);
            result.append(encodedName);
            if (encodedValue != null) {
                result.append("=");
                result.append(encodedValue);
            }
        });
        return result.toString();
    }

    public static String encodeBase64(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes());
    }

    public static Optional<String> getCookieHeader(Authentication authentication) {
        ArrayList<Pair<String, String>> cookies = new ArrayList<Pair<String, String>>();
        authentication.fillCookies((key, value) -> cookies.add(Pair.of((Object)key, (Object)value)));
        return Utils.getCookieHeader(cookies);
    }

    public static Optional<String> getCookieHeader(List<Pair<String, String>> cookies) {
        if (cookies.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(cookies.stream().map(pair -> (String)pair.getKey() + "=" + (String)pair.getValue()).collect(Collectors.joining("; ")));
    }

    public static String getProperty(String propertyKey) {
        return Utils.getProperty(propertyKey, null);
    }

    public static String getProperty(String propertyKey, String defaultValue) {
        return Optional.ofNullable(System.getenv(propertyKey)).or(() -> Optional.ofNullable(System.getProperty(propertyKey))).orElse(defaultValue);
    }

    public static void logAsynchronousException(Object result, Throwable throwable) {
        if (throwable != null) {
            log.error("Asynchronous execution failed: {}", (Object)throwable.getMessage(), (Object)new AsynchronousException(throwable));
        } else {
            log.debug("Asynchronous execution completed: {}", result);
        }
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

