/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.vertx;

import com.chavaillaz.client.common.AbstractHttpClient;
import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.common.utility.Utils;
import com.chavaillaz.client.common.vertx.VertxInputStream;
import com.fasterxml.jackson.databind.JavaType;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractVertxHttpClient
extends AbstractHttpClient
implements AutoCloseable {
    protected final WebClient client;

    protected AbstractVertxHttpClient(WebClient client, String baseUrl, Authentication authentication) {
        super(baseUrl, authentication);
        this.client = client;
    }

    protected HttpRequest<Buffer> requestBuilder(HttpMethod method, String url, Object ... parameters) {
        HttpRequest request = this.client.requestAbs(method, this.url(url, parameters).toString()).putHeader("Content-Type", "application/json");
        this.getAuthentication().fillHeaders((arg_0, arg_1) -> ((HttpRequest)request).putHeader(arg_0, arg_1));
        Utils.getCookieHeader(this.getAuthentication()).ifPresent(value -> request.putHeader("Cookie", value));
        return request;
    }

    protected Buffer body(Object object) {
        return Buffer.buffer((String)this.serialize(object));
    }

    protected <T> CompletableFuture<T> handleAsync(Future<HttpResponse<Buffer>> future, Class<T> returnType) {
        return this.handleAsync(future, this.objectMapper.constructType(returnType));
    }

    protected <T> CompletableFuture<T> handleAsync(Future<HttpResponse<Buffer>> future, JavaType returnType) {
        return ((CompletableFuture)this.handleAsyncBase(future).thenApply(HttpResponse::bodyAsString)).thenApply(body -> this.deserialize((String)body, returnType));
    }

    protected CompletableFuture<InputStream> handleAsync(Future<HttpResponse<Buffer>> future) {
        return ((CompletableFuture)this.handleAsyncBase(future).thenApply(HttpResponse::body)).thenApply(VertxInputStream::new);
    }

    protected CompletableFuture<HttpResponse<Buffer>> handleAsyncBase(Future<HttpResponse<Buffer>> future) {
        CompletableFuture<HttpResponse<Buffer>> completableFuture = new CompletableFuture<HttpResponse<Buffer>>();
        future.onSuccess(response -> this.handleResponse((HttpResponse<Buffer>)response, completableFuture)).onFailure(completableFuture::completeExceptionally);
        return completableFuture;
    }

    protected void handleResponse(HttpResponse<Buffer> response, CompletableFuture<HttpResponse<Buffer>> completableFuture) {
        if (response.statusCode() >= 400) {
            completableFuture.completeExceptionally(this.responseException(response.statusCode(), response.bodyAsString()));
        } else {
            completableFuture.complete(response);
        }
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

