/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.common.vertx;

import com.chavaillaz.client.common.utility.ProxyConfiguration;
import io.vertx.core.MultiMap;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.multipart.MultipartForm;
import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class VertxUtils {
    public static WebClientOptions defaultWebClientOptions(ProxyConfiguration proxy) {
        return new WebClientOptions().setProxyOptions((ProxyOptions)Optional.ofNullable(proxy).map(config -> new ProxyOptions().setHost(config.getHost()).setPort(config.getPort().intValue())).orElse(null)).setConnectTimeout(30000).setIdleTimeout(30000);
    }

    public static MultipartForm multipartWithFiles(File ... files) {
        MultipartForm form = MultipartForm.create();
        for (File file : files) {
            form.binaryFileUpload("file", file.getName(), file.getAbsolutePath(), Files.probeContentType(file.toPath()));
        }
        return form;
    }

    public static MultiMap formData(Map<Object, Object> data) {
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        data.forEach((key, value) -> form.set(key.toString(), value.toString()));
        return form;
    }

    @Generated
    private VertxUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

