/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.appender.log4j;

import com.chavaillaz.appender.LogConfiguration;
import com.chavaillaz.appender.LogDelivery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBatchLogDelivery<C extends LogConfiguration>
implements LogDelivery {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractBatchLogDelivery.class);
    private final List<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
    private final C configuration;

    protected AbstractBatchLogDelivery(C configuration) {
        this.configuration = configuration;
    }

    @Override
    public void send(Map<String, Object> document) {
        this.send(Collections.singletonList(document));
    }

    @Override
    public void send(List<Map<String, Object>> documents) {
        if (documents != null && !documents.isEmpty()) {
            this.stackAndSend(documents);
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.batch.isEmpty()) {
            log.debug("Sending partial batch of {}/{}", (Object)this.batch.size(), (Object)this.configuration.getFlushThreshold());
            this.sendBatch();
        }
    }

    private synchronized void stackAndSend(List<Map<String, Object>> data) {
        this.batch.addAll(data);
        log.trace("Stacking batch {}/{}", (Object)this.batch.size(), (Object)this.configuration.getFlushThreshold());
        if ((long)this.batch.size() >= this.configuration.getFlushThreshold()) {
            this.sendBatch();
        }
    }

    private synchronized void sendBatch() {
        if (!this.batch.isEmpty() && this.sendBulk(this.batch)) {
            this.batch.clear();
        }
    }

    protected abstract boolean sendBulk(List<Map<String, Object>> var1);

    @Override
    public void close() throws Exception {
        this.sendBatch();
    }

    @Generated
    public C getConfiguration() {
        return this.configuration;
    }
}

