/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.appender.log4j;

import com.chavaillaz.appender.LogConfiguration;
import com.chavaillaz.appender.LogDelivery;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;

public abstract class AbstractLogDeliveryAppender<C extends LogConfiguration>
extends AbstractAppender {
    private final ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor();
    private final C logConfiguration;
    private LogDelivery logDeliveryHandler;

    protected AbstractLogDeliveryAppender(String name, Filter filter, Layout<?> layout, C configuration) {
        super(name, filter, layout, true, Property.EMPTY_ARRAY);
        this.logConfiguration = configuration;
    }

    public void start() {
        this.startLogDeliveryHandler();
        if (this.logDeliveryHandler != null && this.logConfiguration.getFlushThreshold() > 1L) {
            long interval = this.logConfiguration.getFlushInterval().toMillis();
            this.threadPool.scheduleWithFixedDelay(this.logDeliveryHandler::flush, interval, interval, TimeUnit.MILLISECONDS);
        }
        super.start();
    }

    private void startLogDeliveryHandler() {
        try {
            this.logDeliveryHandler = this.createLogDeliveryHandler();
        }
        catch (Exception e) {
            this.error("Log delivery starting error", e);
        }
    }

    public abstract LogDelivery createLogDeliveryHandler();

    public void append(LogEvent loggingEvent) {
        this.threadPool.submit(this.createLogDeliveryTask(loggingEvent));
    }

    public abstract Runnable createLogDeliveryTask(LogEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(long timeout, TimeUnit timeUnit) {
        try {
            this.stopLogDeliveryHandler();
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            this.error("Thread interrupted during termination", e);
            Thread.currentThread().interrupt();
        }
        finally {
            super.stop(timeout, timeUnit);
        }
        return true;
    }

    private void stopLogDeliveryHandler() {
        try {
            this.logDeliveryHandler.close();
        }
        catch (Exception e) {
            this.error("Log delivery closing error", e);
        }
    }

    @Generated
    public C getLogConfiguration() {
        return this.logConfiguration;
    }

    @Generated
    public LogDelivery getLogDeliveryHandler() {
        return this.logDeliveryHandler;
    }
}

