/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.appender.log4j;

import com.chavaillaz.appender.LogConfiguration;
import com.chavaillaz.appender.log4j.LogConverter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;

public class DefaultLogConverter
implements LogConverter {
    private LogConfiguration configuration;

    @Override
    public void configure(LogConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Map<String, Object> convert(LogEvent event) {
        HashMap<String, Object> document = new HashMap<String, Object>();
        this.writeBasic(document, event);
        this.writeThrowable(document, event);
        this.writeMDC(document, event);
        return document;
    }

    protected void writeBasic(Map<String, Object> document, LogEvent event) {
        document.put("datetime", Instant.ofEpochMilli(event.getInstant().getEpochMillisecond()).toString());
        document.put("host", this.configuration.getHost());
        document.put("environment", this.configuration.getEnvironment());
        document.put("application", this.configuration.getApplication());
        document.put("logger", event.getLoggerFqcn());
        document.put("level", Optional.of(event).map(LogEvent::getLevel).map(Level::toString).orElse(null));
        document.put("logmessage", Optional.of(event).map(LogEvent::getMessage).map(Message::getFormattedMessage).orElse(null));
        document.put("thread", event.getThreadName());
    }

    protected void writeMDC(Map<String, Object> document, LogEvent event) {
        if (event.getContextData() != null) {
            event.getContextData().forEach(document::putIfAbsent);
        }
    }

    protected void writeThrowable(Map<String, Object> document, LogEvent event) {
        Throwable throwable = event.getThrown();
        if (throwable != null) {
            document.put("class", throwable.getClass().getCanonicalName());
            document.put("stacktrace", this.getStackTrace(throwable));
        }
    }

    protected String getStackTrace(Throwable throwable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        throwable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

