/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.appender.log4j.elastic;

import com.chavaillaz.appender.CommonUtils;
import com.chavaillaz.appender.LogConfiguration;
import com.chavaillaz.appender.LogDelivery;
import com.chavaillaz.appender.log4j.AbstractLogDeliveryAppender;
import com.chavaillaz.appender.log4j.DefaultLogConverter;
import com.chavaillaz.appender.log4j.LogConverter;
import com.chavaillaz.appender.log4j.elastic.ElasticsearchConfiguration;
import com.chavaillaz.appender.log4j.elastic.ElasticsearchLogDelivery;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="ElasticsearchAppender", category="Core", elementType="appender")
public class ElasticsearchAppender
extends AbstractLogDeliveryAppender<ElasticsearchConfiguration> {
    protected ElasticsearchAppender(String name, Filter filter, Layout<?> layout, ElasticsearchConfiguration configuration) {
        super(name, filter, layout, (LogConfiguration)configuration);
    }

    @PluginBuilderFactory
    public static Builder builder() {
        return new Builder();
    }

    public LogDelivery createLogDeliveryHandler() {
        return new ElasticsearchLogDelivery((ElasticsearchConfiguration)this.getLogConfiguration());
    }

    public Runnable createLogDeliveryTask(LogEvent loggingEvent) {
        LogConverter converter = ((ElasticsearchConfiguration)this.getLogConfiguration()).getConverter();
        LogEvent immutableEvent = loggingEvent.toImmutable();
        return () -> Optional.ofNullable(this.getLogDeliveryHandler()).ifPresent(handler -> handler.send(converter.convert(immutableEvent)));
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ElasticsearchAppender> {
        @PluginBuilderAttribute
        @Required(message="No appender name provided")
        private String name;
        @PluginElement(value="Layout")
        private Layout<String> layout = PatternLayout.createDefaultLayout();
        @PluginElement(value="Filter")
        private Filter filter;
        @PluginBuilderAttribute(value="Application")
        private String applicationName = CommonUtils.getProperty((String)"APP", (String)"unknown");
        @PluginBuilderAttribute(value="Host")
        private String hostName = CommonUtils.getProperty((String)"HOST", (String)CommonUtils.getInitialHostname());
        @PluginBuilderAttribute(value="Environment")
        private String environmentName = CommonUtils.getProperty((String)"ENV", (String)"local");
        @PluginBuilderAttribute(value="Converter")
        private String elasticConverter = CommonUtils.getProperty((String)"CONVERTER", (String)DefaultLogConverter.class.getName());
        @PluginBuilderAttribute(value="Index")
        private String elasticIndex = CommonUtils.getProperty((String)"INDEX", (String)"ha");
        @PluginBuilderAttribute(value="IndexSuffix")
        private String elasticIndexSuffix = CommonUtils.getProperty((String)"INDEX_SUFFIX", (String)"");
        @PluginBuilderAttribute(value="Url")
        private String elasticUrl = CommonUtils.getProperty((String)"ELASTIC_URL", null);
        @PluginBuilderAttribute(value="User")
        private String elasticUser = CommonUtils.getProperty((String)"ELASTIC_USER", null);
        @PluginBuilderAttribute(value="Password")
        private String elasticPassword = CommonUtils.getProperty((String)"ELASTIC_PASSWORD", null);
        @PluginBuilderAttribute(value="ApiKey")
        private String elasticApiKey = CommonUtils.getProperty((String)"ELASTIC_API_KEY", null);
        @PluginBuilderAttribute(value="FlushThreshold")
        private long flushThreshold = 100L;
        @PluginBuilderAttribute(value="FlushInterval")
        private long flushInterval = 5000L;

        public ElasticsearchAppender build() {
            ElasticsearchConfiguration configuration = new ElasticsearchConfiguration();
            configuration.setApplication(this.getApplicationName());
            configuration.setHost(this.getHostName());
            configuration.setEnvironment(this.getEnvironmentName());
            configuration.setConverter(this.getElasticConverter());
            configuration.setIndex(this.getElasticIndex());
            configuration.setIndexSuffix(this.getElasticIndexSuffix());
            configuration.setUrl(this.getElasticUrl());
            configuration.setUser(this.getElasticUser());
            configuration.setPassword(this.getElasticPassword());
            configuration.setApiKey(this.getElasticApiKey());
            configuration.setFlushThreshold(this.getFlushThreshold());
            configuration.setFlushInterval(Duration.ofMillis(this.getFlushInterval()));
            return new ElasticsearchAppender(this.getName(), this.getFilter(), this.getLayout(), configuration);
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setLayout(Layout<String> layout) {
            this.layout = layout;
        }

        @Generated
        public void setFilter(Filter filter) {
            this.filter = filter;
        }

        @Generated
        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Generated
        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Generated
        public void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Generated
        public void setElasticConverter(String elasticConverter) {
            this.elasticConverter = elasticConverter;
        }

        @Generated
        public void setElasticIndex(String elasticIndex) {
            this.elasticIndex = elasticIndex;
        }

        @Generated
        public void setElasticIndexSuffix(String elasticIndexSuffix) {
            this.elasticIndexSuffix = elasticIndexSuffix;
        }

        @Generated
        public void setElasticUrl(String elasticUrl) {
            this.elasticUrl = elasticUrl;
        }

        @Generated
        public void setElasticUser(String elasticUser) {
            this.elasticUser = elasticUser;
        }

        @Generated
        public void setElasticPassword(String elasticPassword) {
            this.elasticPassword = elasticPassword;
        }

        @Generated
        public void setElasticApiKey(String elasticApiKey) {
            this.elasticApiKey = elasticApiKey;
        }

        @Generated
        public void setFlushThreshold(long flushThreshold) {
            this.flushThreshold = flushThreshold;
        }

        @Generated
        public void setFlushInterval(long flushInterval) {
            this.flushInterval = flushInterval;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Layout<String> getLayout() {
            return this.layout;
        }

        @Generated
        public Filter getFilter() {
            return this.filter;
        }

        @Generated
        public String getApplicationName() {
            return this.applicationName;
        }

        @Generated
        public String getHostName() {
            return this.hostName;
        }

        @Generated
        public String getEnvironmentName() {
            return this.environmentName;
        }

        @Generated
        public String getElasticConverter() {
            return this.elasticConverter;
        }

        @Generated
        public String getElasticIndex() {
            return this.elasticIndex;
        }

        @Generated
        public String getElasticIndexSuffix() {
            return this.elasticIndexSuffix;
        }

        @Generated
        public String getElasticUrl() {
            return this.elasticUrl;
        }

        @Generated
        public String getElasticUser() {
            return this.elasticUser;
        }

        @Generated
        public String getElasticPassword() {
            return this.elasticPassword;
        }

        @Generated
        public String getElasticApiKey() {
            return this.elasticApiKey;
        }

        @Generated
        public long getFlushThreshold() {
            return this.flushThreshold;
        }

        @Generated
        public long getFlushInterval() {
            return this.flushInterval;
        }
    }
}

