/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.appender.log4j.elastic;

import com.chavaillaz.appender.LogConfiguration;
import com.chavaillaz.appender.log4j.DefaultLogConverter;
import com.chavaillaz.appender.log4j.LogConverter;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import lombok.Generated;

public class ElasticsearchConfiguration
implements LogConfiguration {
    private String application;
    private String host;
    private String environment;
    private LogConverter converter;
    private String index;
    private DateTimeFormatter indexSuffix;
    private String url;
    private String user;
    private String password;
    private String apiKey;
    private long flushThreshold;
    private Duration flushInterval;

    public void setConverter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            this.converter = (LogConverter)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.converter = new DefaultLogConverter();
        }
        this.converter.configure((LogConfiguration)this);
    }

    public void setIndexSuffix(String indexSuffix) {
        this.indexSuffix = DateTimeFormatter.ofPattern(Optional.ofNullable(indexSuffix).orElse(""));
    }

    public String generateIndexName(String dateTime) {
        return this.generateIndexName((OffsetDateTime)Optional.ofNullable(dateTime).map(OffsetDateTime::parse).orElse(null));
    }

    public String generateIndexName(OffsetDateTime dateTime) {
        if (dateTime != null && this.getIndexSuffix() != null) {
            return this.getIndex() + dateTime.format(this.getIndexSuffix());
        }
        return this.getIndex();
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public LogConverter getConverter() {
        return this.converter;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public DateTimeFormatter getIndexSuffix() {
        return this.indexSuffix;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public long getFlushThreshold() {
        return this.flushThreshold;
    }

    @Generated
    public Duration getFlushInterval() {
        return this.flushInterval;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Generated
    public void setIndex(String index) {
        this.index = index;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setFlushThreshold(long flushThreshold) {
        this.flushThreshold = flushThreshold;
    }

    @Generated
    public void setFlushInterval(Duration flushInterval) {
        this.flushInterval = flushInterval;
    }
}

