/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.appender.log4j.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import com.chavaillaz.appender.LogConfiguration;
import com.chavaillaz.appender.log4j.AbstractBatchLogDelivery;
import com.chavaillaz.appender.log4j.elastic.ElasticsearchConfiguration;
import com.chavaillaz.appender.log4j.elastic.ElasticsearchUtils;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElasticsearchLogDelivery
extends AbstractBatchLogDelivery<ElasticsearchConfiguration> {
    @Generated
    private static final Logger log = LogManager.getLogger(ElasticsearchLogDelivery.class);
    private final ElasticsearchClient client;

    public ElasticsearchLogDelivery(ElasticsearchConfiguration configuration) {
        this(configuration, ElasticsearchUtils.createClient(configuration));
    }

    public ElasticsearchLogDelivery(ElasticsearchConfiguration configuration, ElasticsearchClient client) {
        super((LogConfiguration)configuration);
        this.client = client;
    }

    protected boolean sendBulk(List<Map<String, Object>> documents) {
        try {
            BulkRequest.Builder builder = new BulkRequest.Builder();
            for (Map<String, Object> document : documents) {
                builder.operations(operation -> operation.index(index -> ((IndexOperation.Builder)index.index(((ElasticsearchConfiguration)this.getConfiguration()).generateIndexName(OffsetDateTime.now()))).document((Object)document)));
            }
            BulkResponse response = this.client.bulk(builder.build());
            if (!response.errors()) {
                log.debug("Bulk of {} elements sent successfully in {}ms", (Object)documents.size(), (Object)response.took());
                return true;
            }
        }
        catch (Exception e) {
            log.warn("Error when sending bulk", (Throwable)e);
        }
        return false;
    }

    public void close() throws Exception {
        super.close();
        if (this.client != null) {
            this.client.close();
        }
    }
}

