/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.appender.log4j.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.chavaillaz.appender.log4j.elastic.ElasticsearchConfiguration;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;

public final class ElasticsearchUtils {
    public static ElasticsearchClient createClient(ElasticsearchConfiguration configuration) {
        if (StringUtils.isNotBlank((CharSequence)configuration.getApiKey())) {
            return ElasticsearchUtils.createClient(configuration.getUrl(), ElasticsearchUtils.createPermissiveContext(), configuration.getApiKey());
        }
        return ElasticsearchUtils.createClient(configuration.getUrl(), ElasticsearchUtils.createPermissiveContext(), configuration.getUser(), configuration.getPassword());
    }

    public static ElasticsearchClient createClient(String url, SSLContext sslContext, String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return ElasticsearchUtils.createClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)url)}).setHttpClientConfigCallback(arg_0 -> ElasticsearchUtils.lambda$createClient$0((CredentialsProvider)credentialsProvider, sslContext, arg_0)).build());
    }

    public static ElasticsearchClient createClient(String url, SSLContext sslContext, String apiKey) {
        BasicHeader headerApiKey = new BasicHeader("Authorization", "ApiKey " + apiKey);
        return ElasticsearchUtils.createClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)url)}).setDefaultHeaders(new Header[]{headerApiKey}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext)).build());
    }

    public static ElasticsearchClient createClient(RestClient restClient) {
        JacksonJsonpMapper jsonMapper = new JacksonJsonpMapper();
        jsonMapper.objectMapper().registerModule((Module)new JavaTimeModule());
        return new ElasticsearchClient((ElasticsearchTransport)new RestClientTransport(restClient, (JsonpMapper)jsonMapper));
    }

    public static SSLContext createPermissiveContext() {
        return new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
    }

    @Generated
    private ElasticsearchUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$0(CredentialsProvider credentialsProvider, SSLContext sslContext, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext);
    }
}

