/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira;

import com.chavaillaz.client.common.Client;
import com.chavaillaz.client.jira.apache.ApacheHttpJiraClient;
import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.api.SearchApi;
import com.chavaillaz.client.jira.api.UserApi;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.Issues;
import com.chavaillaz.client.jira.java.JavaHttpJiraClient;
import com.chavaillaz.client.jira.okhttp.OkHttpJiraClient;
import com.chavaillaz.client.jira.vertx.VertxHttpJiraClient;
import io.vertx.core.Vertx;

public interface JiraClient<I extends Issue>
extends Client<JiraClient<I>> {
    public static ApacheHttpJiraClient<Issue> apacheClient(String jiraUrl) {
        return new ApacheHttpJiraClient<Issue>(jiraUrl, Issue.class);
    }

    public static JavaHttpJiraClient<Issue> javaClient(String jiraUrl) {
        return new JavaHttpJiraClient<Issue>(jiraUrl, Issue.class);
    }

    public static OkHttpJiraClient<Issue> okHttpClient(String jiraUrl) {
        return new OkHttpJiraClient<Issue>(jiraUrl, Issue.class);
    }

    public static VertxHttpJiraClient<Issue> vertxClient(String jiraUrl) {
        return new VertxHttpJiraClient<Issue>(Vertx.vertx(), jiraUrl, Issue.class);
    }

    public IssueApi<I> getIssueApi();

    public SearchApi<Issues<I>> getSearchApi();

    public ProjectApi getProjectApi();

    public UserApi getUserApi();
}

