/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira;

import com.chavaillaz.client.jira.domain.ErrorMessages;
import com.chavaillaz.client.jira.jackson.OffsetDateTimeDeserializer;
import com.chavaillaz.client.jira.jackson.OffsetDateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class JiraConstants {
    public static final String BASE_API = "/rest/api/2/";
    public static final String HEADER_ATLASSIAN_TOKEN = "X-Atlassian-Token";
    public static final String HEADER_ATLASSIAN_TOKEN_DISABLED = "no-check";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final Pattern ERRORS_HTML_PATTERN = Pattern.compile("<div class=\".*aui-message.*\">(?<errors>(.|\\n)*?)<\\/div>");

    public static ObjectMapper jiraObjectMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).addModule((Module)new SimpleModule().addSerializer(OffsetDateTime.class, (JsonSerializer)new OffsetDateTimeSerializer()).addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer()))).serializationInclusion(JsonInclude.Include.NON_NULL)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build();
    }

    public static List<String> extractJsonErrors(String json) {
        try {
            return (List)JiraConstants.jiraObjectMapper().readValue(json, ErrorMessages.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String extractHtmlErrors(String html) {
        return Optional.ofNullable(html).map(ERRORS_HTML_PATTERN::matcher).filter(Matcher::find).map(matcher -> StringUtils.normalizeSpace((String)matcher.group("errors").replaceAll("<[^>]*>", "").replaceAll("\\&[a-z]*\\;", ""))).orElse(null);
    }

    public static Set<String> getNameFields(Class<?> type) {
        return JiraConstants.getDeepFields(type).stream().map(field -> Optional.ofNullable(field.getAnnotation(JsonProperty.class)).map(JsonProperty::value).orElse(field.getName())).collect(Collectors.toSet());
    }

    public static List<Field> getDeepFields(Class<?> type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> deepFields = new ArrayList<Field>(JiraConstants.getDeepFields(type.getSuperclass()));
        List<Field> fields = List.of(type.getDeclaredFields());
        deepFields.addAll(fields);
        return deepFields;
    }

    @Generated
    private JiraConstants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

