/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.apache;

import com.chavaillaz.client.common.apache.ApacheHttpUtils;
import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.apache.AbstractApacheHttpClient;
import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.expand.CommentExpand;
import com.chavaillaz.client.jira.api.expand.IssueExpand;
import com.chavaillaz.client.jira.domain.Attachment;
import com.chavaillaz.client.jira.domain.Attachments;
import com.chavaillaz.client.jira.domain.Comment;
import com.chavaillaz.client.jira.domain.Comments;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.IssueTransition;
import com.chavaillaz.client.jira.domain.Link;
import com.chavaillaz.client.jira.domain.RemoteLink;
import com.chavaillaz.client.jira.domain.RemoteLinks;
import com.chavaillaz.client.jira.domain.Transitions;
import com.chavaillaz.client.jira.domain.User;
import com.chavaillaz.client.jira.domain.Votes;
import com.chavaillaz.client.jira.domain.Watchers;
import com.chavaillaz.client.jira.domain.WorkLog;
import com.chavaillaz.client.jira.domain.WorkLogs;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.http.ContentType;

public class ApacheHttpIssueApi<T extends Issue>
extends AbstractApacheHttpClient
implements IssueApi<T> {
    protected final Class<T> issueType;

    public ApacheHttpIssueApi(CloseableHttpAsyncClient client, String baseUrl, Authentication authentication, Class<T> issueType) {
        super(client, baseUrl, authentication);
        this.issueType = issueType;
    }

    @Override
    public CompletableFuture<Identity> addIssue(T issue) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issue/", new Object[0]).setBody(this.serialize(issue), ContentType.APPLICATION_JSON), Identity.class);
    }

    @Override
    public CompletableFuture<T> getIssue(String issueKey, Set<IssueExpand> expandFlags, Set<String> fields) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}?expand={1}&fields={2}", new Object[]{issueKey, IssueExpand.asParameter(expandFlags), String.join((CharSequence)",", fields)}), this.issueType);
    }

    @Override
    public CompletableFuture<Void> updateIssue(T issue) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.put(), "issue/{0}", new Object[]{((Identity)issue).getKey()}).setBody(this.serialize(issue), ContentType.APPLICATION_JSON), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteIssue(String issueKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "issue/{0}", new Object[]{issueKey}), Void.class);
    }

    @Override
    public CompletableFuture<Void> assignIssue(String issueKey, User user) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.put(), "issue/{0}/assignee", new Object[]{issueKey}).setBody(this.serialize(user), ContentType.APPLICATION_JSON), Void.class);
    }

    @Override
    public CompletableFuture<Transitions> getTransitions(String issueKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/transitions", new Object[]{issueKey}), Transitions.class);
    }

    @Override
    public CompletableFuture<Void> doTransition(String issueKey, IssueTransition<?> transition) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issue/{0}/transitions", new Object[]{issueKey}).setBody(this.serialize(transition), ContentType.APPLICATION_JSON), Void.class);
    }

    @Override
    public CompletableFuture<Comments> getComments(String issueKey, Integer startAt, Integer maxResults, Set<CommentExpand> expandFlags) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/comment?startAt={1}&maxResults={2}&expand={3}", new Object[]{issueKey, startAt, maxResults, CommentExpand.asParameter(expandFlags)}), Comments.class);
    }

    @Override
    public CompletableFuture<Comment> getComment(String issueKey, String id, Set<CommentExpand> expandFlags) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/comment/{1}?expand={2}", new Object[]{issueKey, id, CommentExpand.asParameter(expandFlags)}), Comment.class);
    }

    @Override
    public CompletableFuture<Comment> addComment(String issueKey, Comment comment) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issue/{0}/comment", new Object[]{issueKey}).setBody(this.serialize(comment), ContentType.APPLICATION_JSON), Comment.class);
    }

    @Override
    public CompletableFuture<Comment> updateComment(String issueKey, Comment comment) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.put(), "issue/{0}/comment/{1}", new Object[]{issueKey, comment.getId()}).setBody(this.serialize(comment), ContentType.APPLICATION_JSON), Comment.class);
    }

    @Override
    public CompletableFuture<Void> deleteComment(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "issue/{0}/comment/{1}", new Object[]{issueKey, id}), Void.class);
    }

    @Override
    public CompletableFuture<Void> addVote(String issueKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issue/{0}/votes", new Object[]{issueKey}), Void.class);
    }

    @Override
    public CompletableFuture<Votes> getVotes(String issueKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/votes", new Object[]{issueKey}), Votes.class);
    }

    @Override
    public CompletableFuture<Watchers> getWatchers(String issueKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/watchers", new Object[]{issueKey}), Watchers.class);
    }

    @Override
    public CompletableFuture<Void> addWatcher(String issueKey, String username) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issue/{0}/watchers", new Object[]{issueKey}).setBody(this.serialize(username), ContentType.APPLICATION_JSON), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteWatcher(String issueKey, String username) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "issue/{0}/watchers?username={1}", new Object[]{issueKey, username}), Void.class);
    }

    @Override
    public CompletableFuture<WorkLog> addWorkLog(String issueKey, WorkLog workLog) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issue/{0}/worklog", new Object[]{issueKey}).setBody(this.serialize(workLog), ContentType.APPLICATION_JSON), WorkLog.class);
    }

    @Override
    public CompletableFuture<WorkLogs> getWorkLogs(String issueKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/worklog", new Object[]{issueKey}), WorkLogs.class);
    }

    @Override
    public CompletableFuture<WorkLog> getWorkLog(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/worklog/{1}", new Object[]{issueKey, id}), WorkLog.class);
    }

    @Override
    public CompletableFuture<WorkLog> updateWorkLog(String issueKey, WorkLog workLog) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.put(), "issue/{0}/worklog/{1}", new Object[]{issueKey, workLog.getId()}).setBody(this.serialize(workLog), ContentType.APPLICATION_JSON), WorkLog.class);
    }

    @Override
    public CompletableFuture<Void> deleteWorkLog(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "issue/{0}/worklog/{1}", new Object[]{issueKey, id}), Void.class);
    }

    @Override
    public CompletableFuture<Attachment> getAttachment(String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "attachment/{0}", new Object[]{id}), Attachment.class);
    }

    @Override
    public CompletableFuture<InputStream> getAttachmentContent(String url) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), url, new Object[0]));
    }

    @Override
    public CompletableFuture<Attachments> addAttachment(String issueKey, File ... files) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issue/{0}/attachments", new Object[]{issueKey}), ApacheHttpUtils.multipartWithFiles((File[])files), Attachments.class);
    }

    @Override
    public CompletableFuture<Void> deleteAttachment(String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "attachment/{0}", new Object[]{id}), Void.class);
    }

    @Override
    public CompletableFuture<RemoteLinks> getRemoteLinks(String issueKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/remotelink", new Object[]{issueKey}), RemoteLinks.class);
    }

    @Override
    public CompletableFuture<RemoteLink> getRemoteLink(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issue/{0}/remotelink/{1}", new Object[]{issueKey, id}), RemoteLink.class);
    }

    @Override
    public CompletableFuture<Identity> addRemoteLink(String issueKey, RemoteLink remoteLink) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issue/{0}/remotelink", new Object[]{issueKey}).setBody(this.serialize(remoteLink), ContentType.APPLICATION_JSON), Identity.class);
    }

    @Override
    public CompletableFuture<Void> updateRemoteLink(String issueKey, RemoteLink remoteLink) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.put(), "issue/{0}/remotelink/{1}", new Object[]{issueKey, remoteLink.getId()}).setBody(this.serialize(remoteLink), ContentType.APPLICATION_JSON), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteRemoteLink(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "issue/{0}/remotelink/{1}", new Object[]{issueKey, id}), Void.class);
    }

    @Override
    public CompletableFuture<Link> getIssueLink(String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "issueLink/{0}", new Object[]{id}), Link.class);
    }

    @Override
    public CompletableFuture<Void> addIssueLink(Link link) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "issueLink/", new Object[0]).setBody(this.serialize(link), ContentType.APPLICATION_JSON), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteIssueLink(String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "issueLink/{0}", new Object[]{id}), Void.class);
    }
}

