/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.apache;

import com.chavaillaz.client.common.apache.ApacheHttpUtils;
import com.chavaillaz.client.common.utility.ProxyConfiguration;
import com.chavaillaz.client.jira.AbstractJiraClient;
import com.chavaillaz.client.jira.apache.ApacheHttpIssueApi;
import com.chavaillaz.client.jira.apache.ApacheHttpProjectApi;
import com.chavaillaz.client.jira.apache.ApacheHttpSearchApi;
import com.chavaillaz.client.jira.apache.ApacheHttpUserApi;
import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.api.SearchApi;
import com.chavaillaz.client.jira.api.UserApi;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.Issues;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;

public class ApacheHttpJiraClient<I extends Issue>
extends AbstractJiraClient<CloseableHttpAsyncClient, I> {
    public ApacheHttpJiraClient(String jiraUrl, Class<I> issueType) {
        super(jiraUrl, issueType);
    }

    public CloseableHttpAsyncClient newHttpClient() {
        return ApacheHttpUtils.defaultHttpClientBuilder((ProxyConfiguration)this.proxy).build();
    }

    @Override
    public IssueApi<I> getIssueApi() {
        return (IssueApi)this.issueApi.get(() -> new ApacheHttpIssueApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication, this.issueType));
    }

    @Override
    public ProjectApi getProjectApi() {
        return (ProjectApi)this.projectApi.get(() -> new ApacheHttpProjectApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication));
    }

    @Override
    public UserApi getUserApi() {
        return (UserApi)this.userApi.get(() -> new ApacheHttpUserApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication));
    }

    @Override
    public SearchApi<Issues<I>> getSearchApi() {
        return (SearchApi)this.searchApi.get(() -> new ApacheHttpSearchApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication, this.issuesListType));
    }
}

