/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.apache;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.apache.AbstractApacheHttpClient;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.domain.Components;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Project;
import com.chavaillaz.client.jira.domain.ProjectChange;
import com.chavaillaz.client.jira.domain.Projects;
import com.chavaillaz.client.jira.domain.Roles;
import com.chavaillaz.client.jira.domain.Statuses;
import com.chavaillaz.client.jira.domain.Versions;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.http.ContentType;

public class ApacheHttpProjectApi
extends AbstractApacheHttpClient
implements ProjectApi {
    public ApacheHttpProjectApi(CloseableHttpAsyncClient client, String baseUrl, Authentication authentication) {
        super(client, baseUrl, authentication);
    }

    @Override
    public CompletableFuture<Identity> addProject(ProjectChange project) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "project", new Object[0]).setBody(this.serialize(project), ContentType.APPLICATION_JSON), Identity.class);
    }

    @Override
    public CompletableFuture<Projects> getProjects(boolean includeArchived, String expand) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "project?includeArchived={0}&expand={1}", new Object[]{includeArchived, expand}), Projects.class);
    }

    @Override
    public CompletableFuture<Project> getProject(String projectKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "project/{0}", new Object[]{projectKey}), Project.class);
    }

    @Override
    public CompletableFuture<Versions> getProjectVersions(String projectKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "project/{0}/versions", new Object[]{projectKey}), Versions.class);
    }

    @Override
    public CompletableFuture<Components> getProjectComponents(String projectKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "project/{0}/components", new Object[]{projectKey}), Components.class);
    }

    @Override
    public CompletableFuture<Statuses> getProjectStatuses(String projectKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "project/{0}/statuses", new Object[]{projectKey}), Statuses.class);
    }

    @Override
    public CompletableFuture<Roles> getProjectRoles(String projectKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "project/{0}/role", new Object[]{projectKey}), Roles.class);
    }

    @Override
    public CompletableFuture<Project> updateProject(String projectKey, ProjectChange project) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.put(), "project/{0}", new Object[]{projectKey}).setBody(this.serialize(project), ContentType.APPLICATION_JSON), Project.class);
    }

    @Override
    public CompletableFuture<Void> deleteProject(String projectKey) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "project/{0}", new Object[]{projectKey}), Void.class);
    }
}

